/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.shaded.com.google.common.graph;

import com.google.errorprone.annotations.DoNotMock;
import org.apache.kylin.shaded.com.google.common.annotations.Beta;
import org.apache.kylin.shaded.com.google.common.base.Optional;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.graph.AbstractGraphBuilder;
import org.apache.kylin.shaded.com.google.common.graph.ConfigurableMutableGraph;
import org.apache.kylin.shaded.com.google.common.graph.ElementOrder;
import org.apache.kylin.shaded.com.google.common.graph.Graph;
import org.apache.kylin.shaded.com.google.common.graph.Graphs;
import org.apache.kylin.shaded.com.google.common.graph.ImmutableGraph;
import org.apache.kylin.shaded.com.google.common.graph.MutableGraph;

@DoNotMock
@Beta
public final class GraphBuilder<N>
extends AbstractGraphBuilder<N> {
    private GraphBuilder(boolean directed) {
        super(directed);
    }

    public static GraphBuilder<Object> directed() {
        return new GraphBuilder<Object>(true);
    }

    public static GraphBuilder<Object> undirected() {
        return new GraphBuilder<Object>(false);
    }

    public static <N> GraphBuilder<N> from(Graph<N> graph) {
        return new GraphBuilder<N>(graph.isDirected()).allowsSelfLoops(graph.allowsSelfLoops()).nodeOrder(graph.nodeOrder());
    }

    public <N1 extends N> ImmutableGraph.Builder<N1> immutable() {
        GraphBuilder<N1> castBuilder = this.cast();
        return new ImmutableGraph.Builder<N1>(castBuilder);
    }

    public GraphBuilder<N> allowsSelfLoops(boolean allowsSelfLoops) {
        this.allowsSelfLoops = allowsSelfLoops;
        return this;
    }

    public GraphBuilder<N> expectedNodeCount(int expectedNodeCount) {
        this.expectedNodeCount = Optional.of(Graphs.checkNonNegative(expectedNodeCount));
        return this;
    }

    public <N1 extends N> GraphBuilder<N1> nodeOrder(ElementOrder<N1> nodeOrder) {
        GraphBuilder<N1> newBuilder2 = this.cast();
        newBuilder2.nodeOrder = Preconditions.checkNotNull(nodeOrder);
        return newBuilder2;
    }

    <N1 extends N> GraphBuilder<N1> incidentEdgeOrder(ElementOrder<N1> incidentEdgeOrder) {
        Preconditions.checkArgument(incidentEdgeOrder.type() == ElementOrder.Type.UNORDERED || incidentEdgeOrder.type() == ElementOrder.Type.STABLE, "The given elementOrder (%s) is unsupported. incidentEdgeOrder() only supports ElementOrder.unordered() and ElementOrder.stable().", incidentEdgeOrder);
        GraphBuilder<N1> newBuilder2 = this.cast();
        newBuilder2.incidentEdgeOrder = Preconditions.checkNotNull(incidentEdgeOrder);
        return newBuilder2;
    }

    public <N1 extends N> MutableGraph<N1> build() {
        return new ConfigurableMutableGraph(this);
    }

    GraphBuilder<N> copy() {
        GraphBuilder<N> newBuilder2 = new GraphBuilder<N>(this.directed);
        newBuilder2.allowsSelfLoops = this.allowsSelfLoops;
        newBuilder2.nodeOrder = this.nodeOrder;
        newBuilder2.expectedNodeCount = this.expectedNodeCount;
        newBuilder2.incidentEdgeOrder = this.incidentEdgeOrder;
        return newBuilder2;
    }

    private <N1 extends N> GraphBuilder<N1> cast() {
        return this;
    }
}

