/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.rest.security.AclPermission;
import org.springframework.security.acls.domain.DefaultPermissionFactory;
import org.springframework.security.acls.model.Permission;

public class AclPermissionFactory
extends DefaultPermissionFactory {
    public AclPermissionFactory() {
        this.registerPublicPermissions(AclPermission.class);
    }

    public static List<Permission> getPermissions() {
        Field[] fields2;
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (Field field : fields2 = AclPermission.class.getFields()) {
            try {
                Object fieldValue = field.get(null);
                if (!Permission.class.isAssignableFrom(fieldValue.getClass())) continue;
                Permission perm = (Permission)fieldValue;
                String permissionName = field.getName();
                if (!permissionName.equals("ADMINISTRATION") && !permissionName.equals("MANAGEMENT") && !permissionName.equals("OPERATION") && !permissionName.equals("READ")) continue;
                permissions.add(perm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return permissions;
    }

    public static Permission getPermission(String perName) {
        Field[] fields2;
        for (Field field : fields2 = AclPermission.class.getFields()) {
            try {
                Object fieldValue = field.get(null);
                if (!Permission.class.isAssignableFrom(fieldValue.getClass()) || !perName.equals(field.getName())) continue;
                return (Permission)fieldValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

