/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.query.util.QueryUtil;

public class DefaultQueryTransformer
implements QueryUtil.IQueryTransformer {
    private static final String S0 = "\\s*";
    private static final String S1 = "\\s";
    private static final String SM = "\\s+";
    private static final Pattern PTN_GROUP_BY = Pattern.compile("\\sGROUP\\s+BY\\s", 2);
    private static final Pattern PTN_HAVING_COUNT_GREATER_THAN_ZERO = Pattern.compile("\\sHAVING\\s+[(]?\\s*COUNT\\s*[(]\\s*1\\s*[)]\\s*>\\s*0\\s*[)]?", 2);
    private static final Pattern PTN_SUM_1 = Pattern.compile("\\s*SUM\\s*[(]\\s*[1]\\s*[)]\\s*", 2);
    private static final Pattern PTN_MIN_1 = Pattern.compile("\\s*MIN\\s*[(]\\s*[1]\\s*[)]\\s*", 2);
    private static final Pattern PTN_MAX_1 = Pattern.compile("\\s*MAX\\s*[(]\\s*[1]\\s*[)]\\s*", 2);
    private static final Pattern PTN_NOT_EQ = Pattern.compile("\\s*!=\\s*", 2);
    private static final Pattern PTN_INTERVAL = Pattern.compile("interval\\s+(floor\\()([\\d\\.]+)(\\))\\s+(second|minute|hour|day|month|year)", 2);
    private static final Pattern PTN_HAVING_ESCAPE_FUNCTION = Pattern.compile("\\{fn\\s+(EXTRACT\\(.*?\\)||CURRENT_TIMESTAMP\\(.*?\\))\\}", 2);
    private static final Pattern PIN_SUM_OF_CAST = Pattern.compile("\\s*SUM\\s*\\(\\s*CAST\\s*\\(\\s*([^\\s,]+)\\s*AS\\s+DOUBLE\\s*\\)\\s*\\)", 2);
    private static final Pattern PIN_SUM_OF_FN_CONVERT = Pattern.compile("\\s*SUM\\s*\\(\\s*\\{\\s*fn\\s+convert\\s*\\(\\s*([^\\s,]+)\\s*,\\s*(SQL_DOUBLE|SQL_BIGINT)\\s*\\)\\s*\\}\\s*\\)", 2);

    @Override
    public String transform(String sql2, String project, String defaultSchema) {
        Matcher m;
        while ((m = PIN_SUM_OF_CAST.matcher(sql2)).find()) {
            sql2 = sql2.substring(0, m.start()) + " SUM(" + m.group(1).trim() + ")" + sql2.substring(m.end(), sql2.length());
        }
        while ((m = PIN_SUM_OF_FN_CONVERT.matcher(sql2)).find()) {
            sql2 = sql2.substring(0, m.start()) + " SUM(" + m.group(1).trim() + ")" + sql2.substring(m.end(), sql2.length());
        }
        while ((m = PTN_HAVING_ESCAPE_FUNCTION.matcher(sql2)).find()) {
            sql2 = sql2.substring(0, m.start()) + m.group(1) + sql2.substring(m.end());
        }
        m = PTN_HAVING_COUNT_GREATER_THAN_ZERO.matcher(sql2);
        if (m.find() && !PTN_GROUP_BY.matcher(sql2).find()) {
            sql2 = sql2.substring(0, m.start()) + " " + sql2.substring(m.end());
        }
        while ((m = PTN_SUM_1.matcher(sql2)).find()) {
            sql2 = sql2.substring(0, m.start()) + " COUNT(1) " + sql2.substring(m.end());
        }
        while ((m = PTN_MIN_1.matcher(sql2)).find()) {
            sql2 = sql2.substring(0, m.start()) + " 1 " + sql2.substring(m.end());
        }
        while ((m = PTN_MAX_1.matcher(sql2)).find()) {
            sql2 = sql2.substring(0, m.start()) + " 1 " + sql2.substring(m.end());
        }
        while ((m = PTN_NOT_EQ.matcher(sql2)).find()) {
            sql2 = sql2.substring(0, m.start()) + " <> " + sql2.substring(m.end());
        }
        while ((m = PTN_INTERVAL.matcher(sql2)).find()) {
            int value = (int)Math.floor(Double.parseDouble(m.group(2)));
            sql2 = sql2.substring(0, m.start(1)) + "'" + value + "'" + sql2.substring(m.end(3));
        }
        return sql2;
    }
}

