/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.runtime;

import java.util.Locale;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.kylin.engine.spark.cross.CrossDateTimeUtils$;
import org.apache.kylin.query.util.UnsupportedSparkFunctionException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.KylinFunctions$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IfNull;
import org.apache.spark.sql.catalyst.expressions.StringLocate;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.utils.SparkTypeUtil$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ExpressionConverter$ {
    public static final ExpressionConverter$ MODULE$;
    private final HashSet<String> unaryParameterFunc;
    private final HashSet<String> ternaryParameterFunc;
    private final HashSet<String> binaryParameterFunc;
    private final HashSet<String> noneParameterfunc;
    private final HashSet<String> varArgsFunc;

    static {
        new ExpressionConverter$();
    }

    public HashSet<String> unaryParameterFunc() {
        return this.unaryParameterFunc;
    }

    public HashSet<String> ternaryParameterFunc() {
        return this.ternaryParameterFunc;
    }

    public HashSet<String> binaryParameterFunc() {
        return this.binaryParameterFunc;
    }

    public HashSet<String> noneParameterfunc() {
        return this.noneParameterfunc;
    }

    public HashSet<String> varArgsFunc() {
        return this.varArgsFunc;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object convert(SqlTypeName sqlTypeName, RelDataType relDataType, SqlKind op, String opName, Seq<Object> children) {
        SqlKind sqlKind = op;
        if (SqlKind.IS_NULL.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 1);
            return KylinFunctions$.MODULE$.k_lit(children.head()).isNull();
        }
        if (SqlKind.IS_NOT_NULL.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 1);
            return KylinFunctions$.MODULE$.k_lit(children.head()).isNotNull();
        }
        if (SqlKind.LIKE.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 2);
            return KylinFunctions$.MODULE$.k_like(KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.last()));
        }
        if (SqlKind.MINUS_PREFIX.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 1);
            return functions$.MODULE$.negate(KylinFunctions$.MODULE$.k_lit(children.head()));
        }
        if (SqlKind.IN.equals(sqlKind)) {
            Seq values = (Seq)((TraversableLike)children.drop(1)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Expression apply(Object c) {
                    return KylinFunctions$.MODULE$.k_lit(c).expr();
                }
            }, Seq$.MODULE$.canBuildFrom());
            return KylinFunctions$.MODULE$.in(KylinFunctions$.MODULE$.k_lit(children.head()).expr(), (Seq<Expression>)values);
        }
        if (SqlKind.NOT_IN.equals(sqlKind)) {
            Seq values = (Seq)((TraversableLike)children.drop(1)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Expression apply(Object c) {
                    return KylinFunctions$.MODULE$.k_lit(c).expr();
                }
            }, Seq$.MODULE$.canBuildFrom());
            return functions$.MODULE$.not(KylinFunctions$.MODULE$.in(KylinFunctions$.MODULE$.k_lit(children.head()).expr(), (Seq<Expression>)values));
        }
        if (SqlKind.DIVIDE.equals(sqlKind)) {
            Predef$.MODULE$.assert(children.size() == 2);
            return KylinFunctions$.MODULE$.k_lit(children.head()).divide((Object)KylinFunctions$.MODULE$.k_lit(children.last()));
        }
        if (SqlKind.CASE.equals(sqlKind)) {
            Seq evens = (Seq)((TraversableLike)((TraversableLike)children.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> p) {
                    return p._2$mcI$sp() % 2 == 0;
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(Tuple2<Object, Object> p) {
                    return KylinFunctions$.MODULE$.k_lit(p._1());
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq odds = (Seq)((TraversableLike)((TraversableLike)children.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> p) {
                    return p._2$mcI$sp() % 2 == 1;
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(Tuple2<Object, Object> p) {
                    return KylinFunctions$.MODULE$.k_lit(p._1());
                }
            }, Seq$.MODULE$.canBuildFrom());
            Predef$.MODULE$.assert(evens.length() == odds.length() + 1);
            Seq zip = (Seq)evens.zip((GenIterable)odds, Seq$.MODULE$.canBuildFrom());
            ObjectRef column = ObjectRef.create(null);
            if (!zip.nonEmpty()) return ((Column)column.elem).otherwise(evens.last());
            column.elem = functions$.MODULE$.when((Column)((Tuple2)zip.head())._1(), ((Tuple2)zip.head())._2());
            ((IterableLike)zip.drop(1)).foreach((Function1)new Serializable(column){
                public static final long serialVersionUID = 0L;
                private final ObjectRef column$1;

                public final void apply(Tuple2<Column, Column> p) {
                    this.column$1.elem = ((Column)this.column$1.elem).when((Column)p._1(), p._2());
                }
                {
                    this.column$1 = column$1;
                }
            });
            return ((Column)column.elem).otherwise(evens.last());
        }
        if (SqlKind.EXTRACT.equals(sqlKind)) {
            Column column;
            String timeUnit = (String)children.head();
            Object inputAsTS = children.apply(1);
            String string = timeUnit;
            if ("YEAR".equals(string)) {
                column = functions$.MODULE$.year(KylinFunctions$.MODULE$.k_lit(inputAsTS));
                return column;
            } else if ("QUARTER".equals(string)) {
                column = functions$.MODULE$.quarter(KylinFunctions$.MODULE$.k_lit(inputAsTS));
                return column;
            } else if ("MONTH".equals(string)) {
                column = functions$.MODULE$.month(KylinFunctions$.MODULE$.k_lit(inputAsTS));
                return column;
            } else if ("WEEK".equals(string)) {
                column = functions$.MODULE$.weekofyear(KylinFunctions$.MODULE$.k_lit(inputAsTS));
                return column;
            } else if ("DOY".equals(string)) {
                column = functions$.MODULE$.dayofyear(KylinFunctions$.MODULE$.k_lit(inputAsTS));
                return column;
            } else if ("DAY".equals(string)) {
                column = functions$.MODULE$.dayofmonth(KylinFunctions$.MODULE$.k_lit(inputAsTS));
                return column;
            } else if ("DOW".equals(string)) {
                column = KylinFunctions$.MODULE$.kylin_day_of_week(KylinFunctions$.MODULE$.k_lit(inputAsTS));
                return column;
            } else if ("HOUR".equals(string)) {
                column = functions$.MODULE$.hour(KylinFunctions$.MODULE$.k_lit(inputAsTS));
                return column;
            } else if ("MINUTE".equals(string)) {
                column = functions$.MODULE$.minute(KylinFunctions$.MODULE$.k_lit(inputAsTS));
                return column;
            } else {
                if (!"SECOND".equals(string)) void var14_14;
                throw new UnsupportedSparkFunctionException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported function ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var14_14})));
                column = functions$.MODULE$.second(KylinFunctions$.MODULE$.k_lit(inputAsTS));
            }
            return column;
        }
        if (SqlKind.REINTERPRET.equals(sqlKind)) {
            return KylinFunctions$.MODULE$.k_lit(children.head());
        }
        if (SqlKind.CAST.equals(sqlKind)) {
            DataType goalType = SparkTypeUtil$.MODULE$.convertSqlTypeToSparkType(relDataType);
            return KylinFunctions$.MODULE$.k_lit(children.head()).cast(goalType);
        }
        if (SqlKind.TRIM.equals(sqlKind)) {
            Column column;
            if (children.length() == 3) {
                Column column2;
                Object object = children.head();
                if ("TRAILING".equals(object)) {
                    column2 = functions$.MODULE$.rtrim(KylinFunctions$.MODULE$.k_lit(children.last()));
                } else if ("LEADING".equals(object)) {
                    column2 = functions$.MODULE$.ltrim(KylinFunctions$.MODULE$.k_lit(children.last()));
                } else {
                    if (!"BOTH".equals(object)) throw new MatchError(object);
                    column2 = functions$.MODULE$.trim(KylinFunctions$.MODULE$.k_lit(children.last()));
                }
                column = column2;
                return column;
            } else {
                column = functions$.MODULE$.trim(KylinFunctions$.MODULE$.k_lit(children.head()));
            }
            return column;
        }
        if (SqlKind.OTHER.equals(sqlKind)) {
            String funcName = opName.toLowerCase(Locale.ROOT);
            String string = funcName;
            if (!"||".equals(string)) void var21_21;
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported function ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var21_21})));
            Column column = functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1))}));
            return column;
        }
        if (SqlKind.OTHER_FUNCTION.equals(sqlKind)) {
            Column column;
            String funcName = opName.toLowerCase(Locale.ROOT);
            String string = funcName;
            if ("abs".equals(string)) {
                column = functions$.MODULE$.abs(KylinFunctions$.MODULE$.k_lit(children.head()).cast(SparkTypeUtil$.MODULE$.convertSqlTypeToSparkType(relDataType)));
                return column;
            } else if ("round".equals(string)) {
                column = functions$.MODULE$.round(KylinFunctions$.MODULE$.k_lit(children.head()), BoxesRunTime.unboxToInt((Object)children.apply(1)));
                return column;
            } else if ("truncate".equals(string)) {
                column = KylinFunctions$.MODULE$.kylin_truncate(KylinFunctions$.MODULE$.k_lit(children.head()), BoxesRunTime.unboxToInt((Object)children.apply(1)));
                return column;
            } else if ("cot".equals(string)) {
                column = KylinFunctions$.MODULE$.k_lit(BoxesRunTime.boxToInteger((int)1)).divide((Object)functions$.MODULE$.tan(KylinFunctions$.MODULE$.k_lit(children.head())));
                return column;
            } else if ("isnull".equals(string)) {
                column = functions$.MODULE$.isnull(KylinFunctions$.MODULE$.k_lit(children.head()));
                return column;
            } else if ("ifnull".equals(string)) {
                column = new Column((Expression)new IfNull(KylinFunctions$.MODULE$.k_lit(children.head()).expr(), KylinFunctions$.MODULE$.k_lit(children.apply(1)).expr()));
                return column;
            } else if ("lower".equals(string)) {
                column = functions$.MODULE$.lower(KylinFunctions$.MODULE$.k_lit(children.head()));
                return column;
            } else if ("upper".equals(string)) {
                column = functions$.MODULE$.upper(KylinFunctions$.MODULE$.k_lit(children.head()));
                return column;
            } else if ("char_length".equals(string)) {
                column = functions$.MODULE$.length(KylinFunctions$.MODULE$.k_lit(children.head()));
                return column;
            } else if ("character_length".equals(string)) {
                column = functions$.MODULE$.length(KylinFunctions$.MODULE$.k_lit(children.head()));
                return column;
            } else if ("replace".equals(string)) {
                column = functions$.MODULE$.regexp_replace(KylinFunctions$.MODULE$.k_lit(children.head()), (String)children.apply(1), (String)children.apply(2));
                return column;
            } else {
                boolean bl = "substring".equals(string) ? true : "substr".equals(string);
                if (bl) {
                    Column column3;
                    if (children.length() == 3) {
                        column3 = KylinFunctions$.MODULE$.k_lit(children.head()).substr(KylinFunctions$.MODULE$.k_lit(children.apply(1)), KylinFunctions$.MODULE$.k_lit(children.apply(2)));
                    } else {
                        if (children.length() != 2) throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"substring must provide three or two parameters under sparder"})).s((Seq)Nil$.MODULE$));
                        column3 = KylinFunctions$.MODULE$.k_lit(children.head()).substr(KylinFunctions$.MODULE$.k_lit(children.apply(1)), KylinFunctions$.MODULE$.k_lit(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)));
                    }
                    column = column3;
                    return column;
                } else if ("initcapb".equals(string)) {
                    column = functions$.MODULE$.initcap(KylinFunctions$.MODULE$.k_lit(children.head()));
                    return column;
                } else if ("instr".equals(string)) {
                    int instr = children.length() == 2 ? 1 : BoxesRunTime.unboxToInt((Object)children.apply(2));
                    column = new Column((Expression)new StringLocate(KylinFunctions$.MODULE$.k_lit(children.apply(1)).expr(), KylinFunctions$.MODULE$.k_lit(children.head()).expr(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)instr)).expr()));
                    return column;
                } else if ("length".equals(string)) {
                    column = functions$.MODULE$.length(KylinFunctions$.MODULE$.k_lit(children.head()));
                    return column;
                } else if ("strpos".equals(string)) {
                    int pos = children.length() == 2 ? 1 : BoxesRunTime.unboxToInt((Object)children.apply(2));
                    column = new Column((Expression)new StringLocate(KylinFunctions$.MODULE$.k_lit(children.apply(1)).expr(), KylinFunctions$.MODULE$.k_lit(children.head()).expr(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)pos)).expr()));
                    return column;
                } else if ("position".equals(string)) {
                    int pos = children.length() == 2 ? 0 : BoxesRunTime.unboxToInt((Object)children.apply(2));
                    column = new Column((Expression)new StringLocate(KylinFunctions$.MODULE$.k_lit(children.head()).expr(), KylinFunctions$.MODULE$.k_lit(children.apply(1)).expr(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)pos)).expr()));
                    return column;
                } else if ("concat".equals(string)) {
                    column = functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1))}));
                    return column;
                } else if ("split_part".equals(string)) {
                    Column[] args = (Column[])((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KylinFunctions$.MODULE$.k_lit(children.head()), functions$.MODULE$.lit(children.apply(1)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)children.apply(2))))}))).toArray(ClassTag$.MODULE$.apply(Column.class));
                    column = functions$.MODULE$.callUDF("split_part", (Seq)Predef$.MODULE$.wrapRefArray((Object[])args));
                    return column;
                } else if ("current_date".equals(string)) {
                    column = KylinFunctions$.MODULE$.k_lit(CrossDateTimeUtils$.MODULE$.dateToString());
                    return column;
                } else if ("current_timestamp".equals(string)) {
                    column = functions$.MODULE$.current_timestamp();
                    return column;
                } else if ("to_timestamp".equals(string)) {
                    Column column4;
                    if (children.length() == 1) {
                        column4 = functions$.MODULE$.to_timestamp(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else {
                        if (children.length() != 2) throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to_timestamp must provide one or two parameters under sparder"})).s((Seq)Nil$.MODULE$));
                        column4 = functions$.MODULE$.to_timestamp(KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1)).toString());
                    }
                    column = column4;
                    return column;
                } else if ("to_date".equals(string)) {
                    Column column5;
                    if (children.length() == 1) {
                        column5 = functions$.MODULE$.to_date(KylinFunctions$.MODULE$.k_lit(children.head()));
                    } else {
                        if (children.length() != 2) throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to_date must provide one or two parameters under sparder"})).s((Seq)Nil$.MODULE$));
                        column5 = functions$.MODULE$.to_date(KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1)).toString());
                    }
                    column = column5;
                    return column;
                } else {
                    boolean bl2 = "to_char".equals(string) ? true : "date_format".equals(string);
                    if (bl2) {
                        String string2 = KylinFunctions$.MODULE$.k_lit(children.apply(1)).toString().toUpperCase(Locale.ROOT);
                        String string3 = "YEAR".equals(string2) ? "y" : ("MONTH".equals(string2) ? "M" : ("DAY".equals(string2) ? "d" : ("HOUR".equals(string2) ? "h" : ("MINUTE".equals(string2) ? "m" : ("MINUTES".equals(string2) ? "m" : ("SECOND".equals(string2) ? "s" : ("SECONDS".equals(string2) ? "s" : KylinFunctions$.MODULE$.k_lit(children.apply(1)).toString())))))));
                        String part = string3;
                        column = functions$.MODULE$.date_format(KylinFunctions$.MODULE$.k_lit(children.head()), part);
                        return column;
                    } else if ("power".equals(string)) {
                        column = functions$.MODULE$.pow(KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1)));
                        return column;
                    } else if ("log10".equals(string)) {
                        column = functions$.MODULE$.log10(KylinFunctions$.MODULE$.k_lit(children.head()));
                        return column;
                    } else if ("ln".equals(string)) {
                        column = functions$.MODULE$.log(Math.E, KylinFunctions$.MODULE$.k_lit(children.head()));
                        return column;
                    } else if ("exp".equals(string)) {
                        column = functions$.MODULE$.exp(KylinFunctions$.MODULE$.k_lit(children.head()));
                        return column;
                    } else if ("acos".equals(string)) {
                        column = functions$.MODULE$.acos(KylinFunctions$.MODULE$.k_lit(children.head()));
                        return column;
                    } else if ("asin".equals(string)) {
                        column = functions$.MODULE$.asin(KylinFunctions$.MODULE$.k_lit(children.head()));
                        return column;
                    } else if ("atan".equals(string)) {
                        column = functions$.MODULE$.atan(KylinFunctions$.MODULE$.k_lit(children.head()));
                        return column;
                    } else if ("atan2".equals(string)) {
                        Predef$.MODULE$.assert(children.size() == 2);
                        column = functions$.MODULE$.atan2(KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.last()));
                        return column;
                    } else if ("cos".equals(string)) {
                        column = functions$.MODULE$.cos(KylinFunctions$.MODULE$.k_lit(children.head()));
                        return column;
                    } else if ("degrees".equals(string)) {
                        column = functions$.MODULE$.degrees(KylinFunctions$.MODULE$.k_lit(children.head()));
                        return column;
                    } else if ("radians".equals(string)) {
                        column = functions$.MODULE$.radians(KylinFunctions$.MODULE$.k_lit(children.head()));
                        return column;
                    } else if ("sign".equals(string)) {
                        column = functions$.MODULE$.signum(KylinFunctions$.MODULE$.k_lit(children.head()));
                        return column;
                    } else if ("tan".equals(string)) {
                        column = functions$.MODULE$.tan(KylinFunctions$.MODULE$.k_lit(children.head()));
                        return column;
                    } else if ("sin".equals(string)) {
                        column = functions$.MODULE$.sin(KylinFunctions$.MODULE$.k_lit(children.head()));
                        return column;
                    } else if (this.noneParameterfunc().contains((Object)string)) {
                        column = functions$.MODULE$.callUDF(string, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
                        return column;
                    } else if (this.unaryParameterFunc().contains((Object)string)) {
                        column = functions$.MODULE$.callUDF(string, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KylinFunctions$.MODULE$.k_lit(children.head())}));
                        return column;
                    } else if (this.binaryParameterFunc().contains((Object)string)) {
                        column = functions$.MODULE$.callUDF(string, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1))}));
                        return column;
                    } else if (this.ternaryParameterFunc().contains((Object)string)) {
                        column = functions$.MODULE$.callUDF(string, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1)), KylinFunctions$.MODULE$.k_lit(children.apply(2))}));
                        return column;
                    } else if (this.varArgsFunc().contains((Object)string)) {
                        column = functions$.MODULE$.callUDF(string, (Seq)children.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Column apply(Object x$1) {
                                return KylinFunctions$.MODULE$.k_lit(x$1);
                            }
                        }, Seq$.MODULE$.canBuildFrom()));
                        return column;
                    } else {
                        boolean bl3 = "date_part".equals(string) ? true : "date_trunc".equals(string);
                        if (bl3) {
                            String string4 = KylinFunctions$.MODULE$.k_lit(children.head()).toString().toUpperCase(Locale.ROOT);
                            String string5 = "YEAR".equals(string4) ? "y" : ("MONTH".equals(string4) ? "M" : ("DAY".equals(string4) ? "d" : ("HOUR".equals(string4) ? "h" : ("MINUTE".equals(string4) ? "m" : ("MINUTES".equals(string4) ? "m" : ("SECOND".equals(string4) ? "s" : ("SECONDS".equals(string4) ? "s" : KylinFunctions$.MODULE$.k_lit(children.head()).toString())))))));
                            String part = string5;
                            column = functions$.MODULE$.date_format(KylinFunctions$.MODULE$.k_lit(children.apply(1)), part);
                            return column;
                        } else if ("datediff".equals(string)) {
                            column = functions$.MODULE$.datediff(KylinFunctions$.MODULE$.k_lit(children.head()), KylinFunctions$.MODULE$.k_lit(children.apply(1)));
                            return column;
                        } else if ("initcap".equals(string)) {
                            column = functions$.MODULE$.initcap(KylinFunctions$.MODULE$.k_lit(children.head()));
                            return column;
                        } else if ("pi".equals(string)) {
                            column = KylinFunctions$.MODULE$.k_lit(BoxesRunTime.boxToDouble((double)Math.PI));
                            return column;
                        } else {
                            boolean bl4 = "regexp_like".equals(string) ? true : "rlike".equals(string);
                            if (bl4) {
                                column = KylinFunctions$.MODULE$.k_lit(children.head()).rlike(children.apply(1).toString());
                                return column;
                            } else {
                                if (!"if".equals(string)) void var24_24;
                                throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported function ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var24_24})));
                                column = new Column((Expression)new If(KylinFunctions$.MODULE$.k_lit(children.head()).expr(), KylinFunctions$.MODULE$.k_lit(children.apply(1)).expr(), KylinFunctions$.MODULE$.k_lit(children.apply(2)).expr()));
                            }
                        }
                    }
                }
            }
            return column;
        }
        if (SqlKind.CEIL.equals(sqlKind)) {
            return functions$.MODULE$.ceil(KylinFunctions$.MODULE$.k_lit(children.head()));
        }
        if (SqlKind.FLOOR.equals(sqlKind)) {
            return functions$.MODULE$.floor(KylinFunctions$.MODULE$.k_lit(children.head()));
        }
        if (!SqlKind.ARRAY_VALUE_CONSTRUCTOR.equals(sqlKind)) throw new UnsupportedOperationException(sqlKind.toString());
        return functions$.MODULE$.array((Seq)children.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(Object child) {
                return KylinFunctions$.MODULE$.k_lit(child.toString());
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    private ExpressionConverter$() {
        MODULE$ = this;
        this.unaryParameterFunc = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ucase", "lcase", "base64", "sentences", "unbase64", "crc32", "md5", "sha", "sha1", "cbrt", "cosh", "expm1", "factorial", "log1p", "log2", "rint", "sinh", "tanh"}));
        this.ternaryParameterFunc = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replace", "substring_index", "lpad", "rpad", "conv"}));
        this.binaryParameterFunc = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"decode", "encode", "find_in_set", "levenshtein", "sha2", "trunc", "add_months", "date_add", "date_sub", "from_unixtime", "from_utc_timestamp", "to_utc_timestamp", "bround", "hypot", "log"}));
        this.noneParameterfunc = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_database", "input_file_block_length", "input_file_block_start", "input_file_name", "monotonically_increasing_id", "now", "spark_partition_id", "uuid"}));
        this.varArgsFunc = (HashSet)HashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"months_between", "locate", "rtrim"}));
    }
}

