/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode.visitor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.NlsString;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.filter.CaseTupleFilter;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.DynamicTupleFilter;
import org.apache.kylin.metadata.filter.ExtractTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.UnsupportedTupleFilter;
import org.apache.kylin.metadata.filter.function.Functions;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleFilterVisitor
extends RexVisitorImpl<TupleFilter> {
    private static Logger logger = LoggerFactory.getLogger(TupleFilterVisitor.class);
    final ColumnRowType inputRowType;
    private boolean autoJustByTimezone = false;
    private static final long TIME_ZONE_OFFSET = TimeZone.getTimeZone(KylinConfig.getInstanceFromEnv().getStreamingDerivedTimeTimezone()).getRawOffset();

    public TupleFilterVisitor(ColumnRowType inputRowType) {
        super(true);
        this.inputRowType = inputRowType;
    }

    public TupleFilter visitCall(RexCall call) {
        CompareTupleFilter compFilter;
        TupleFilter filter2 = null;
        SqlOperator op = call.getOperator();
        switch (op.getKind()) {
            case AND: {
                filter2 = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.AND);
                break;
            }
            case OR: {
                filter2 = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
                break;
            }
            case NOT: {
                filter2 = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.NOT);
                break;
            }
            case EQUALS: {
                filter2 = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.EQ);
                break;
            }
            case GREATER_THAN: {
                filter2 = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.GT);
                break;
            }
            case LESS_THAN: {
                filter2 = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.LT);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filter2 = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.GTE);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                filter2 = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.LTE);
                break;
            }
            case NOT_EQUALS: {
                filter2 = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.NEQ);
                break;
            }
            case IS_NULL: {
                filter2 = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.ISNULL);
                break;
            }
            case IS_NOT_NULL: {
                filter2 = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.ISNOTNULL);
                break;
            }
            case CAST: 
            case REINTERPRET: {
                break;
            }
            case CASE: {
                filter2 = new CaseTupleFilter();
                break;
            }
            case OTHER: {
                if (op.getName().equalsIgnoreCase("extract_date")) {
                    filter2 = new ExtractTupleFilter(TupleFilter.FilterOperatorEnum.EXTRACT);
                    break;
                }
                filter2 = Functions.getFunctionTupleFilter(op.getName());
                break;
            }
            case LIKE: 
            case OTHER_FUNCTION: {
                filter2 = Functions.getFunctionTupleFilter(op.getName());
                break;
            }
            case PLUS: 
            case MINUS: 
            case TIMES: 
            case DIVIDE: {
                TupleFilter f = this.dealWithTrivialExpr(call);
                if (f != null) {
                    return f;
                }
                filter2 = new UnsupportedTupleFilter(TupleFilter.FilterOperatorEnum.UNSUPPORTED);
                break;
            }
            default: {
                filter2 = new UnsupportedTupleFilter(TupleFilter.FilterOperatorEnum.UNSUPPORTED);
            }
        }
        boolean isChildValueDateTimeType = false;
        for (RexNode operand : call.operands) {
            TupleFilter childFilter = (TupleFilter)operand.accept((RexVisitor)this);
            if (filter2 == null) {
                filter2 = this.cast(childFilter, call.type);
            } else {
                filter2.addChild(childFilter);
            }
            if (!(operand instanceof RexLiteral) || !(((RexLiteral)operand).getValue() instanceof GregorianCalendar)) continue;
            isChildValueDateTimeType = true;
        }
        if (filter2 instanceof CompareTupleFilter && (compFilter = (CompareTupleFilter)filter2).getChildren().size() == 2 && compFilter.getChildren().get(0) instanceof ColumnTupleFilter && compFilter.getChildren().get(1) instanceof ConstantTupleFilter) {
            ColumnTupleFilter colFilter = (ColumnTupleFilter)compFilter.getChildren().get(0);
            ConstantTupleFilter constFilter = (ConstantTupleFilter)compFilter.getChildren().get(1);
            if (isChildValueDateTimeType && colFilter.getColumn().getType().isStringFamily()) {
                HashSet newValues = Sets.newHashSet();
                for (Object v : constFilter.getValues()) {
                    newValues.add(DateFormat.formatToDateStr(DateFormat.stringToMillis(v.toString())));
                }
                ConstantTupleFilter newConstFilter = new ConstantTupleFilter(newValues);
                filter2 = new CompareTupleFilter(filter2.getOperator());
                filter2.addChild(colFilter);
                filter2.addChild(newConstFilter);
            }
        }
        if (op.getKind() == SqlKind.OR) {
            filter2 = TupleFilterVisitor.mergeToInClause(filter2);
        } else if (op.getKind() == SqlKind.NOT) {
            assert (filter2.getChildren().size() == 1);
            filter2 = filter2.getChildren().get(0).reverse();
        }
        return filter2;
    }

    private TupleFilter dealWithTrivialExpr(RexCall call) {
        ImmutableList operators = call.operands;
        if (operators.size() != 2) {
            return null;
        }
        BigDecimal left = null;
        BigDecimal right = null;
        for (RexNode rexNode : operators) {
            if (!(rexNode instanceof RexLiteral)) {
                return null;
            }
            RexLiteral temp = (RexLiteral)rexNode;
            if (temp.getType().getFamily() != SqlTypeFamily.NUMERIC || !(temp.getValue() instanceof BigDecimal)) {
                return null;
            }
            if (left == null) {
                left = (BigDecimal)temp.getValue();
                continue;
            }
            right = (BigDecimal)temp.getValue();
        }
        Preconditions.checkNotNull(left);
        Preconditions.checkNotNull(right);
        switch (call.op.getKind()) {
            case PLUS: {
                return new ConstantTupleFilter(left.add(right).toString());
            }
            case MINUS: {
                return new ConstantTupleFilter(left.subtract(right).toString());
            }
            case TIMES: {
                return new ConstantTupleFilter(left.multiply(right).toString());
            }
            case DIVIDE: {
                return new ConstantTupleFilter(left.divide(right).toString());
            }
        }
        return null;
    }

    private TupleFilter cast(TupleFilter filter2, RelDataType type) {
        if (!(filter2 instanceof ConstantTupleFilter)) {
            return filter2;
        }
        ConstantTupleFilter constFilter = (ConstantTupleFilter)filter2;
        if (type.getFamily() == SqlTypeFamily.DATE || type.getFamily() == SqlTypeFamily.DATETIME || type.getFamily() == SqlTypeFamily.TIMESTAMP) {
            ArrayList newValues = Lists.newArrayList();
            for (Object v : constFilter.getValues()) {
                if (v == null) {
                    newValues.add(null);
                    continue;
                }
                long ts = DateFormat.stringToMillis(v.toString());
                if (this.autoJustByTimezone && (type.getFamily() == SqlTypeFamily.TIMESTAMP || type.getFamily() == SqlTypeFamily.DATETIME)) {
                    ts -= TIME_ZONE_OFFSET;
                }
                newValues.add(String.valueOf(ts));
            }
            constFilter = new ConstantTupleFilter(newValues);
        }
        return constFilter;
    }

    @VisibleForTesting
    static TupleFilter mergeToInClause(TupleFilter filter2) {
        List<? extends TupleFilter> children = filter2.getChildren();
        if (children.isEmpty()) {
            return filter2;
        }
        HashMap inColumnMap = Maps.newHashMap();
        LinkedList extraFilters = Lists.newLinkedList();
        for (TupleFilter tupleFilter : children) {
            CompareTupleFilter compFilter;
            TblColRef column;
            if (tupleFilter.getOperator() == TupleFilter.FilterOperatorEnum.EQ && (column = (compFilter = (CompareTupleFilter)tupleFilter).getColumn()) != null) {
                Pair<HashSet, HashMap> tmpValue = (Pair<HashSet, HashMap>)inColumnMap.get(column);
                if (tmpValue == null) {
                    HashSet inValues = Sets.newHashSet();
                    HashMap dynamicVariables = Maps.newHashMap();
                    tmpValue = new Pair<HashSet, HashMap>(inValues, dynamicVariables);
                    inColumnMap.put(column, tmpValue);
                }
                ((Set)tmpValue.getFirst()).addAll(compFilter.getValues());
                ((Map)tmpValue.getSecond()).putAll(compFilter.getVariables());
                continue;
            }
            extraFilters.add(tupleFilter);
        }
        children.clear();
        LogicalTupleFilter ret = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
        ret.addChildren(extraFilters);
        for (Map.Entry entry : inColumnMap.entrySet()) {
            CompareTupleFilter inFilter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.IN);
            inFilter.addChild(new ColumnTupleFilter((TblColRef)entry.getKey()));
            inFilter.addChild(new ConstantTupleFilter((Collection)((Pair)entry.getValue()).getFirst()));
            inFilter.getVariables().putAll((Map)((Pair)entry.getValue()).getSecond());
            ret.addChild(inFilter);
        }
        return ret.getChildren().size() == 1 ? ret.getChildren().get(0) : ret;
    }

    public TupleFilter visitLocalRef(RexLocalRef localRef) {
        throw new UnsupportedOperationException("local ref:" + localRef);
    }

    public TupleFilter visitInputRef(RexInputRef inputRef) {
        TblColRef column = this.inputRowType.getColumnByIndex(inputRef.getIndex());
        ColumnTupleFilter filter2 = new ColumnTupleFilter(column);
        return filter2;
    }

    private String normToTwoDigits(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return "" + i;
    }

    public TupleFilter visitLiteral(RexLiteral literal) {
        Object strValue = null;
        Comparable literalValue = literal.getValue();
        if (literalValue instanceof NlsString) {
            strValue = ((NlsString)literalValue).getValue();
        } else if (literalValue instanceof GregorianCalendar) {
            GregorianCalendar g = (GregorianCalendar)literalValue;
            strValue = Long.toString(g.getTimeInMillis());
        } else {
            strValue = literalValue instanceof TimeUnitRange ? ((TimeUnitRange)literalValue).name() : (literalValue == null ? null : literalValue.toString());
        }
        ConstantTupleFilter filter2 = new ConstantTupleFilter(strValue);
        return filter2;
    }

    public TupleFilter visitDynamicParam(RexDynamicParam dynamicParam) {
        String name = dynamicParam.getName();
        DynamicTupleFilter filter2 = new DynamicTupleFilter(name);
        return filter2;
    }

    public void setAutoJustByTimezone(boolean autoJustByTimezone) {
        this.autoJustByTimezone = autoJustByTimezone;
    }
}

