/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.pushdown;

import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.common.exceptions.KylinTimeoutException;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.query.pushdown.SparkSqlClient;
import org.apache.kylin.query.runtime.plans.QueryToExecutionIDCache$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hive.utils.QueryMetricUtils$;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.utils.SparkTypeUtil$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkSqlClient$ {
    public static final SparkSqlClient$ MODULE$;
    private final Logger logger;

    static {
        new SparkSqlClient$();
    }

    public Logger logger() {
        return this.logger;
    }

    public Pair<List<List<String>>, List<org.apache.kylin.engine.spark.metadata.cube.StructField>> executeSql(SparkSession ss, String sql2) {
        ss.sparkContext().setLocalProperty("spark.scheduler.pool", "query_pushdown");
        HadoopUtil.setCurrentConfiguration(ss.sparkContext().hadoopConfiguration());
        String queryId = QueryContextFacade.current().getQueryId();
        ss.sparkContext().setLocalProperty(QueryToExecutionIDCache$.MODULE$.KYLIN_QUERY_ID_KEY(), queryId);
        this.logger().info("Start to run sql with SparkSQL...");
        Dataset df = ss.sql(sql2);
        this.autoSetShufflePartitions(ss, (Dataset<Row>)df);
        return this.DFToList(ss, sql2, (Dataset<Row>)df);
    }

    private void autoSetShufflePartitions(SparkSession ss, Dataset<Row> df) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (config.isAutoSetPushDownPartitions()) {
            try {
                int basePartitionSize = config.getBaseShufflePartitionSize();
                Seq<Path> paths = ResourceDetectUtils$.MODULE$.getPaths(df.queryExecution().sparkPlan());
                String sourceTableSize = new StringBuilder().append(ResourceDetectUtils$.MODULE$.getResourceSize(paths)).append((Object)"b").toString();
                String partitions = ((Object)BoxesRunTime.boxToLong((long)Math.max(1L, JavaUtils.byteStringAsMb((String)sourceTableSize) / (long)basePartitionSize))).toString();
                df.sparkSession().conf().set("spark.sql.shuffle.partitions", partitions);
                this.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Auto set spark.sql.shuffle.partitions to ", ", the total sources "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitions}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceTableSize}))).toString());
            }
            catch (Throwable throwable) {
                this.logger().error("Auto set spark.sql.shuffle.partitions failed.", throwable);
            }
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private Pair<List<List<String>>, List<org.apache.kylin.engine.spark.metadata.cube.StructField>> DFToList(SparkSession ss, String sql2, Dataset<Row> df) {
        Tuple5<List<Long>, List<Long>, List<Long>, List<Long>, List<Long>> tuple5;
        block6: {
            Tuple5 tuple52;
            String jobGroup = Thread.currentThread().getName();
            ss.sparkContext().setJobGroup(jobGroup, new StringBuilder().append((Object)"Pushdown Query Id: ").append((Object)QueryContextFacade.current().getQueryId()).toString(), true);
            String[] temporarySchema = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<StructField, Object> x0$1) {
                    Tuple2<StructField, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        int index = tuple2._2$mcI$sp();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"temporary_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            Dataset tempDF = df.toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])temporarySchema));
            Seq columns = (Seq)tempDF.schema().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Column apply(StructField tp) {
                    return functions$.MODULE$.col(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp.name()}))).cast((DataType)StringType$.MODULE$);
                }
            }, Seq$.MODULE$.canBuildFrom());
            Dataset frame = tempDF.select(columns);
            List rowList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])frame.collect()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final List<String> apply(Row x$1) {
                    return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)x$1.toSeq().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Object x$2) {
                            return (String)x$2;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).asJava();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(List.class)))).toSeq()).asJava();
            List fieldList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)df.schema().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final org.apache.kylin.engine.spark.metadata.cube.StructField apply(StructField field) {
                    return SparkTypeUtil$.MODULE$.convertSparkFieldToJavaField(field);
                }
            }, Seq$.MODULE$.canBuildFrom())).asJava();
            tuple5 = QueryMetricUtils$.MODULE$.collectScanMetrics(frame.queryExecution().executedPlan());
            if (tuple5 == null) break block6;
            List scanRows = (List)tuple5._1();
            List scanFiles = (List)tuple5._2();
            List metadataTime = (List)tuple5._3();
            List scanTime = (List)tuple5._4();
            List scanBytes = (List)tuple5._5();
            Tuple5 tuple53 = tuple52 = new Tuple5((Object)scanRows, (Object)scanFiles, (Object)metadataTime, (Object)scanTime, (Object)scanBytes);
            List scanRows2 = (List)tuple53._1();
            List scanFiles2 = (List)tuple53._2();
            List metadataTime2 = (List)tuple53._3();
            List scanTime2 = (List)tuple53._4();
            List scanBytes2 = (List)tuple53._5();
            QueryContextFacade.current().addAndGetScannedRows(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(scanRows2).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Long x$4) {
                    return Predef$.MODULE$.Long2long(x$4);
                }
            }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            QueryContextFacade.current().addAndGetScanFiles(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(scanFiles2).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Long x$5) {
                    return Predef$.MODULE$.Long2long(x$5);
                }
            }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            QueryContextFacade.current().addAndGetScannedBytes(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(scanBytes2).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Long x$6) {
                    return Predef$.MODULE$.Long2long(x$6);
                }
            }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            QueryContextFacade.current().addAndGetMetadataTime(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadataTime2).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Long x$7) {
                    return Predef$.MODULE$.Long2long(x$7);
                }
            }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            QueryContextFacade.current().addAndGetScanTime(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(scanTime2).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Long x$8) {
                    return Predef$.MODULE$.Long2long(x$8);
                }
            }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            Pair<List<List<String>>, List<org.apache.kylin.engine.spark.metadata.cube.StructField>> pair = Pair.newPair(rowList, fieldList);
            {
                catch (Throwable throwable) {
                    if (throwable instanceof InterruptedException) {
                        void var4_4;
                        ss.sparkContext().cancelJobGroup((String)var4_4);
                        this.logger().info("Query timeout ", throwable);
                        Thread.currentThread().interrupt();
                        throw new KylinTimeoutException(new StringBuilder().append((Object)"Query timeout after: ").append((Object)BoxesRunTime.boxToInteger((int)KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds())).append((Object)"s").toString());
                    }
                    throw throwable;
                }
            }
            HadoopUtil.setCurrentConfiguration(null);
            return pair;
        }
        try {
            throw new MatchError(tuple5);
        }
        catch (Throwable throwable) {
            HadoopUtil.setCurrentConfiguration(null);
            throw throwable;
        }
    }

    private SparkSqlClient$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(SparkSqlClient.class);
    }
}

