/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.optrule;

import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlAvgAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.kylin.query.relnode.OLAPAggregateRel;
import org.apache.kylin.query.relnode.OLAPRel;

public class OLAPAggregateRule
extends ConverterRule {
    public static final ConverterRule INSTANCE = new OLAPAggregateRule();

    public OLAPAggregateRule() {
        super(LogicalAggregate.class, (RelTrait)Convention.NONE, (RelTrait)OLAPRel.CONVENTION, "OLAPAggregateRule");
    }

    public RelNode convert(RelNode rel) {
        LogicalAggregate agg2 = (LogicalAggregate)rel;
        if (this.containsAvg(agg2)) {
            return null;
        }
        RelTraitSet traitSet = agg2.getTraitSet().replace((RelTrait)OLAPRel.CONVENTION);
        try {
            return new OLAPAggregateRel(agg2.getCluster(), traitSet, OLAPAggregateRule.convert((RelNode)agg2.getInput(), (RelTrait)OLAPRel.CONVENTION), agg2.indicator, agg2.getGroupSet(), (List<ImmutableBitSet>)agg2.getGroupSets(), agg2.getAggCallList());
        }
        catch (InvalidRelException e) {
            throw new IllegalStateException("Can't create OLAPAggregateRel!", e);
        }
    }

    private boolean containsAvg(LogicalAggregate agg2) {
        for (AggregateCall call : agg2.getAggCallList()) {
            SqlAggFunction func = call.getAggregation();
            if (!(func instanceof SqlAvgAggFunction)) continue;
            return true;
        }
        return false;
    }
}

