/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.basic.BasicMeasureType;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Joiner;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class FunctionDesc
implements Serializable {
    public static final String FUNC_SUM = "SUM";
    public static final String FUNC_MIN = "MIN";
    public static final String FUNC_MAX = "MAX";
    public static final String FUNC_COUNT = "COUNT";
    public static final String FUNC_COUNT_DISTINCT = "COUNT_DISTINCT";
    public static final String FUNC_INTERSECT_COUNT = "INTERSECT_COUNT";
    public static final String FUNC_INTERSECT_VALUE = "INTERSECT_VALUE";
    public static final String FUNC_GROUPING = "GROUPING";
    public static final String FUNC_PERCENTILE = "PERCENTILE_APPROX";
    public static final Set<String> BUILT_IN_AGGREGATIONS = Sets.newHashSet();
    public static final String PARAMETER_TYPE_CONSTANT = "constant";
    public static final String PARAMETER_TYPE_COLUMN = "column";
    @JsonProperty(value="expression")
    private String expression;
    @JsonProperty(value="parameter")
    private ParameterDesc parameter;
    @JsonProperty(value="returntype")
    private String returnType;
    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> configuration = new LinkedHashMap<String, String>();
    private DataType returnDataType;
    private MeasureType<?> measureType;
    private boolean isDimensionAsMetric = false;
    private boolean isMrDict = false;

    public static FunctionDesc newInstance(String expression, ParameterDesc param, String returnType) {
        FunctionDesc r = new FunctionDesc();
        r.expression = expression == null ? null : expression.toUpperCase(Locale.ROOT);
        r.parameter = param;
        r.returnType = returnType;
        r.returnDataType = DataType.getType(returnType);
        return r;
    }

    public boolean isMrDict() {
        return this.isMrDict;
    }

    public void setMrDict(boolean mrDict) {
        this.isMrDict = mrDict;
    }

    public void init(DataModelDesc model) {
        this.expression = this.expression.toUpperCase(Locale.ROOT);
        if (this.expression.equals("PERCENTILE")) {
            this.expression = FUNC_PERCENTILE;
        }
        this.returnDataType = DataType.getType(this.returnType);
        for (ParameterDesc p = this.parameter; p != null; p = p.getNextParameter()) {
            if (!p.isColumnType()) continue;
            TblColRef colRef = model.findColumn(p.getValue());
            p.setValue(colRef.getIdentity());
            p.setColRef(colRef);
        }
    }

    private void reInitMeasureType() {
        if (this.isDimensionAsMetric && this.isCountDistinct()) {
            this.measureType = MeasureTypeFactory.createNoRewriteFieldsMeasureType(this.getExpression(), this.getReturnDataType());
            this.returnDataType = DataType.getType("dim_dc");
        } else {
            this.measureType = MeasureTypeFactory.create(this.getExpression(), this.getReturnDataType());
        }
    }

    public MeasureType<?> getMeasureType() {
        if (this.isDimensionAsMetric && !this.isCountDistinct()) {
            return null;
        }
        if (this.measureType == null) {
            this.reInitMeasureType();
        }
        return this.measureType;
    }

    public boolean needRewrite() {
        if (this.getMeasureType() == null) {
            return false;
        }
        return this.getMeasureType().needRewrite();
    }

    public boolean needRewriteField() {
        if (!this.needRewrite()) {
            return false;
        }
        return this.getMeasureType().needRewriteField();
    }

    public String getRewriteFieldName() {
        if (this.isCountConstant()) {
            return "_KY_COUNT__";
        }
        if (this.isCountDistinct()) {
            return "_KY_" + this.getFullExpressionInAlphabetOrder().replaceAll("[(),. ]", "_");
        }
        return "_KY_" + this.getFullExpression().replaceAll("[(),. ]", "_");
    }

    public DataType getRewriteFieldType() {
        if (this.getMeasureType() instanceof BasicMeasureType) {
            if (this.isMax() || this.isMin()) {
                return this.parameter.getColRefs().get(0).getType();
            }
            if (this.isSum()) {
                if (this.parameter.isColumnType()) {
                    if (this.parameter.getColRefs().get(0).getType().isIntegerFamily()) {
                        return DataType.getType("bigint");
                    }
                    return this.parameter.getColRefs().get(0).getType();
                }
                return DataType.getType("bigint");
            }
            if (this.isCount()) {
                return DataType.getType("bigint");
            }
            throw new IllegalArgumentException("unknown measure type " + this.getMeasureType());
        }
        return DataType.ANY;
    }

    public ColumnDesc newFakeRewriteColumn(TableDesc sourceTable) {
        ColumnDesc fakeCol = new ColumnDesc();
        fakeCol.setName(this.getRewriteFieldName());
        fakeCol.setDatatype(this.getRewriteFieldType().toString());
        if (this.isCount()) {
            fakeCol.setNullable(false);
        }
        fakeCol.init(sourceTable);
        return fakeCol;
    }

    public boolean isMin() {
        return FUNC_MIN.equalsIgnoreCase(this.expression);
    }

    public boolean isMax() {
        return FUNC_MAX.equalsIgnoreCase(this.expression);
    }

    public boolean isSum() {
        return FUNC_SUM.equalsIgnoreCase(this.expression);
    }

    public boolean isCount() {
        return FUNC_COUNT.equalsIgnoreCase(this.expression);
    }

    public boolean isCountDistinct() {
        return FUNC_COUNT_DISTINCT.equalsIgnoreCase(this.expression);
    }

    public boolean isCountConstant() {
        return FUNC_COUNT.equalsIgnoreCase(this.expression) && (this.parameter == null || this.parameter.isConstant());
    }

    public String getFullExpression() {
        StringBuilder sb = new StringBuilder(this.expression);
        sb.append("(");
        if (this.parameter != null) {
            sb.append(this.parameter.getValue());
        }
        sb.append(")");
        return sb.toString();
    }

    public String getFullExpressionInAlphabetOrder() {
        StringBuilder sb = new StringBuilder(this.expression);
        sb.append("(");
        ArrayList<String> flatParams = Lists.newArrayList();
        for (ParameterDesc localParam = this.parameter; localParam != null; localParam = localParam.getNextParameter()) {
            flatParams.add(localParam.getValue());
        }
        Collections.sort(flatParams);
        sb.append(Joiner.on(",").join(flatParams));
        sb.append(")");
        return sb.toString();
    }

    public boolean isDimensionAsMetric() {
        return this.isDimensionAsMetric;
    }

    public void setDimensionAsMetric(boolean isDimensionAsMetric) {
        this.isDimensionAsMetric = isDimensionAsMetric;
        if (this.measureType != null) {
            this.reInitMeasureType();
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public ParameterDesc getParameter() {
        return this.parameter;
    }

    public void setParameter(ParameterDesc parameter) {
        this.parameter = parameter;
    }

    public int getParameterCount() {
        int count = 0;
        for (ParameterDesc p = this.parameter; p != null; p = p.getNextParameter()) {
            ++count;
        }
        return count;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
        this.returnDataType = DataType.getType(returnType);
    }

    public DataType getReturnDataType() {
        return this.returnDataType;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.isCountConstant() || this.parameter == null ? 0 : this.parameter.hashCode());
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionDesc other = (FunctionDesc)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.isCountDistinct()) {
            if (this.parameter != null) return this.parameter.equalInArbitraryOrder(other.parameter);
            if (other.parameter == null) return true;
            return false;
        }
        if (this.isCountConstant() && ((FunctionDesc)obj).isCountConstant()) {
            return true;
        }
        if (!(this.parameter == null ? other.parameter != null : !this.parameter.equals(other.parameter))) return true;
        return false;
    }

    public String toString() {
        return "FunctionDesc [expression=" + this.expression + ", parameter=" + this.parameter + ", returnType=" + this.returnType + "]";
    }

    static {
        BUILT_IN_AGGREGATIONS.add(FUNC_MAX);
        BUILT_IN_AGGREGATIONS.add(FUNC_MIN);
        BUILT_IN_AGGREGATIONS.add(FUNC_COUNT_DISTINCT);
        BUILT_IN_AGGREGATIONS.add(FUNC_PERCENTILE);
    }
}

