/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.expression.ExpressionColCollector;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public abstract class DynamicFunctionDesc
extends FunctionDesc {
    protected final TupleExpression tupleExpression;
    protected final Set<TblColRef> filterColSet;
    protected Map<TblColRef, FunctionDesc> runtimeFuncMap;

    public DynamicFunctionDesc(ParameterDesc parameter, TupleExpression tupleExpression) {
        this.setParameter(parameter);
        this.tupleExpression = tupleExpression;
        Pair<Set<TblColRef>, Set<TblColRef>> colsPair = ExpressionColCollector.collectColumnsPair(tupleExpression);
        this.filterColSet = colsPair.getFirst();
        Set<TblColRef> measureColumns2 = colsPair.getSecond();
        this.runtimeFuncMap = Maps.newHashMapWithExpectedSize(measureColumns2.size());
        for (TblColRef column : measureColumns2) {
            this.runtimeFuncMap.put(column, this.constructRuntimeFunction(column));
        }
    }

    @Override
    public boolean needRewrite() {
        return false;
    }

    public boolean ifFriendlyForDerivedFilter() {
        return false;
    }

    public TupleExpression getTupleExpression() {
        return this.tupleExpression;
    }

    public Set<TblColRef> getFilterColumnSet() {
        return this.filterColSet;
    }

    public Set<TblColRef> getMeasureColumnSet() {
        return this.runtimeFuncMap.keySet();
    }

    public Collection<FunctionDesc> getRuntimeFuncs() {
        return this.runtimeFuncMap.values();
    }

    public Map<TblColRef, FunctionDesc> getRuntimeFuncMap() {
        return this.runtimeFuncMap;
    }

    public void setRuntimeFuncMap(Map<TblColRef, FunctionDesc> funcMap) {
        this.runtimeFuncMap = funcMap;
    }

    protected abstract FunctionDesc constructRuntimeFunction(TblColRef var1);
}

