/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import java.lang.reflect.InvocationTargetException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.filter.BuiltInFunctionTupleFilter;
import org.apache.kylin.metadata.filter.CaseTupleFilter;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.DynamicTupleFilter;
import org.apache.kylin.metadata.filter.ExtractTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.UDF.MassInTupleFilter;
import org.apache.kylin.metadata.filter.UnsupportedTupleFilter;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleFilterSerializer {
    private static final Logger logger = LoggerFactory.getLogger(TupleFilterSerializer.class);
    private static final int BUFFER_SIZE = 65536;
    private static final Map<Integer, TupleFilter.FilterOperatorEnum> ID_OP_MAP = new HashMap<Integer, TupleFilter.FilterOperatorEnum>();
    protected static final Map<TupleFilter.FilterOperatorEnum, Class> extendedTupleFilters = Maps.newHashMap();

    public static byte[] serialize(TupleFilter rootFilter, IFilterCodeSystem<?> cs) {
        return TupleFilterSerializer.serialize(rootFilter, null, cs);
    }

    public static byte[] serialize(TupleFilter rootFilter, Decorator decorator, IFilterCodeSystem<?> cs) {
        ByteBuffer buffer;
        int bufferSize = 65536;
        while (true) {
            try {
                buffer = ByteBuffer.allocate(bufferSize);
                TupleFilterSerializer.internalSerialize(rootFilter, decorator, buffer, cs);
            }
            catch (BufferOverflowException e) {
                if (bufferSize == 0x40000000) {
                    throw e;
                }
                logger.info("Buffer size {} cannot hold the filter, resizing to 2 times", (Object)bufferSize);
                bufferSize <<= 1;
                continue;
            }
            break;
        }
        byte[] result = new byte[buffer.position()];
        System.arraycopy(buffer.array(), 0, result, 0, buffer.position());
        return result;
    }

    private static void internalSerialize(TupleFilter filter2, Decorator decorator, ByteBuffer buffer, IFilterCodeSystem<?> cs) {
        if (decorator != null) {
            filter2 = decorator.onSerialize(filter2);
        }
        if (filter2 == null) {
            return;
        }
        if (filter2.hasChildren()) {
            TupleFilterSerializer.serializeFilter(1, filter2, buffer, cs);
            for (TupleFilter tupleFilter : filter2.getChildren()) {
                TupleFilterSerializer.internalSerialize(tupleFilter, decorator, buffer, cs);
            }
            TupleFilterSerializer.serializeFilter(-1, filter2, buffer, cs);
        } else {
            TupleFilterSerializer.serializeFilter(0, filter2, buffer, cs);
        }
    }

    private static void serializeFilter(int flag, TupleFilter filter2, ByteBuffer buffer, IFilterCodeSystem<?> cs) {
        if (flag < 0) {
            BytesUtil.writeVInt(-1, buffer);
        } else {
            int opVal = filter2.getOperator().getValue();
            BytesUtil.writeVInt(opVal, buffer);
            filter2.serialize(cs, buffer);
            BytesUtil.writeVInt(flag, buffer);
        }
    }

    public static TupleFilter deserialize(byte[] bytes, IFilterCodeSystem<?> cs) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        TupleFilter rootFilter = null;
        Stack<TupleFilter> parentStack = new Stack<TupleFilter>();
        while (buffer.hasRemaining()) {
            int hasChild;
            int opVal = BytesUtil.readVInt(buffer);
            if (opVal < 0) {
                parentStack.pop();
                continue;
            }
            TupleFilter filter2 = TupleFilterSerializer.createTupleFilter(opVal);
            filter2.deserialize(cs, buffer);
            if (rootFilter == null) {
                rootFilter = filter2;
                parentStack.push(filter2);
                BytesUtil.readVInt(buffer);
                continue;
            }
            TupleFilter parentFilter = (TupleFilter)parentStack.peek();
            if (parentFilter != null) {
                parentFilter.addChild(filter2);
            }
            if ((hasChild = BytesUtil.readVInt(buffer)) != 1) continue;
            parentStack.push(filter2);
        }
        return rootFilter;
    }

    private static TupleFilter createTupleFilter(int opVal) {
        TupleFilter.FilterOperatorEnum op = ID_OP_MAP.get(opVal);
        if (op == null) {
            throw new IllegalStateException("operator value is " + opVal);
        }
        TupleFilter filter2 = null;
        switch (op) {
            case AND: 
            case OR: 
            case NOT: {
                filter2 = new LogicalTupleFilter(op);
                break;
            }
            case EQ: 
            case NEQ: 
            case LT: 
            case LTE: 
            case GT: 
            case GTE: 
            case IN: 
            case NOTIN: 
            case ISNULL: 
            case ISNOTNULL: {
                filter2 = new CompareTupleFilter(op);
                break;
            }
            case EXTRACT: {
                filter2 = new ExtractTupleFilter(op);
                break;
            }
            case CASE: {
                filter2 = new CaseTupleFilter();
                break;
            }
            case COLUMN: {
                filter2 = new ColumnTupleFilter(null);
                break;
            }
            case CONSTANT: {
                filter2 = new ConstantTupleFilter();
                break;
            }
            case DYNAMIC: {
                filter2 = new DynamicTupleFilter(null);
                break;
            }
            case FUNCTION: {
                filter2 = new BuiltInFunctionTupleFilter(null);
                break;
            }
            case UNSUPPORTED: {
                filter2 = new UnsupportedTupleFilter(op);
                break;
            }
            case MASSIN: {
                filter2 = new MassInTupleFilter();
                break;
            }
            default: {
                if (extendedTupleFilters.containsKey((Object)op)) {
                    try {
                        filter2 = (TupleFilter)extendedTupleFilters.get((Object)op).getConstructor(new Class[0]).newInstance(new Object[0]);
                        break;
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new IllegalStateException("Error FilterOperatorEnum: " + op.getValue());
            }
        }
        return filter2;
    }

    static {
        for (TupleFilter.FilterOperatorEnum op : TupleFilter.FilterOperatorEnum.values()) {
            ID_OP_MAP.put(op.getValue(), op);
        }
    }

    public static interface Decorator {
        public TupleFilter onSerialize(TupleFilter var1);
    }
}

