/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import java.util.IdentityHashMap;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class TsConditionEraser
implements TupleFilterSerializer.Decorator {
    private final TblColRef tsColumn;
    private final TupleFilter root;
    private IdentityHashMap<TupleFilter, Boolean> isInTopLevelANDs;

    public TsConditionEraser(TblColRef tsColumn, TupleFilter root) {
        this.tsColumn = tsColumn;
        this.root = root;
        this.isInTopLevelANDs = Maps.newIdentityHashMap();
    }

    @Override
    public TupleFilter onSerialize(TupleFilter filter2) {
        if (filter2 == null) {
            return null;
        }
        if (this.root == filter2) {
            this.isInTopLevelANDs.put(filter2, true);
        }
        if (this.isInTopLevelANDs.containsKey(filter2)) {
            TblColRef c;
            this.classifyChildrenByMarking(filter2);
            if (filter2 instanceof CompareTupleFilter && (c = ((CompareTupleFilter)filter2).getColumn()) != null && c.equals(this.tsColumn)) {
                return null;
            }
        }
        return filter2;
    }

    private void classifyChildrenByMarking(TupleFilter filter2) {
        if (filter2 instanceof LogicalTupleFilter && filter2.getOperator() == TupleFilter.FilterOperatorEnum.AND) {
            for (TupleFilter tupleFilter : filter2.getChildren()) {
                this.isInTopLevelANDs.put(tupleFilter, true);
            }
        }
    }
}

