/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.expression;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kylin.metadata.expression.ExpressionVisitor;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TupleExpression {
    static final Logger logger = LoggerFactory.getLogger(TupleExpression.class);
    protected final ExpressionOperatorEnum operator;
    protected final List<TupleExpression> children;
    protected String digest;
    protected Boolean ifAbleToPushDown = null;

    protected TupleExpression(ExpressionOperatorEnum op, List<TupleExpression> exprs) {
        this.operator = op;
        this.children = exprs;
    }

    protected boolean ifAbleToPushDown() {
        if (this.ifAbleToPushDown == null) {
            for (TupleExpression child : this.children) {
                this.ifAbleToPushDown = child.ifAbleToPushDown();
                if (this.ifAbleToPushDown.booleanValue()) continue;
                break;
            }
            if (this.ifAbleToPushDown == null) {
                this.ifAbleToPushDown = true;
            }
        }
        return this.ifAbleToPushDown;
    }

    public boolean ifForDynamicColumn() {
        return false;
    }

    public abstract void verify();

    public abstract Object calculate(IEvaluatableTuple var1, IFilterCodeSystem<?> var2);

    public abstract TupleExpression accept(ExpressionVisitor var1);

    public abstract void serialize(IFilterCodeSystem<?> var1, ByteBuffer var2);

    public abstract void deserialize(IFilterCodeSystem<?> var1, ByteBuffer var2);

    public ExpressionOperatorEnum getOperator() {
        return this.operator;
    }

    public void setDigest(String digest2) {
        this.digest = digest2;
    }

    public String getDigest() {
        return this.digest;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<? extends TupleExpression> getChildren() {
        return this.children;
    }

    public void addChild(TupleExpression child) {
        this.children.add(child);
    }

    public static enum ExpressionOperatorEnum {
        PLUS(0, "+"),
        MINUS(1, "-"),
        MULTIPLE(2, "*"),
        DIVIDE(3, "/"),
        CASE(10, "Case"),
        COLUMN(20, "InputRef"),
        NUMBER(21, "Number"),
        STRING(22, "String"),
        REXCALL(30, "RexCall"),
        NONE(31, "NONE");

        private final int value;
        private final String name;

        private ExpressionOperatorEnum(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }
    }
}

