/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.expression;

import java.util.ArrayList;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.expression.BinaryTupleExpression;
import org.apache.kylin.metadata.expression.CaseTupleExpression;
import org.apache.kylin.metadata.expression.ColumnTupleExpression;
import org.apache.kylin.metadata.expression.ExpressionColCollector;
import org.apache.kylin.metadata.expression.ExpressionVisitor;
import org.apache.kylin.metadata.expression.NoneTupleExpression;
import org.apache.kylin.metadata.expression.NumberTupleExpression;
import org.apache.kylin.metadata.expression.RexCallTupleExpression;
import org.apache.kylin.metadata.expression.StringTupleExpression;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class ExpressionCountDistributor
implements ExpressionVisitor {
    private final TupleExpression cntExpr;
    private boolean ifToCnt;
    private boolean ifCntSet;

    public ExpressionCountDistributor(TupleExpression cntExpr) {
        this.cntExpr = cntExpr;
        this.ifToCnt = true;
        this.ifCntSet = false;
    }

    @Override
    public TupleExpression visitNumber(NumberTupleExpression numExpr) {
        NumberTupleExpression copyExpr = new NumberTupleExpression(numExpr.getValue());
        if (this.ifToCnt) {
            ArrayList<TupleExpression> children = Lists.newArrayList(this.cntExpr, copyExpr);
            this.ifCntSet = true;
            return new BinaryTupleExpression(TupleExpression.ExpressionOperatorEnum.MULTIPLE, children);
        }
        return copyExpr;
    }

    @Override
    public TupleExpression visitString(StringTupleExpression strExpr) {
        return new StringTupleExpression(strExpr.getValue());
    }

    @Override
    public TupleExpression visitColumn(ColumnTupleExpression colExpr) {
        return new ColumnTupleExpression(colExpr.getColumn());
    }

    @Override
    public TupleExpression visitBinary(BinaryTupleExpression binaryExpr) {
        TupleExpression rightCopy;
        TupleExpression leftCopy;
        boolean ifToCntO = this.ifToCnt;
        switch (binaryExpr.getOperator()) {
            case PLUS: 
            case MINUS: {
                boolean ifCntSetO = this.ifCntSet;
                leftCopy = binaryExpr.getLeft().accept(this);
                this.ifToCnt = ifToCntO;
                this.ifCntSet = ifCntSetO;
                rightCopy = binaryExpr.getRight().accept(this);
                break;
            }
            case MULTIPLE: 
            case DIVIDE: {
                if (ifToCntO) {
                    this.ifToCnt = ExpressionColCollector.collectMeasureColumns(binaryExpr.getRight()).isEmpty();
                }
                leftCopy = binaryExpr.getLeft().accept(this);
                boolean bl = this.ifToCnt = ifToCntO && !this.ifCntSet;
                if (this.ifToCnt) {
                    this.ifToCnt = ExpressionColCollector.collectMeasureColumns(binaryExpr.getLeft()).isEmpty();
                }
                this.ifCntSet = false;
                rightCopy = binaryExpr.getRight().accept(this);
                this.ifCntSet = ifToCntO && (this.ifCntSet || !this.ifToCnt);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operator " + (Object)((Object)binaryExpr.getOperator()));
            }
        }
        return new BinaryTupleExpression(binaryExpr.getOperator(), Lists.newArrayList(leftCopy, rightCopy));
    }

    @Override
    public TupleExpression visitCaseCall(CaseTupleExpression caseExpr) {
        ArrayList<Pair<TupleFilter, TupleExpression>> whenList = Lists.newArrayListWithExpectedSize(caseExpr.getWhenList().size());
        for (Pair<TupleFilter, TupleExpression> entry : caseExpr.getWhenList()) {
            TupleFilter filter2 = entry.getFirst();
            TupleExpression expression = this.visitIndependent(entry.getSecond());
            whenList.add(new Pair<TupleFilter, TupleExpression>(filter2, expression));
        }
        TupleExpression elseExpr = null;
        if (caseExpr.getElseExpr() != null) {
            elseExpr = this.visitIndependent(caseExpr.getElseExpr());
        }
        if (this.ifToCnt) {
            this.ifToCnt = ExpressionColCollector.collectMeasureColumns(caseExpr).isEmpty();
        }
        return new CaseTupleExpression(whenList, elseExpr);
    }

    @Override
    public TupleExpression visitRexCall(RexCallTupleExpression rexCallExpr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TupleExpression visitNone(NoneTupleExpression noneExpr) {
        return noneExpr;
    }

    private TupleExpression visitIndependent(TupleExpression expression) {
        boolean ifToCntO = this.ifToCnt;
        boolean ifCntSetO = this.ifCntSet;
        TupleExpression ret = expression.accept(this);
        this.ifToCnt = ifToCntO;
        this.ifCntSet = ifCntSetO;
        return ret;
    }

    public boolean ifCntSet() {
        return this.ifCntSet;
    }
}

