/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.common.util.SerializeToByteBuffer;
import org.apache.kylin.cube.gridtable.CuboidToGridTableMapping;
import org.apache.kylin.gridtable.EmptyGTScanner;
import org.apache.kylin.gridtable.GTAggregateScanner;
import org.apache.kylin.gridtable.GTFilterScanner;
import org.apache.kylin.gridtable.GTForwardingScanner;
import org.apache.kylin.gridtable.GTFunctionScanner;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRange;
import org.apache.kylin.gridtable.GTScanRequestBuilder;
import org.apache.kylin.gridtable.GTUtil;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.StorageLimitLevel;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.expression.TupleExpressionSerializer;
import org.apache.kylin.metadata.filter.StringCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTScanRequest {
    private static final Logger logger = LoggerFactory.getLogger(GTScanRequest.class);
    public static final int terminateCheckInterval = 100;
    private CuboidToGridTableMapping mapping;
    private GTInfo info;
    private List<GTScanRange> ranges;
    private ImmutableBitSet columns;
    private transient ImmutableBitSet selectedColBlocks;
    private ImmutableBitSet rtAggrMetrics;
    private ImmutableBitSet dynamicCols;
    private Map<Integer, TupleExpression> tupleExpressionMap;
    private TupleFilter filterPushDown;
    private TupleFilter havingFilterPushDown;
    private ImmutableBitSet aggrGroupBy;
    private ImmutableBitSet aggrMetrics;
    private String[] aggrMetricsFuncs;
    private String storageBehavior;
    private long startTime;
    private long timeout;
    private boolean allowStorageAggregation;
    private double aggCacheMemThreshold;
    private int storageScanRowNumThreshold;
    private int storagePushDownLimit;
    private StorageLimitLevel storageLimitLevel;
    private transient boolean doingStorageAggregation = false;
    private static final int SERIAL_0_BASE = 0;
    private static final int SERIAL_1_HAVING_FILTER = 1;
    public static final BytesSerializer<GTScanRequest> serializer = new BytesSerializer<GTScanRequest>(){

        @Override
        public void serialize(GTScanRequest value, ByteBuffer out) {
            int serialLevel = KylinConfig.getInstanceFromEnv().getGTScanRequestSerializationLevel();
            GTInfo.serializer.serialize(value.info, out);
            BytesUtil.writeVInt(value.ranges.size(), out);
            for (GTScanRange range : value.ranges) {
                this.serializeGTRecord(range.pkStart, out);
                this.serializeGTRecord(range.pkEnd, out);
                BytesUtil.writeVInt(range.fuzzyKeys.size(), out);
                for (GTRecord f : range.fuzzyKeys) {
                    this.serializeGTRecord(f, out);
                }
            }
            ImmutableBitSet.serializer.serialize(value.columns, out);
            BytesUtil.writeByteArray(GTUtil.serializeGTFilter(value.filterPushDown, value.info), out);
            if (serialLevel >= 1) {
                BytesUtil.writeByteArray(TupleFilterSerializer.serialize(value.havingFilterPushDown, StringCodeSystem.INSTANCE), out);
            }
            ImmutableBitSet.serializer.serialize(value.aggrGroupBy, out);
            ImmutableBitSet.serializer.serialize(value.aggrMetrics, out);
            BytesUtil.writeAsciiStringArray(value.aggrMetricsFuncs, out);
            BytesUtil.writeVInt(value.allowStorageAggregation ? 1 : 0, out);
            out.putDouble(value.aggCacheMemThreshold);
            BytesUtil.writeUTFString(value.getStorageLimitLevel().name(), out);
            BytesUtil.writeVInt(value.storageScanRowNumThreshold, out);
            BytesUtil.writeVInt(value.storagePushDownLimit, out);
            BytesUtil.writeVLong(value.startTime, out);
            BytesUtil.writeVLong(value.timeout, out);
            BytesUtil.writeUTFString(value.storageBehavior, out);
            ImmutableBitSet.serializer.serialize(value.dynamicCols, out);
            BytesUtil.writeVInt(value.tupleExpressionMap.size(), out);
            Iterator<Object> iterator = value.tupleExpressionMap.keySet().iterator();
            while (iterator.hasNext()) {
                int c = (Integer)iterator.next();
                TupleExpression tupleExpr = (TupleExpression)value.tupleExpressionMap.get(c);
                BytesUtil.writeVInt(c, out);
                BytesUtil.writeByteArray(TupleExpressionSerializer.serialize(tupleExpr, GTUtil.wrap(((GTScanRequest)value).info.codeSystem.getComparator())), out);
            }
            ImmutableBitSet.serializer.serialize(value.rtAggrMetrics, out);
        }

        @Override
        public GTScanRequest deserialize(ByteBuffer in) {
            int serialLevel = KylinConfig.getInstanceFromEnv().getGTScanRequestSerializationLevel();
            GTInfo sInfo = GTInfo.serializer.deserialize(in);
            ArrayList<GTScanRange> sRanges = Lists.newArrayList();
            int sRangesCount = BytesUtil.readVInt(in);
            for (int rangeIdx = 0; rangeIdx < sRangesCount; ++rangeIdx) {
                GTRecord sPkStart = this.deserializeGTRecord(in, sInfo);
                GTRecord sPkEnd = this.deserializeGTRecord(in, sInfo);
                ArrayList<GTRecord> sFuzzyKeys = Lists.newArrayList();
                int sFuzzyKeySize = BytesUtil.readVInt(in);
                for (int i = 0; i < sFuzzyKeySize; ++i) {
                    sFuzzyKeys.add(this.deserializeGTRecord(in, sInfo));
                }
                GTScanRange sRange = new GTScanRange(sPkStart, sPkEnd, sFuzzyKeys);
                sRanges.add(sRange);
            }
            ImmutableBitSet sColumns = ImmutableBitSet.serializer.deserialize(in);
            TupleFilter sGTFilter = GTUtil.deserializeGTFilter(BytesUtil.readByteArray(in), sInfo);
            TupleFilter sGTHavingFilter = null;
            if (serialLevel >= 1) {
                sGTHavingFilter = TupleFilterSerializer.deserialize(BytesUtil.readByteArray(in), StringCodeSystem.INSTANCE);
            }
            ImmutableBitSet sAggGroupBy = ImmutableBitSet.serializer.deserialize(in);
            ImmutableBitSet sAggrMetrics = ImmutableBitSet.serializer.deserialize(in);
            String[] sAggrMetricFuncs = BytesUtil.readAsciiStringArray(in);
            boolean sAllowPreAggr = BytesUtil.readVInt(in) == 1;
            double sAggrCacheGB = in.getDouble();
            StorageLimitLevel storageLimitLevel = StorageLimitLevel.valueOf(BytesUtil.readUTFString(in));
            int storageScanRowNumThreshold = BytesUtil.readVInt(in);
            int storagePushDownLimit = BytesUtil.readVInt(in);
            long startTime = BytesUtil.readVLong(in);
            long timeout = BytesUtil.readVLong(in);
            String storageBehavior = BytesUtil.readUTFString(in);
            ImmutableBitSet aDynCols = ImmutableBitSet.serializer.deserialize(in);
            int nTupleExprs = BytesUtil.readVInt(in);
            HashMap<Integer, TupleExpression> sTupleExpressionMap = Maps.newHashMapWithExpectedSize(nTupleExprs);
            for (int i = 0; i < nTupleExprs; ++i) {
                int sC = BytesUtil.readVInt(in);
                TupleExpression sTupleExpr = TupleExpressionSerializer.deserialize(BytesUtil.readByteArray(in), GTUtil.wrap(sInfo.codeSystem.getComparator()));
                sTupleExpressionMap.put(sC, sTupleExpr);
            }
            ImmutableBitSet aRuntimeAggrMetrics = ImmutableBitSet.serializer.deserialize(in);
            return new GTScanRequestBuilder().setInfo(sInfo).setRanges(sRanges).setDimensions(sColumns).setAggrGroupBy(sAggGroupBy).setAggrMetrics(sAggrMetrics).setAggrMetricsFuncs(sAggrMetricFuncs).setRtAggrMetrics(aRuntimeAggrMetrics).setDynamicColumns(aDynCols).setExprsPushDown(sTupleExpressionMap).setFilterPushDown(sGTFilter).setHavingFilterPushDown(sGTHavingFilter).setAllowStorageAggregation(sAllowPreAggr).setAggCacheMemThreshold(sAggrCacheGB).setStorageScanRowNumThreshold(storageScanRowNumThreshold).setStoragePushDownLimit(storagePushDownLimit).setStorageLimitLevel(storageLimitLevel).setStartTime(startTime).setTimeout(timeout).setStorageBehavior(storageBehavior).createGTScanRequest();
        }

        private void serializeGTRecord(GTRecord gtRecord, ByteBuffer out) {
            BytesUtil.writeVInt(gtRecord.cols.length, out);
            for (ByteArray col : gtRecord.cols) {
                col.exportData(out);
            }
        }

        private GTRecord deserializeGTRecord(ByteBuffer in, GTInfo sInfo) {
            int colLength = BytesUtil.readVInt(in);
            ByteArray[] sCols = new ByteArray[colLength];
            for (int i = 0; i < colLength; ++i) {
                sCols[i] = ByteArray.importData(in);
            }
            return new GTRecord(sInfo, sCols);
        }
    };

    GTScanRequest(GTInfo info, List<GTScanRange> ranges, ImmutableBitSet dimensions, ImmutableBitSet aggrGroupBy, ImmutableBitSet aggrMetrics, String[] aggrMetricsFuncs, ImmutableBitSet rtAggrMetrics, ImmutableBitSet dynamicCols, Map<Integer, TupleExpression> tupleExpressionMap, TupleFilter filterPushDown, TupleFilter havingFilterPushDown, boolean allowStorageAggregation, double aggCacheMemThreshold, int storageScanRowNumThreshold, int storagePushDownLimit, StorageLimitLevel storageLimitLevel, String storageBehavior, long startTime, long timeout) {
        this.info = info;
        this.ranges = ranges == null ? Lists.newArrayList(new GTScanRange(new GTRecord(info), new GTRecord(info))) : ranges;
        this.columns = dimensions;
        this.filterPushDown = filterPushDown;
        this.havingFilterPushDown = havingFilterPushDown;
        this.aggrGroupBy = aggrGroupBy;
        this.aggrMetrics = aggrMetrics;
        this.aggrMetricsFuncs = aggrMetricsFuncs;
        this.rtAggrMetrics = rtAggrMetrics;
        this.dynamicCols = dynamicCols;
        this.tupleExpressionMap = tupleExpressionMap;
        this.storageBehavior = storageBehavior;
        this.startTime = startTime;
        this.timeout = timeout;
        this.allowStorageAggregation = allowStorageAggregation;
        this.aggCacheMemThreshold = aggCacheMemThreshold;
        this.storageScanRowNumThreshold = storageScanRowNumThreshold;
        this.storagePushDownLimit = storagePushDownLimit;
        this.storageLimitLevel = storageLimitLevel;
        this.validate(info);
    }

    private void validate(GTInfo info) {
        if (this.hasAggregation()) {
            if (this.aggrGroupBy.intersects(this.aggrMetrics) || this.aggrGroupBy.intersects(this.rtAggrMetrics)) {
                throw new IllegalStateException();
            }
            if (this.aggrMetrics.cardinality() != this.aggrMetricsFuncs.length) {
                throw new IllegalStateException();
            }
            if (this.columns == null) {
                this.columns = ImmutableBitSet.EMPTY;
            }
            this.columns = this.columns.or(this.aggrGroupBy);
            this.columns = this.columns.or(this.aggrMetrics);
        }
        if (this.columns == null) {
            this.columns = info.colAll;
        }
        if (this.hasFilterPushDown()) {
            this.validateFilterPushDown(info);
        }
        this.selectedColBlocks = info.selectColumnBlocks(this.columns.or(this.rtAggrMetrics).andNot(this.dynamicCols));
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private void validateFilterPushDown(GTInfo info) {
        if (!this.hasFilterPushDown()) {
            return;
        }
        HashSet<TblColRef> filterColumns = Sets.newHashSet();
        TupleFilter.collectColumns(this.filterPushDown, filterColumns);
        for (TblColRef col : filterColumns) {
            info.validateColRef(col);
            this.columns = this.columns.set(col.getColumnDesc().getZeroBasedIndex());
        }
        if (!TupleFilter.isEvaluableRecursively(this.filterPushDown)) {
            HashSet<TblColRef> unevaluableColumns = Sets.newHashSet();
            this.filterPushDown = GTUtil.convertFilterUnevaluatable(this.filterPushDown, info, unevaluableColumns);
            if (this.hasAggregation()) {
                for (TblColRef col : unevaluableColumns) {
                    this.aggrGroupBy = this.aggrGroupBy.set(col.getColumnDesc().getZeroBasedIndex());
                }
            }
        }
    }

    public IGTScanner decorateScanner(IGTScanner scanner) throws IOException {
        return this.decorateScanner(scanner, true, true);
    }

    public IGTScanner decorateScanner(IGTScanner scanner, boolean filterToggledOn, boolean aggrToggledOn) throws IOException {
        return this.decorateScanner(scanner, filterToggledOn, aggrToggledOn, false, true);
    }

    public IGTScanner decorateScanner(IGTScanner scanner, boolean filterToggledOn, boolean aggrToggledOn, boolean hasPreFiltered, boolean spillEnabled) throws IOException {
        IGTScanner result = scanner;
        if (!filterToggledOn) {
            this.lookAndForget(result);
            return new EmptyGTScanner();
        }
        result = this.hasFilterPushDown() && !hasPreFiltered ? new GTFilterScanner(result, this, null) : new GTForwardingScanner(result);
        if (this.tupleExpressionMap != null && !this.tupleExpressionMap.isEmpty()) {
            logger.info("GTFunctionScanner will be used with expressions " + this.tupleExpressionMap);
            result = new GTFunctionScanner(result, this);
        }
        if (!aggrToggledOn) {
            this.lookAndForget(result);
            return new EmptyGTScanner();
        }
        if (!this.isAllowStorageAggregation() && this.havingFilterPushDown == null) {
            logger.info("pre aggregation is not beneficial, skip it");
        } else if (this.hasAggregation()) {
            logger.info("pre aggregating results before returning");
            this.doingStorageAggregation = true;
            result = new GTAggregateScanner(result, this, spillEnabled);
        } else {
            logger.info("has no aggregation, skip it");
        }
        return result;
    }

    public BufferedMeasureCodec createMeasureCodec() {
        DataType[] metricTypes = new DataType[this.aggrMetrics.trueBitCount()];
        for (int i = 0; i < metricTypes.length; ++i) {
            metricTypes[i] = this.info.getColumnType(this.aggrMetrics.trueBitAt(i));
        }
        BufferedMeasureCodec codec = new BufferedMeasureCodec(metricTypes);
        codec.setBufferSize(this.info.getMaxColumnLength(this.aggrMetrics));
        return codec;
    }

    public boolean isDoingStorageAggregation() {
        return this.doingStorageAggregation;
    }

    private int lookAndForget(IGTScanner scanner) {
        int meaninglessByte = 0;
        int scanned = 0;
        for (GTRecord gtRecord : scanner) {
            ++scanned;
            for (ByteArray col : gtRecord.getInternal()) {
                if (col == null) continue;
                int endIndex = col.offset() + col.length();
                for (int i = col.offset(); i < endIndex; ++i) {
                    meaninglessByte = (byte)(meaninglessByte + col.array()[i]);
                }
            }
        }
        logger.info("Meaningless byte is " + meaninglessByte);
        IOUtils.closeQuietly(scanner);
        return scanned;
    }

    public boolean hasFilterPushDown() {
        return this.filterPushDown != null;
    }

    public boolean hasAggregation() {
        return !this.aggrGroupBy.isEmpty() || !this.aggrMetrics.isEmpty();
    }

    public CuboidToGridTableMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(CuboidToGridTableMapping mapping) {
        this.mapping = mapping;
    }

    public GTInfo getInfo() {
        return this.info;
    }

    public List<GTScanRange> getGTScanRanges() {
        return this.ranges;
    }

    public void clearScanRanges() {
        this.ranges = Lists.newArrayList();
    }

    public ImmutableBitSet getSelectedColBlocks() {
        return this.selectedColBlocks;
    }

    public ImmutableBitSet getColumns() {
        return this.columns;
    }

    public TupleFilter getFilterPushDown() {
        return this.filterPushDown;
    }

    public TupleFilter getHavingFilterPushDown() {
        return this.havingFilterPushDown;
    }

    public ImmutableBitSet getDimensions() {
        return this.columns.andNot(this.aggrMetrics);
    }

    public ImmutableBitSet getAggrGroupBy() {
        return this.aggrGroupBy;
    }

    public ImmutableBitSet getAggrMetrics() {
        return this.aggrMetrics;
    }

    public String[] getAggrMetricsFuncs() {
        return this.aggrMetricsFuncs;
    }

    public ImmutableBitSet getDynamicCols() {
        return this.dynamicCols;
    }

    public ImmutableBitSet getRtAggrMetrics() {
        return this.rtAggrMetrics;
    }

    public Map<Integer, TupleExpression> getTupleExpressionMap() {
        return this.tupleExpressionMap;
    }

    public boolean isAllowStorageAggregation() {
        return this.allowStorageAggregation;
    }

    public double getAggCacheMemThreshold() {
        if (this.aggCacheMemThreshold < 0.0) {
            return 0.0;
        }
        return this.aggCacheMemThreshold;
    }

    public void disableAggCacheMemCheck() {
        this.aggCacheMemThreshold = 0.0;
    }

    public int getStorageScanRowNumThreshold() {
        return this.storageScanRowNumThreshold;
    }

    public int getStoragePushDownLimit() {
        return this.storagePushDownLimit;
    }

    public StorageLimitLevel getStorageLimitLevel() {
        return this.storageLimitLevel;
    }

    public String getStorageBehavior() {
        return this.storageBehavior;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return "GTScanRequest [range=" + this.ranges + ", columns=" + this.columns + ", filterPushDown=" + this.filterPushDown + ", aggrGroupBy=" + this.aggrGroupBy + ", aggrMetrics=" + this.aggrMetrics + ", aggrMetricsFuncs=" + Arrays.toString(this.aggrMetricsFuncs) + "]";
    }

    public byte[] toByteArray() {
        ByteBuffer byteBuffer = SerializeToByteBuffer.retrySerialize(new SerializeToByteBuffer.IWriter(){

            @Override
            public void write(ByteBuffer byteBuffer) throws BufferOverflowException {
                serializer.serialize(GTScanRequest.this, byteBuffer);
            }
        });
        return Arrays.copyOf(byteBuffer.array(), byteBuffer.position());
    }
}

