/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.metadata.ColumnDesc;
import org.apache.kylin.engine.spark.metadata.FunctionDesc;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.kylin.engine.spark.utils.Repartitioner;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Set$;
import scala.runtime.BoxesRunTime;

public final class BuildUtils$
implements Logging {
    public static final BuildUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new BuildUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public boolean findCountDistinctMeasure(LayoutEntity layout) {
        return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(layout.getOrderedMeasures().values()).asScala()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FunctionDesc function) {
                return function.returnType().dataType().equalsIgnoreCase("bitmap");
            }
        });
    }

    public int repartitionIfNeed(LayoutEntity layout, NSparkCubingEngine.NSparkCubingStorage storage, String path, String tempPath, KylinConfig config, SparkSession sparkSession) throws IOException {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (fs.exists(new Path(tempPath))) {
            ContentSummary summary = HadoopUtil.getContentSummary(fs, new Path(tempPath));
            long repartitionThresholdSize = config.getParquetStorageShardSizeRowCount();
            if (this.findCountDistinctMeasure(layout)) {
                repartitionThresholdSize = config.getParquetStorageCountDistinctShardSizeRowCount();
            }
            List<Integer> shardByColumns = layout.getShardByColumns();
            Repartitioner repartitioner = new Repartitioner(config.getParquetStorageShardSizeMB(), config.getParquetStorageRepartitionThresholdSize(), layout, repartitionThresholdSize, summary, shardByColumns);
            Column[] sortCols = NSparkCubingUtil.getColumns(layout.getOrderedDimensions().keySet());
            int repartitionNum = repartitioner.getRepartitionNumByStorage();
            repartitioner.doRepartition(storage, path, repartitionNum, sortCols, sparkSession);
            return repartitionNum;
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Temp path does not exist before repartition. Temp path: %s.", tempPath));
    }

    public void fillCuboidInfo(LayoutEntity cuboid, String strPath) throws IOException {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (fs.exists(new Path(strPath)) && cuboid.getRows() > 0L) {
            ContentSummary cs = HadoopUtil.getContentSummary(fs, new Path(strPath));
            cuboid.setFileCount(cs.getFileCount());
            cuboid.setByteSize(cs.getLength());
        } else {
            cuboid.setFileCount(0L);
            cuboid.setByteSize(0L);
        }
    }

    /*
     * WARNING - void declaration
     */
    public YarnConfiguration getCurrentYarnConfiguration() {
        void var1_1;
        YarnConfiguration conf = new YarnConfiguration();
        ((IterableLike)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(System.getProperties().entrySet()).asScala()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Map.Entry<Object, Object> x$1) {
                return ((String)x$1.getKey()).startsWith("spark.hadoop.");
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Map.Entry<Object, Object> entry) {
                return new Tuple2((Object)((String)entry.getKey()).substring("spark.hadoop.".length()), (Object)((String)entry.getValue()));
            }
        }, Set$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final YarnConfiguration conf$1;

            public final void apply(Tuple2<String, String> tp) {
                this.conf$1.set((String)tp._1(), (String)tp._2());
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return var1_1;
    }

    public Map<String, String> getColumnIndexMap(SegmentInfo segInfo) {
        return ((TraversableOnce)segInfo.allColumns().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(ColumnDesc column) {
                return new Tuple2((Object)((Object)BoxesRunTime.boxToInteger((int)column.id())).toString(), (Object)column.columnName());
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private BuildUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

