/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import org.apache.kylin.engine.spark.job.AggInfo;
import org.apache.kylin.engine.spark.job.AggInfo$;
import org.apache.kylin.engine.spark.job.CuboidStatisticsJob$;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.shaded.com.google.common.hash.HashFunction;
import org.apache.kylin.shaded.com.google.common.hash.Hasher;
import org.apache.kylin.shaded.com.google.common.hash.Hashing;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dw!B\u0001\u0003\u0011\u0003y\u0011aE\"vE>LGm\u0015;bi&\u001cH/[2t\u0015>\u0014'BA\u0002\u0005\u0003\rQwN\u0019\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0015tw-\u001b8f\u0015\tI!\"A\u0003ls2LgN\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\u0014\u0007V\u0014w.\u001b3Ti\u0006$\u0018n\u001d;jGNTuNY\n\u0004#QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006=E!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=AQ!I\t\u0005\u0002\t\n!b\u001d;bi&\u001cH/[2t)\r\u0019sf\u000f\t\u0004+\u00112\u0013BA\u0013\u0017\u0005\u0015\t%O]1z!\u0011)r%\u000b\u0017\n\u0005!2\"A\u0002+va2,'\u0007\u0005\u0002\u0016U%\u00111F\u0006\u0002\u0005\u0019>tw\r\u0005\u0002\u0011[%\u0011aF\u0001\u0002\b\u0003\u001e<\u0017J\u001c4p\u0011\u0015\u0001\u0004\u00051\u00012\u0003\u001dIg\u000e];u\tN\u00042A\r\u001c9\u001b\u0005\u0019$B\u0001\u001b6\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b)I!aN\u001a\u0003\u000f\u0011\u000bG/Y:fiB\u0011!'O\u0005\u0003uM\u00121AU8x\u0011\u0015a\u0004\u00051\u0001>\u0003\r\u0019Xm\u001a\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u0012\t\u0001\"\\3uC\u0012\fG/Y\u0005\u0003\u0005~\u00121bU3h[\u0016tG/\u00138g_\")\u0011%\u0005C\u0001\tR!1%\u0012$H\u0011\u0015\u00014\t1\u00012\u0011\u0015a4\t1\u0001>\u0011\u0015A5\t1\u0001J\u0003%a\u0017-_8vi&#7\u000fE\u0002\u0016I%BqaS\t\u0002\u0002\u0013%A*A\u0006sK\u0006$'+Z:pYZ,G#A'\u0011\u00059\u001bV\"A(\u000b\u0005A\u000b\u0016\u0001\u00027b]\u001eT\u0011AU\u0001\u0005U\u00064\u0018-\u0003\u0002U\u001f\n1qJ\u00196fGR4AA\u0005\u0002\u0001-N\u0019Q\u000b\u0006\u000e\t\u0011a+&\u0011!Q\u0001\n%\u000b1!\u001b3t\u0011!QVK!A!\u0002\u0013Y\u0016a\u0001:lGB\u0011Q\u0003X\u0005\u0003;Z\u00111!\u00138u\u0011\u0015qR\u000b\"\u0001`)\r\u0001\u0017M\u0019\t\u0003!UCQ\u0001\u00170A\u0002%CQA\u00170A\u0002mCq\u0001Z+C\u0002\u0013%Q-\u0001\u0003j]\u001a|W#\u00014\u0011\u0007\u001ddG&D\u0001i\u0015\tI'.A\u0004nkR\f'\r\\3\u000b\u0005-4\u0012AC2pY2,7\r^5p]&\u0011Q\u000e\u001b\u0002\b\u0019>tw-T1q\u0011\u0019yW\u000b)A\u0005M\u0006)\u0011N\u001c4pA!9\u0011/\u0016a\u0001\n\u0013\u0011\u0018\u0001E1mY\u000e+(m\\5eg\nKGoU3u+\u0005\u0019\bcA\u000b%iB\u0019Q\u0003J;\u0011\u000593\u0018BA<P\u0005\u001dIe\u000e^3hKJDq!_+A\u0002\u0013%!0\u0001\u000bbY2\u001cUOY8jIN\u0014\u0015\u000e^*fi~#S-\u001d\u000b\u0003wz\u0004\"!\u0006?\n\u0005u4\"\u0001B+oSRDqa =\u0002\u0002\u0003\u00071/A\u0002yIEBq!a\u0001VA\u0003&1/A\tbY2\u001cUOY8jIN\u0014\u0015\u000e^*fi\u0002B\u0011\"a\u0002V\u0005\u0004%I!!\u0003\u0002\u0005!4WCAA\u0006!\u0011\ti!a\t\u000e\u0005\u0005=!\u0002BA\t\u0003'\tA\u0001[1tQ*!\u0011QCA\f\u0003\u0019\u0019w.\\7p]*!\u0011\u0011DA\u000e\u0003\u00199wn\\4mK*!\u0011QDA\u0010\u0003\r\u0019w.\u001c\u0006\u0004\u0003CA\u0011AB:iC\u0012,G-\u0003\u0003\u0002&\u0005=!\u0001\u0004%bg\"4UO\\2uS>t\u0007\u0002CA\u0015+\u0002\u0006I!a\u0003\u0002\u0007!4\u0007\u0005C\u0005\u0002.U\u0013\r\u0011\"\u0003\u00020\u0005\u0001\"o\\<ICND7i\u001c3fg2{gnZ\u000b\u0002\u0013\"9\u00111G+!\u0002\u0013I\u0015!\u0005:po\"\u000b7\u000f[\"pI\u0016\u001cHj\u001c8hA!I\u0011qG+A\u0002\u0013%\u0011\u0011H\u0001\u0004S\u0012DX#A.\t\u0013\u0005uR\u000b1A\u0005\n\u0005}\u0012aB5eq~#S-\u001d\u000b\u0004w\u0006\u0005\u0003\u0002C@\u0002<\u0005\u0005\t\u0019A.\t\u000f\u0005\u0015S\u000b)Q\u00057\u0006!\u0011\u000e\u001a=!\u0011%\tI%\u0016a\u0001\n\u0013\tY%\u0001\u0004nKR,'OM\u000b\u0002S!I\u0011qJ+A\u0002\u0013%\u0011\u0011K\u0001\u000b[\u0016$XM\u001d\u001a`I\u0015\fHcA>\u0002T!Aq0!\u0014\u0002\u0002\u0003\u0007\u0011\u0006C\u0004\u0002XU\u0003\u000b\u0015B\u0015\u0002\u000f5,G/\u001a:3A!I\u00111L+A\u0002\u0013%\u00111J\u0001\u000bgR\f'\u000f^'jY2\u001c\b\"CA0+\u0002\u0007I\u0011BA1\u00039\u0019H/\u0019:u\u001b&dGn]0%KF$2a_A2\u0011!y\u0018QLA\u0001\u0002\u0004I\u0003bBA4+\u0002\u0006K!K\u0001\fgR\f'\u000f^'jY2\u001c\b\u0005C\u0005\u0002lU\u0003\r\u0011\"\u0003\u0002L\u0005AQM\u001c3NS2d7\u000fC\u0005\u0002pU\u0003\r\u0011\"\u0003\u0002r\u0005aQM\u001c3NS2d7o\u0018\u0013fcR\u001910a\u001d\t\u0011}\fi'!AA\u0002%Bq!a\u001eVA\u0003&\u0011&A\u0005f]\u0012l\u0015\u000e\u001c7tA!9\u00111P+\u0005\u0002\u0005u\u0014!G:uCRL7\u000f^5dg^KG\u000f[5o!\u0006\u0014H/\u001b;j_:$B!a \u0002\u0018B)\u0011\u0011QAIY9!\u00111QAG\u001d\u0011\t))a#\u000e\u0005\u0005\u001d%bAAE\u001d\u00051AH]8pizJ\u0011aF\u0005\u0004\u0003\u001f3\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003'\u000b)J\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\tyI\u0006\u0005\t\u00033\u000bI\b1\u0001\u0002\u001c\u0006!!o\\<t!\u0015\t\t)!%9\u0011\u001d\ty*\u0016C\u0001\u0003C\u000bA!\u001b8jiR\t1\u0010C\u0004\u0002&V#\t!a*\u0002\rU\u0004H-\u0019;f)\rY\u0018\u0011\u0016\u0005\b\u0003W\u000b\u0019\u000b1\u00019\u0003\u0005\u0011\bbBAX+\u0012\u0005\u0011\u0011W\u0001\rkB$\u0017\r^3Dk\n|\u0017\u000e\u001a\u000b\u0004w\u0006M\u0006bBAV\u0003[\u0003\r\u0001\u000f\u0005\b\u0003o+F\u0011AA]\u0003=9W\r^\"vE>LGMQ5u'\u0016$H#B:\u0002<\u0006}\u0006bBA_\u0003k\u0003\r!S\u0001\nGV\u0014w.\u001b3JINDq!!1\u00026\u0002\u00071,A\u0004o%><8*Z=\t\u000f\u0005\u0015W\u000b\"\u0001\u0002\"\u0006I\u0001O]5oiN#\u0018\r\u001e")
public class CuboidStatisticsJob
implements Serializable {
    private final long[] ids;
    private final int rkc;
    private final LongMap<AggInfo> org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info;
    private Integer[][] allCuboidsBitSet;
    private final HashFunction hf;
    private final long[] rowHashCodesLong;
    private int idx;
    private long meter2;
    private long startMills;
    private long endMills;

    public static Tuple2<Object, AggInfo>[] statistics(Dataset<Row> dataset, SegmentInfo segmentInfo, long[] lArray) {
        return CuboidStatisticsJob$.MODULE$.statistics(dataset, segmentInfo, lArray);
    }

    public static Tuple2<Object, AggInfo>[] statistics(Dataset<Row> dataset, SegmentInfo segmentInfo) {
        return CuboidStatisticsJob$.MODULE$.statistics(dataset, segmentInfo);
    }

    public LongMap<AggInfo> org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info() {
        return this.org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info;
    }

    private Integer[][] allCuboidsBitSet() {
        return this.allCuboidsBitSet;
    }

    private void allCuboidsBitSet_$eq(Integer[][] x$1) {
        this.allCuboidsBitSet = x$1;
    }

    private HashFunction hf() {
        return this.hf;
    }

    private long[] rowHashCodesLong() {
        return this.rowHashCodesLong;
    }

    private int idx() {
        return this.idx;
    }

    private void idx_$eq(int x$1) {
        this.idx = x$1;
    }

    private long meter2() {
        return this.meter2;
    }

    private void meter2_$eq(long x$1) {
        this.meter2 = x$1;
    }

    private long startMills() {
        return this.startMills;
    }

    private void startMills_$eq(long x$1) {
        this.startMills = x$1;
    }

    private long endMills() {
        return this.endMills;
    }

    private void endMills_$eq(long x$1) {
        this.endMills = x$1;
    }

    public Iterator<AggInfo> statisticsWithinPartition(Iterator<Row> rows) {
        this.init();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"CuboidStatisticsJob-statisticsWithinPartition1-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString());
        rows.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CuboidStatisticsJob $outer;

            public final void apply(Row r) {
                this.$outer.update(r);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.printStat();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"CuboidStatisticsJob-statisticsWithinPartition2-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString());
        return this.org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info().valuesIterator();
    }

    public void init() {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"CuboidStatisticsJob-Init1-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString());
        this.allCuboidsBitSet_$eq(this.getCuboidBitSet(this.ids, this.rkc));
        Predef$.MODULE$.longArrayOps(this.ids).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CuboidStatisticsJob $outer;

            public final Option<AggInfo> apply(long i) {
                return this.$outer.org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info().put(i, (Object)new AggInfo(i, AggInfo$.MODULE$.apply$default$2(), AggInfo$.MODULE$.apply$default$3(), AggInfo$.MODULE$.apply$default$4()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"CuboidStatisticsJob-Init2-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString());
    }

    public void update(Row r) {
        this.idx_$eq(this.idx() + 1);
        if (this.idx() <= 5) {
            Predef$.MODULE$.println((Object)r);
        }
        this.updateCuboid(r);
    }

    public void updateCuboid(Row r) {
        int idx;
        for (idx = 0; idx < this.rkc; ++idx) {
            Hasher hc = this.hf().newHasher();
            String colValue = r.get(idx) == null ? "0" : r.get(idx).toString();
            this.rowHashCodesLong()[idx] = hc.putUnencodedChars(colValue).hash().padToLong() + (long)idx;
        }
        this.startMills_$eq(System.currentTimeMillis());
        int n = this.allCuboidsBitSet().length;
        for (idx = 0; idx < n; ++idx) {
            long value = 0L;
            Integer[] currCuboidBitSet = this.allCuboidsBitSet()[idx];
            int currCuboidLength = currCuboidBitSet.length;
            for (int position = 0; position < currCuboidLength; ++position) {
                value += this.rowHashCodesLong()[Predef$.MODULE$.Integer2int(currCuboidBitSet[position])];
            }
            ((AggInfo)this.org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info().apply(this.ids[idx])).cuboid().counter().addHashDirectly(value);
        }
        this.endMills_$eq(System.currentTimeMillis());
        this.meter2_$eq(this.meter2() + (this.endMills() - this.startMills()));
    }

    /*
     * WARNING - void declaration
     */
    public Integer[][] getCuboidBitSet(long[] cuboidIds, int nRowKey) {
        void var3_3;
        Integer[][] allCuboidsBitSet = new Integer[cuboidIds.length][];
        for (int j = 0; j < cuboidIds.length; ++j) {
            long cuboidId = cuboidIds[j];
            allCuboidsBitSet[j] = new Integer[Long.bitCount(cuboidId)];
            long mask = 1L << nRowKey - 1;
            int position = 0;
            for (int i = 0; i < nRowKey; ++i) {
                if ((mask & cuboidId) > 0L) {
                    allCuboidsBitSet[j][position] = Predef$.MODULE$.int2Integer(i);
                    ++position;
                }
                mask >>= 1;
            }
        }
        return var3_3;
    }

    public void printStat() {
        Predef$.MODULE$.println((Object)"    Stats");
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"i      :").append((Object)BoxesRunTime.boxToInteger((int)this.idx())).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"meter  :").append((Object)BoxesRunTime.boxToLong((long)this.meter2())).toString());
    }

    public CuboidStatisticsJob(long[] ids, int rkc) {
        this.ids = ids;
        this.rkc = rkc;
        this.org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info = LongMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.allCuboidsBitSet = (Integer[][])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.class)));
        this.hf = Hashing.murmur3_128();
        this.rowHashCodesLong = new long[rkc];
        this.idx = 0;
        this.meter2 = 0L;
        this.startMills = 0L;
        this.endMills = 0L;
    }
}

