/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.builder.CubeMergeAssist;
import org.apache.kylin.engine.spark.builder.NBuildSourceInfo;
import org.apache.kylin.engine.spark.job.BuildLayoutWithUpdate;
import org.apache.kylin.engine.spark.job.CubeBuildJob;
import org.apache.kylin.engine.spark.job.CuboidAggregator;
import org.apache.kylin.engine.spark.job.LogJobInfoUtils;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.engine.spark.metadata.cube.ManagerHub;
import org.apache.kylin.engine.spark.metadata.cube.PathManager;
import org.apache.kylin.engine.spark.metadata.cube.model.ForestSpanningTree;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.kylin.engine.spark.utils.BuildUtils;
import org.apache.kylin.engine.spark.utils.JobMetrics;
import org.apache.kylin.engine.spark.utils.JobMetricsUtils;
import org.apache.kylin.engine.spark.utils.Metrics;
import org.apache.kylin.engine.spark.utils.QueryExecutionCache;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.storage.StorageFactory;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;
import scala.collection.immutable.List;

public class CubeMergeJob
extends SparkApplication {
    protected static final Logger logger = LoggerFactory.getLogger(CubeMergeJob.class);
    private BuildLayoutWithUpdate buildLayoutWithUpdate;
    private Map<Long, CubeMergeAssist> mergeCuboidsAssist;
    private java.util.List<CubeSegment> mergingSegments = Lists.newArrayList();
    private java.util.List<SegmentInfo> mergingSegInfos = Lists.newArrayList();
    private Map<Long, Short> cuboidShardNum = Maps.newConcurrentMap();

    @Override
    protected void doExecute() throws Exception {
        this.buildLayoutWithUpdate = new BuildLayoutWithUpdate(this.config);
        String cubeId = this.getParam("cubeId");
        String newSegmentId = this.getParam("segmentIds");
        CubeManager cubeManager = CubeManager.getInstance(this.config);
        CubeInstance cube = cubeManager.getCubeByUuid(cubeId);
        CubeSegment mergedSeg = cube.getSegmentById(newSegmentId);
        this.mergingSegments = cube.getMergingSegments(mergedSeg);
        for (CubeSegment segment : this.mergingSegments) {
            SegmentInfo segInfo = ManagerHub.getSegmentInfo(this.config, this.getParam("cubeId"), segment.getUuid());
            this.mergingSegInfos.add(segInfo);
        }
        this.mergeSegments(cubeId, newSegmentId);
        this.updateSegmentInfo(cubeId, newSegmentId);
    }

    private void mergeSegments(String cubeId, String segmentId) throws IOException {
        CubeManager mgr = CubeManager.getInstance(this.config);
        CubeInstance cube = mgr.getCubeByUuid(cubeId);
        CubeSegment mergedSeg = cube.getSegmentById(segmentId);
        final SegmentInfo mergedSegInfo = ManagerHub.getSegmentInfo(this.config, this.getParam("cubeId"), mergedSeg.getUuid());
        this.mergeCuboidsAssist = CubeMergeJob.generateMergeAssist(this.mergingSegInfos, this.ss);
        for (final CubeMergeAssist assist : this.mergeCuboidsAssist.values()) {
            Dataset afterSort;
            ForestSpanningTree spanningTree = new ForestSpanningTree(JavaConversions.asJavaCollection(mergedSegInfo.toBuildLayouts()));
            Dataset<Row> afterMerge = assist.merge(this.config, cube.getName());
            final LayoutEntity layout = assist.getLayout();
            if (layout.isTableIndex()) {
                afterSort = afterMerge.sortWithinPartitions(NSparkCubingUtil.getColumns(layout.getOrderedDimensions().keySet()));
            } else {
                Set<Integer> dimColumns = layout.getOrderedDimensions().keySet();
                Dataset<Row> afterAgg = CuboidAggregator.agg(this.ss, afterMerge, dimColumns, layout.getOrderedMeasures(), spanningTree, false);
                afterSort = afterAgg.sortWithinPartitions(NSparkCubingUtil.getColumns(dimColumns));
            }
            this.buildLayoutWithUpdate.submit(new BuildLayoutWithUpdate.JobEntity(){

                @Override
                public String getName() {
                    return "merge-cuboid-" + layout.getId();
                }

                @Override
                public LayoutEntity build() throws IOException {
                    return CubeMergeJob.this.saveAndUpdateCuboid((Dataset<Row>)afterSort, mergedSegInfo, layout, assist);
                }

                @Override
                public NBuildSourceInfo getBuildSourceInfo() {
                    return null;
                }
            }, this.config);
            this.buildLayoutWithUpdate.updateLayout(mergedSegInfo, this.config);
        }
    }

    public static Map<Long, CubeMergeAssist> generateMergeAssist(java.util.List<SegmentInfo> mergingSegments, SparkSession ss) {
        ConcurrentMap<Long, CubeMergeAssist> mergeCuboidsAssist = Maps.newConcurrentMap();
        for (SegmentInfo seg : mergingSegments) {
            List<LayoutEntity> cuboids = seg.layouts();
            for (int i = 0; i < cuboids.size(); ++i) {
                LayoutEntity cuboid = (LayoutEntity)cuboids.apply(i);
                long layoutId = cuboid.getId();
                CubeMergeAssist assist = (CubeMergeAssist)mergeCuboidsAssist.get(layoutId);
                if (assist == null) {
                    assist = new CubeMergeAssist();
                    assist.addCuboid(cuboid);
                    assist.setSs(ss);
                    assist.setLayout(cuboid);
                    assist.setNewSegment(seg);
                    assist.setToMergeSegments(mergingSegments);
                    mergeCuboidsAssist.put(layoutId, assist);
                    continue;
                }
                assist.addCuboid(cuboid);
            }
        }
        return mergeCuboidsAssist;
    }

    private LayoutEntity saveAndUpdateCuboid(Dataset<Row> dataset, SegmentInfo seg, LayoutEntity layout, CubeMergeAssist assist) throws IOException {
        long layoutId = layout.getId();
        long sourceCount = 0L;
        for (LayoutEntity cuboid : assist.getCuboids()) {
            sourceCount += cuboid.getSourceRows();
        }
        String queryExecutionId = UUID.randomUUID().toString();
        this.ss.sparkContext().setLocalProperty(QueryExecutionCache.N_EXECUTION_ID_KEY(), queryExecutionId);
        this.ss.sparkContext().setJobDescription("merge layout " + layoutId);
        NSparkCubingEngine.NSparkCubingStorage storage = StorageFactory.createEngineAdapter(layout, NSparkCubingEngine.NSparkCubingStorage.class);
        String path = PathManager.getParquetStoragePath(this.config, this.getParam("cubeName"), seg.name(), seg.identifier(), String.valueOf(layoutId));
        String tempPath = path + CubeBuildJob.TEMP_DIR_SUFFIX;
        storage.saveTo(tempPath, dataset, this.ss);
        JobMetrics metrics = JobMetricsUtils.collectMetrics(queryExecutionId);
        long rowCount = metrics.getMetrics(Metrics.CUBOID_ROWS_CNT());
        if (rowCount == -1L) {
            this.infos.recordAbnormalLayouts(layout.getId(), "'Job metrics seems null, use count() to collect cuboid rows.'");
            logger.warn("Can not get cuboid row cnt, use count() to collect cuboid rows.");
            layout.setRows(dataset.count());
        } else {
            layout.setRows(rowCount);
        }
        layout.setSourceRows(sourceCount);
        int partitionNum = BuildUtils.repartitionIfNeed(layout, storage, path, tempPath, this.config, this.ss);
        layout.setShardNum(partitionNum);
        this.cuboidShardNum.put(layoutId, (short)partitionNum);
        this.ss.sparkContext().setLocalProperty(QueryExecutionCache.N_EXECUTION_ID_KEY(), null);
        this.ss.sparkContext().setJobDescription(null);
        QueryExecutionCache.removeQueryExecution(queryExecutionId);
        BuildUtils.fillCuboidInfo(layout, path);
        return layout;
    }

    private void updateSegmentInfo(String cubeId, String segmentId) throws IOException {
        CubeManager cubeManager = CubeManager.getInstance(this.config);
        CubeInstance cubeCopy = cubeManager.getCubeByUuid(cubeId).latestCopyForWrite();
        CubeUpdate update2 = new CubeUpdate(cubeCopy);
        ArrayList<CubeSegment> cubeSegments = Lists.newArrayList();
        CubeSegment segment = cubeCopy.getSegmentById(segmentId);
        long totalSourceSize = 0L;
        long totalInputRecords = 0L;
        long totalInputRecordsSize = 0L;
        for (CubeMergeAssist assist : this.mergeCuboidsAssist.values()) {
            totalSourceSize += assist.getLayout().getByteSize();
        }
        for (CubeSegment toRemoveSeg : this.mergingSegments) {
            totalInputRecords += toRemoveSeg.getInputRecords();
            totalInputRecordsSize += toRemoveSeg.getInputRecordsSize();
        }
        segment.setSizeKB(totalSourceSize / 1024L);
        segment.setInputRecords(totalInputRecords);
        segment.setInputRecordsSize(totalInputRecordsSize);
        segment.setLastBuildJobID(this.getParam("jobId"));
        segment.setCuboidShardNums(this.cuboidShardNum);
        Map<String, String> additionalInfo = segment.getAdditionalInfo();
        additionalInfo.put("storageType", "4");
        segment.setAdditionalInfo(additionalInfo);
        cubeSegments.add(segment);
        update2.setToUpdateSegs(cubeSegments.toArray(new CubeSegment[0]));
        cubeManager.updateCube(update2, true);
    }

    @Override
    protected String generateInfo() {
        return LogJobInfoUtils.dfMergeJobInfo();
    }

    public static void main(String[] args) {
        CubeMergeJob cubeMergeJob = new CubeMergeJob();
        cubeMergeJob.execute(args);
    }
}

