/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.engine.mr.common.CuboidRecommenderUtil;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsDecisionUtil {
    protected static final Logger logger = LoggerFactory.getLogger(StatisticsDecisionUtil.class);

    public static void decideCubingAlgorithm(CubingJob cubingJob, CubeSegment seg) throws IOException {
        CubeStatsReader cubeStats = new CubeStatsReader(seg, null, seg.getConfig());
        StatisticsDecisionUtil.decideCubingAlgorithm(cubingJob, seg, cubeStats.getMapperOverlapRatioOfFirstBuild(), cubeStats.getMapperNumberOfFirstBuild());
    }

    public static void decideCubingAlgorithm(CubingJob cubingJob, CubeSegment seg, double mapperOverlapRatio, int mapperNumber) throws IOException {
        CubingJob.AlgorithmEnum alg;
        KylinConfig kylinConf = seg.getConfig();
        String algPref = kylinConf.getCubeAlgorithm();
        if (mapperOverlapRatio == 0.0 && kylinConf.isAutoInmemToOptimize()) {
            alg = CubingJob.AlgorithmEnum.INMEM;
        } else if (CubingJob.AlgorithmEnum.INMEM.name().equalsIgnoreCase(algPref)) {
            alg = CubingJob.AlgorithmEnum.INMEM;
            if (seg.getCubeDesc().isStreamingCube() && CubingJob.CubingJobTypeEnum.getByName(cubingJob.getJobType()) == CubingJob.CubingJobTypeEnum.BUILD) {
                alg = CubingJob.AlgorithmEnum.LAYER;
            }
        } else if (CubingJob.AlgorithmEnum.LAYER.name().equalsIgnoreCase(algPref)) {
            alg = CubingJob.AlgorithmEnum.LAYER;
        } else {
            int memoryHungryMeasures = 0;
            for (MeasureDesc measure : seg.getCubeDesc().getMeasures()) {
                if (!measure.getFunction().getMeasureType().isMemoryHungry()) continue;
                logger.info("This cube has memory-hungry measure " + measure.getFunction().getExpression());
                ++memoryHungryMeasures;
            }
            if (memoryHungryMeasures > 0) {
                alg = CubingJob.AlgorithmEnum.LAYER;
            } else if ("random".equalsIgnoreCase(algPref)) {
                alg = new Random().nextBoolean() ? CubingJob.AlgorithmEnum.INMEM : CubingJob.AlgorithmEnum.LAYER;
            } else {
                int mapperNumLimit = kylinConf.getCubeAlgorithmAutoMapperLimit();
                double overlapThreshold = kylinConf.getCubeAlgorithmAutoThreshold();
                logger.info("mapperNumber for " + seg + " is " + mapperNumber + " and threshold is " + mapperNumLimit);
                logger.info("mapperOverlapRatio for " + seg + " is " + mapperOverlapRatio + " and threshold is " + overlapThreshold);
                alg = mapperNumber <= mapperNumLimit && mapperOverlapRatio <= overlapThreshold ? CubingJob.AlgorithmEnum.INMEM : CubingJob.AlgorithmEnum.LAYER;
            }
        }
        logger.info("The cube algorithm for " + seg + " is " + (Object)((Object)alg));
        cubingJob.setAlgorithm(alg);
    }

    public static Map<Long, Long> optimizeCubingPlan(CubeSegment segment) throws IOException {
        if (!StatisticsDecisionUtil.isAbleToOptimizeCubingPlan(segment)) {
            return new HashMap<Long, Long>();
        }
        logger.info("It's able to trigger cuboid planner algorithm.");
        Map<Long, Long> recommendCuboidsWithStats = CuboidRecommenderUtil.getRecommendCuboidList(segment);
        if (recommendCuboidsWithStats == null || recommendCuboidsWithStats.isEmpty()) {
            return new HashMap<Long, Long>();
        }
        CubeInstance cube = segment.getCubeInstance();
        CubeUpdate update2 = new CubeUpdate(cube.latestCopyForWrite());
        update2.setCuboids(recommendCuboidsWithStats);
        CubeManager.getInstance(cube.getConfig()).updateCube(update2);
        return recommendCuboidsWithStats;
    }

    public static boolean isAbleToOptimizeCubingPlan(CubeSegment segment) {
        CubeInstance cube = segment.getCubeInstance();
        if (!cube.getConfig().isCubePlannerEnabled()) {
            return false;
        }
        if (cube.getSegments(SegmentStatusEnum.READY_PENDING).size() > 0) {
            logger.info("Has read pending segments and will not enable cube planner.");
            return false;
        }
        Segments<CubeSegment> readySegments = cube.getSegments(SegmentStatusEnum.READY);
        Segments<CubeSegment> newSegments = cube.getSegments(SegmentStatusEnum.NEW);
        return newSegments.size() <= 1 && (readySegments.size() == 0 || cube.getConfig().isCubePlannerEnabledForExistingCube() && readySegments.size() == 1 && ((CubeSegment)readySegments.get(0)).getSegRange().equals(segment.getSegRange()));
    }
}

