/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidStatsReaderUtil {
    private static final Logger logger = LoggerFactory.getLogger(CuboidStatsReaderUtil.class);

    public static Map<Long, Long> readCuboidStatsFromCube(Set<Long> cuboidIds, CubeInstance cubeInstance) {
        Map<Long, Long> statisticsMerged = null;
        try {
            statisticsMerged = CuboidStatsReaderUtil.readCuboidStatsAndSizeFromCube(cuboidIds, cubeInstance).getFirst();
        }
        catch (IOException e) {
            logger.warn("Fail to read statistics for cube " + cubeInstance.getName() + " due to " + e);
        }
        return statisticsMerged == null ? Collections.emptyMap() : statisticsMerged;
    }

    public static Pair<Map<Long, Long>, Map<Long, Double>> readCuboidStatsAndSizeFromCube(Set<Long> cuboidIds, CubeInstance cube) throws IOException {
        Preconditions.checkNotNull(cuboidIds, (Object)"The cuboid set can not be null");
        Preconditions.checkNotNull((Object)cube, (Object)"The cube instance can not be null");
        Segments<CubeSegment> segmentList = cube.getSegments(SegmentStatusEnum.READY);
        HashMap statisticsMerged = Maps.newHashMapWithExpectedSize((int)cuboidIds.size());
        HashMap sizeMerged = Maps.newHashMapWithExpectedSize((int)cuboidIds.size());
        CuboidStatsReaderUtil.readCuboidStatsFromSegments(cuboidIds, segmentList, statisticsMerged, sizeMerged);
        return new Pair<Map<Long, Long>, Map<Long, Double>>(statisticsMerged, sizeMerged);
    }

    public static Map<Long, Long> readCuboidStatsFromSegments(Set<Long> cuboidIds, List<CubeSegment> segmentList) throws IOException {
        HashMap statisticsMerged = Maps.newHashMapWithExpectedSize((int)cuboidIds.size());
        CuboidStatsReaderUtil.readCuboidStatsFromSegments(cuboidIds, segmentList, statisticsMerged, Maps.newHashMapWithExpectedSize((int)cuboidIds.size()));
        return statisticsMerged.isEmpty() ? null : statisticsMerged;
    }

    public static Map<Long, Double> readCuboidSizeFromCube(Map<Long, Long> statistics, CubeInstance cube) throws IOException {
        Segments<CubeSegment> segmentList = cube.getSegments(SegmentStatusEnum.READY);
        HashMap sizeMerged = Maps.newHashMapWithExpectedSize((int)statistics.size());
        for (CubeSegment pSegment : segmentList) {
            CubeStatsReader pReader = new CubeStatsReader(pSegment, null, pSegment.getConfig());
            Map<Long, Double> pSizeMap = CubeStatsReader.getCuboidSizeMapFromRowCount(pSegment, statistics, pReader.sourceRowCount);
            Iterator<Long> iterator = statistics.keySet().iterator();
            while (iterator.hasNext()) {
                Long pCuboid;
                Double pSize = (Double)sizeMerged.get(pCuboid = iterator.next());
                sizeMerged.put(pCuboid, pSize == null ? pSizeMap.get(pCuboid) : Double.valueOf(pSize + pSizeMap.get(pCuboid)));
            }
        }
        int nSegment = segmentList.size();
        if (nSegment <= 1) {
            return sizeMerged;
        }
        for (Long pCuboid : statistics.keySet()) {
            sizeMerged.put(pCuboid, (Double)sizeMerged.get(pCuboid) / (double)nSegment);
        }
        return sizeMerged;
    }

    private static void readCuboidStatsFromSegments(Set<Long> cuboidSet, List<CubeSegment> segmentList, Map<Long, Long> statisticsMerged, Map<Long, Double> sizeMerged) throws IOException {
        if (segmentList == null || segmentList.isEmpty()) {
            return;
        }
        int nSegment = segmentList.size();
        HashMap cuboidHLLMapMerged = Maps.newHashMapWithExpectedSize((int)cuboidSet.size());
        HashMap sizeMapMerged = Maps.newHashMapWithExpectedSize((int)cuboidSet.size());
        for (CubeSegment pSegment : segmentList) {
            CubeStatsReader pReader = new CubeStatsReader(pSegment, null, pSegment.getConfig());
            Map<Long, HLLCounter> pHLLMap = pReader.getCuboidRowHLLCounters();
            if (pHLLMap == null || pHLLMap.isEmpty()) {
                logger.info("Cuboid Statistics for segment " + pSegment.getName() + " is not enabled.");
                --nSegment;
                continue;
            }
            Map<Long, Double> pSizeMap = pReader.getCuboidSizeMap();
            for (Long pCuboid : cuboidSet) {
                HLLCounter pInnerHLL = pHLLMap.get(pCuboid);
                Preconditions.checkNotNull((Object)pInnerHLL, (Object)("statistics should exist for cuboid " + pCuboid + " of segment " + pSegment.getCubeDesc().getName() + "[" + pSegment.getName() + "]"));
                if (cuboidHLLMapMerged.get(pCuboid) != null) {
                    ((HLLCounter)cuboidHLLMapMerged.get(pCuboid)).merge(pInnerHLL);
                } else {
                    cuboidHLLMapMerged.put(pCuboid, pInnerHLL);
                }
                Double pSize = (Double)sizeMapMerged.get(pCuboid);
                sizeMapMerged.put(pCuboid, pSize == null ? pSizeMap.get(pCuboid) : Double.valueOf(pSizeMap.get(pCuboid) + pSize));
            }
        }
        if (nSegment < 1) {
            return;
        }
        for (Long pCuboid : cuboidSet) {
            statisticsMerged.put(pCuboid, ((HLLCounter)cuboidHLLMapMerged.get(pCuboid)).getCountEstimate());
            sizeMerged.put(pCuboid, (Double)sizeMapMerged.get(pCuboid));
        }
    }

    public static Map<Long, Long> readCuboidStatsFromSegment(Set<Long> cuboidIds, CubeSegment cubeSegment) throws IOException {
        Pair<Map<Long, Long>, Long> stats = CuboidStatsReaderUtil.readCuboidStatsWithSourceFromSegment(cuboidIds, cubeSegment);
        return stats == null ? null : stats.getFirst();
    }

    public static Pair<Map<Long, Long>, Long> readCuboidStatsWithSourceFromSegment(Set<Long> cuboidIds, CubeSegment cubeSegment) throws IOException {
        if (cubeSegment == null) {
            logger.warn("The cube segment can not be " + null);
            return null;
        }
        CubeStatsReader cubeStatsReader = new CubeStatsReader(cubeSegment, null, cubeSegment.getConfig());
        if (cubeStatsReader.getCuboidRowEstimatesHLL() == null || cubeStatsReader.getCuboidRowEstimatesHLL().isEmpty()) {
            logger.info("Cuboid Statistics is not enabled.");
            return null;
        }
        Map<Long, Long> cuboidsWithStatsAll = cubeStatsReader.getCuboidRowEstimatesHLL();
        HashMap cuboidsWithStats = Maps.newHashMapWithExpectedSize((int)cuboidIds.size());
        for (Long cuboid : cuboidIds) {
            Long rowEstimate = cuboidsWithStatsAll.get(cuboid);
            if (rowEstimate == null) {
                logger.warn("Cannot get the row count stats for cuboid " + cuboid);
                continue;
            }
            cuboidsWithStats.put(cuboid, rowEstimate);
        }
        return new Pair<Map<Long, Long>, Long>(cuboidsWithStats, cubeStatsReader.sourceRowCount);
    }
}

