/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.common.util.MemoryBudgetController;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.gridtable.CubeGridTable;
import org.apache.kylin.cube.inmemcubing.AbstractInMemCubeBuilder;
import org.apache.kylin.cube.inmemcubing.ConcurrentDiskStore;
import org.apache.kylin.cube.inmemcubing.CuboidResult;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.cube.inmemcubing.InMemCubeBuilderUtils;
import org.apache.kylin.cube.inmemcubing.InputConverter;
import org.apache.kylin.cube.inmemcubing.InputConverterUnit;
import org.apache.kylin.cube.inmemcubing.RecordConsumeBlockingQueueController;
import org.apache.kylin.cube.kv.CubeDimEncMap;
import org.apache.kylin.gridtable.GTAggregateScanner;
import org.apache.kylin.gridtable.GTBuilder;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.GTScanRequestBuilder;
import org.apache.kylin.gridtable.GridTable;
import org.apache.kylin.measure.topn.Counter;
import org.apache.kylin.measure.topn.TopNCounter;
import org.apache.kylin.metadata.datatype.DoubleMutable;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemCubeBuilder
extends AbstractInMemCubeBuilder {
    private static Logger logger = LoggerFactory.getLogger(InMemCubeBuilder.class);
    private static final double DERIVE_AGGR_CACHE_CONSTANT_FACTOR = 0.1;
    private static final double DERIVE_AGGR_CACHE_VARIABLE_FACTOR = 0.9;
    private final long baseCuboidId;
    private final int totalCuboidCount;
    private final String[] metricsAggrFuncs;
    private final MeasureDesc[] measureDescs;
    private final int measureCount;
    private MemoryBudgetController memBudget;
    private MemoryBudgetController.MemoryWaterLevel baseCuboidMemTracker;
    private Thread[] taskThreads;
    private Throwable[] taskThreadExceptions;
    private TreeSet<CuboidTask> taskPending;
    private AtomicInteger taskCuboidCompleted = new AtomicInteger(0);
    private CuboidResult baseResult;
    private Object[] totalSumForSanityCheck;
    private ICuboidCollector resultCollector;

    public InMemCubeBuilder(CuboidScheduler cuboidScheduler, IJoinedFlatTableDesc flatDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        super(cuboidScheduler, flatDesc, dictionaryMap);
        this.baseCuboidId = Cuboid.getBaseCuboidId(this.cubeDesc);
        this.totalCuboidCount = cuboidScheduler.getCuboidCount();
        this.measureCount = this.cubeDesc.getMeasures().size();
        this.measureDescs = this.cubeDesc.getMeasures().toArray(new MeasureDesc[this.measureCount]);
        ArrayList<String> metricsAggrFuncsList = Lists.newArrayList();
        for (int i = 0; i < this.measureCount; ++i) {
            MeasureDesc measureDesc = this.measureDescs[i];
            metricsAggrFuncsList.add(measureDesc.getFunction().getExpression());
        }
        this.metricsAggrFuncs = metricsAggrFuncsList.toArray(new String[metricsAggrFuncsList.size()]);
    }

    private GridTable newGridTableByCuboidID(long cuboidID) throws IOException {
        GTInfo info = CubeGridTable.newGTInfo(Cuboid.findForMandatory(this.cubeDesc, cuboidID), new CubeDimEncMap(this.cubeDesc, this.dictionaryMap));
        ConcurrentDiskStore store = new ConcurrentDiskStore(info);
        GridTable gridTable = new GridTable(info, store);
        return gridTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void build(BlockingQueue<T> input, InputConverterUnit<T> inputConverterUnit, ICuboidWriter output) throws IOException {
        NavigableMap<Long, CuboidResult> result = this.build(RecordConsumeBlockingQueueController.getQueueController(inputConverterUnit, input));
        try {
            for (CuboidResult cuboidResult : result.values()) {
                this.outputCuboid(cuboidResult.cuboidId, cuboidResult.table, output);
                cuboidResult.table.close();
            }
        }
        finally {
            output.close();
        }
    }

    public <T> NavigableMap<Long, CuboidResult> build(RecordConsumeBlockingQueueController<T> input) throws IOException {
        final ConcurrentSkipListMap<Long, CuboidResult> result = new ConcurrentSkipListMap<Long, CuboidResult>();
        this.build(input, new ICuboidCollector(){

            @Override
            public void collect(CuboidResult cuboidResult) {
                logger.info("collecting CuboidResult cuboid id:" + cuboidResult.cuboidId);
                result.put(cuboidResult.cuboidId, cuboidResult);
            }
        });
        logger.info("total CuboidResult count:" + result.size());
        return result;
    }

    private <T> void build(RecordConsumeBlockingQueueController<T> input, ICuboidCollector collector) throws IOException {
        long startTime = System.currentTimeMillis();
        logger.info("In Mem Cube Build start, {}", (Object)this.cubeDesc.getName());
        this.baseCuboidMemTracker = new MemoryBudgetController.MemoryWaterLevel();
        this.baseCuboidMemTracker.markLow();
        this.taskPending = new TreeSet();
        this.taskCuboidCompleted.set(0);
        this.taskThreads = this.prepareTaskThreads();
        this.taskThreadExceptions = new Throwable[this.taskThreadCount];
        this.resultCollector = collector;
        this.totalSumForSanityCheck = null;
        this.baseResult = this.createBaseCuboid(input);
        if (this.baseResult.nRows == 0) {
            return;
        }
        this.baseCuboidMemTracker.markLow();
        this.makeMemoryBudget();
        this.addChildTasks(this.baseResult);
        this.start(this.taskThreads);
        this.join(this.taskThreads);
        long endTime = System.currentTimeMillis();
        logger.info("In Mem Cube Build end, {}, takes {} ms", (Object)this.cubeDesc.getName(), (Object)(endTime - startTime));
        this.throwExceptionIfAny();
    }

    public void abort() {
        this.interrupt(this.taskThreads);
    }

    private void start(Thread ... threads) {
        for (Thread t : threads) {
            t.start();
        }
    }

    private void interrupt(Thread ... threads) {
        for (Thread t : threads) {
            t.interrupt();
        }
    }

    private void join(Thread ... threads) throws IOException {
        try {
            for (Thread t : threads) {
                t.join();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("interrupted while waiting task and output complete", e);
        }
    }

    private void throwExceptionIfAny() throws IOException {
        ArrayList<Throwable> errors = Lists.newArrayList();
        for (int i = 0; i < this.taskThreadCount; ++i) {
            Throwable t = this.taskThreadExceptions[i];
            if (t == null) continue;
            errors.add(t);
        }
        InMemCubeBuilder.processErrors(errors);
    }

    static void processErrors(List<Throwable> errors) throws IOException {
        if (errors.isEmpty()) {
            return;
        }
        if (errors.size() == 1) {
            Throwable t = errors.get(0);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
        for (Throwable t : errors) {
            logger.error("Exception during in-mem cube build", t);
        }
        throw new IOException(errors.size() + " exceptions during in-mem cube build, cause set to the first, check log for more", errors.get(0));
    }

    private Thread[] prepareTaskThreads() {
        Thread[] result = new Thread[this.taskThreadCount];
        for (int i = 0; i < this.taskThreadCount; ++i) {
            result[i] = new CuboidTaskThread(i);
        }
        return result;
    }

    public boolean isAllCuboidDone() {
        return this.taskCuboidCompleted.get() == this.totalCuboidCount;
    }

    private boolean taskHasNoException() {
        for (int i = 0; i < this.taskThreadExceptions.length; ++i) {
            if (this.taskThreadExceptions[i] == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildTasks(CuboidResult parent) {
        List<Long> children = this.cuboidScheduler.getSpanningCuboid(parent.cuboidId);
        if (!children.isEmpty()) {
            TreeSet<CuboidTask> treeSet = this.taskPending;
            synchronized (treeSet) {
                for (Long child : children) {
                    this.taskPending.add(new CuboidTask(parent, child));
                }
                this.taskPending.notifyAll();
            }
        }
    }

    private void makeMemoryBudget() {
        this.baseResult.aggrCacheMB = Math.max(this.baseCuboidMemTracker.getEstimateMB(), 10);
        logger.debug("Base cuboid aggr cache is {} MB", (Object)this.baseResult.aggrCacheMB);
        int systemAvailMB = MemoryBudgetController.gcAndGetSystemAvailMB();
        logger.debug("System avail {} MB", (Object)systemAvailMB);
        int reserve = this.reserveMemoryMB;
        logger.debug("Reserve {} MB for system basics", (Object)reserve);
        int budget = systemAvailMB - reserve;
        if (budget < this.baseResult.aggrCacheMB) {
            budget = this.baseResult.aggrCacheMB;
            logger.warn("System avail memory ({} MB) is less than base aggr cache ({} MB) + minimal reservation ({} MB), consider increase JVM heap -Xmx", systemAvailMB, this.baseResult.aggrCacheMB, reserve);
        }
        logger.debug("Memory Budget is {} MB", (Object)budget);
        this.memBudget = new MemoryBudgetController(budget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CuboidResult createBaseCuboid(RecordConsumeBlockingQueueController<T> input) throws IOException {
        long startTime = System.currentTimeMillis();
        logger.info("Calculating base cuboid {}", (Object)this.baseCuboidId);
        GridTable baseCuboid = this.newGridTableByCuboidID(this.baseCuboidId);
        GTBuilder baseBuilder = baseCuboid.rebuild();
        InputConverter<T> baseInput = new InputConverter<T>(baseCuboid.getInfo(), input);
        Pair<ImmutableBitSet, ImmutableBitSet> dimensionMetricsBitSet = InMemCubeBuilderUtils.getDimensionAndMetricColumnBitSet(this.baseCuboidId, this.measureCount);
        GTScanRequest req = new GTScanRequestBuilder().setInfo(baseCuboid.getInfo()).setRanges(null).setDimensions(null).setAggrGroupBy(dimensionMetricsBitSet.getFirst()).setAggrMetrics(dimensionMetricsBitSet.getSecond()).setAggrMetricsFuncs(this.metricsAggrFuncs).setFilterPushDown(null).createGTScanRequest();
        GTAggregateScanner aggregationScanner = new GTAggregateScanner(baseInput, req);
        aggregationScanner.trackMemoryLevel(this.baseCuboidMemTracker);
        int count = 0;
        try {
            for (GTRecord r : aggregationScanner) {
                if (count == 0) {
                    this.baseCuboidMemTracker.markHigh();
                }
                baseBuilder.write(r);
                ++count;
            }
        }
        finally {
            aggregationScanner.close();
            baseBuilder.close();
        }
        long timeSpent = System.currentTimeMillis() - startTime;
        logger.info("Cuboid {} has {} rows, build takes {}ms", this.baseCuboidId, count, timeSpent);
        int mbEstimateBaseAggrCache = (int)(aggregationScanner.getEstimateSizeOfAggrCache() / 0x100000L);
        logger.info("Wild estimate of base aggr cache is {} MB", (Object)mbEstimateBaseAggrCache);
        return this.updateCuboidResult(this.baseCuboidId, baseCuboid, count, timeSpent, 0, input.inputConverterUnit.ifChange());
    }

    private CuboidResult updateCuboidResult(long cuboidId, GridTable table, int nRows, long timeSpent, int aggrCacheMB) {
        return this.updateCuboidResult(cuboidId, table, nRows, timeSpent, aggrCacheMB, true);
    }

    private CuboidResult updateCuboidResult(long cuboidId, GridTable table, int nRows, long timeSpent, int aggrCacheMB, boolean ifCollect) {
        if (aggrCacheMB <= 0 && this.baseResult != null) {
            aggrCacheMB = (int)Math.round((0.1 + 0.9 * (double)nRows / (double)this.baseResult.nRows) * (double)this.baseResult.aggrCacheMB);
        }
        CuboidResult result = new CuboidResult(cuboidId, table, nRows, timeSpent, aggrCacheMB);
        this.taskCuboidCompleted.incrementAndGet();
        if (ifCollect) {
            this.resultCollector.collect(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CuboidResult buildCuboid(CuboidResult parent, long cuboidId) throws IOException {
        final String consumerName = "AggrCache@Cuboid " + cuboidId;
        MemoryBudgetController.MemoryConsumer consumer = new MemoryBudgetController.MemoryConsumer(){

            @Override
            public int freeUp(int mb) {
                return 0;
            }

            public String toString() {
                return consumerName;
            }
        };
        this.memBudget.reserveInsist(consumer, parent.aggrCacheMB);
        try {
            CuboidResult cuboidResult = this.aggregateCuboid(parent, cuboidId);
            return cuboidResult;
        }
        finally {
            this.memBudget.reserve(consumer, 0);
        }
    }

    private CuboidResult aggregateCuboid(CuboidResult parent, long cuboidId) throws IOException {
        Pair<ImmutableBitSet, ImmutableBitSet> allNeededColumns = InMemCubeBuilderUtils.getDimensionAndMetricColumnBitSet(parent.cuboidId, cuboidId, this.measureCount);
        return this.scanAndAggregateGridTable(parent.table, parent.cuboidId, cuboidId, allNeededColumns.getFirst(), allNeededColumns.getSecond());
    }

    private GTAggregateScanner prepareGTAggregationScanner(GridTable gridTable, long parentId, long cuboidId, ImmutableBitSet aggregationColumns, ImmutableBitSet measureColumns2) throws IOException {
        GTInfo info = gridTable.getInfo();
        GTScanRequest req = new GTScanRequestBuilder().setInfo(info).setRanges(null).setDimensions(null).setAggrGroupBy(aggregationColumns).setAggrMetrics(measureColumns2).setAggrMetricsFuncs(this.metricsAggrFuncs).setFilterPushDown(null).createGTScanRequest();
        GTAggregateScanner scanner = (GTAggregateScanner)gridTable.scan(req);
        if (parentId != cuboidId) {
            boolean[] aggrMask = new boolean[this.measureDescs.length];
            for (int i = 0; i < this.measureDescs.length; ++i) {
                boolean bl = aggrMask[i] = !this.measureDescs[i].getFunction().getMeasureType().onlyAggrInBaseCuboid();
                if (aggrMask[i]) continue;
                logger.info("{} doesn't need aggregation.", (Object)this.measureDescs[i]);
            }
            scanner.setAggrMask(aggrMask);
        }
        return scanner;
    }

    private CuboidResult scanAndAggregateGridTable(GridTable gridTable, long parentId, long cuboidId, ImmutableBitSet aggregationColumns, ImmutableBitSet measureColumns2) throws IOException {
        long startTime = System.currentTimeMillis();
        logger.info("Calculating cuboid {}", (Object)cuboidId);
        GridTable newGridTable = this.newGridTableByCuboidID(cuboidId);
        ImmutableBitSet allNeededColumns = aggregationColumns.or(measureColumns2);
        GTRecord newRecord = new GTRecord(newGridTable.getInfo());
        int count = 0;
        try (GTAggregateScanner scanner = this.prepareGTAggregationScanner(gridTable, parentId, cuboidId, aggregationColumns, measureColumns2);
             GTBuilder builder = newGridTable.rebuild();){
            for (GTRecord record : scanner) {
                ++count;
                for (int i = 0; i < allNeededColumns.trueBitCount(); ++i) {
                    int c = allNeededColumns.trueBitAt(i);
                    newRecord.set(i, record.get(c));
                }
                builder.write(newRecord);
            }
        }
        long timeSpent = System.currentTimeMillis() - startTime;
        logger.info("Cuboid {} has {} rows, build takes {}ms", cuboidId, count, timeSpent);
        return this.updateCuboidResult(cuboidId, newGridTable, count, timeSpent, 0);
    }

    private void sanityCheck(long parentId, long cuboidId, Object[] totalSum) {
        for (int i = 0; i < totalSum.length; ++i) {
            if (totalSum[i] instanceof DoubleMutable) {
                totalSum[i] = Math.round(((DoubleMutable)totalSum[i]).get());
                continue;
            }
            if (totalSum[i] instanceof Double) {
                totalSum[i] = Math.round((Double)totalSum[i]);
                continue;
            }
            if (!(totalSum[i] instanceof TopNCounter)) continue;
            TopNCounter counter = (TopNCounter)totalSum[i];
            Iterator iterator = counter.iterator();
            double total = 0.0;
            while (iterator.hasNext()) {
                Counter aCounter = iterator.next();
                total += aCounter.getCount().doubleValue();
            }
            totalSum[i] = Math.round(total);
        }
        if (this.totalSumForSanityCheck == null) {
            this.totalSumForSanityCheck = totalSum;
            return;
        }
        if (!Arrays.equals(this.totalSumForSanityCheck, totalSum)) {
            if (logger.isInfoEnabled()) {
                logger.info("sanityCheck failed when calculate{} from parent {}", (Object)cuboidId, (Object)parentId);
                logger.info("Expected: {}", (Object)Arrays.toString(this.totalSumForSanityCheck));
                logger.info("Actually: {}", (Object)Arrays.toString(totalSum));
            }
            throw new IllegalStateException();
        }
    }

    private static class CuboidTask
    implements Comparable<CuboidTask> {
        final CuboidResult parent;
        final long childCuboidId;

        CuboidTask(CuboidResult parent, long childCuboidId) {
            this.parent = parent;
            this.childCuboidId = childCuboidId;
        }

        @Override
        public int compareTo(CuboidTask o) {
            long comp = this.childCuboidId - o.childCuboidId;
            return comp < 0L ? -1 : (comp > 0L ? 1 : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CuboidTask that = (CuboidTask)o;
            return this.compareTo(that) == 0;
        }

        public int hashCode() {
            return Long.hashCode(this.childCuboidId);
        }
    }

    private class CuboidTaskThread
    extends Thread {
        private int id;

        CuboidTaskThread(int id) {
            super("CuboidTask-" + id);
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                try {
                    while (!InMemCubeBuilder.this.isAllCuboidDone()) {
                        CuboidTask task = null;
                        TreeSet treeSet = InMemCubeBuilder.this.taskPending;
                        synchronized (treeSet) {
                            while (task == null && InMemCubeBuilder.this.taskHasNoException()) {
                                task = (CuboidTask)InMemCubeBuilder.this.taskPending.pollFirst();
                                if (task != null) continue;
                                InMemCubeBuilder.this.taskPending.wait(60000L);
                            }
                        }
                        if (task != null) {
                            CuboidResult newCuboid = InMemCubeBuilder.this.buildCuboid(task.parent, task.childCuboidId);
                            InMemCubeBuilder.this.addChildTasks(newCuboid);
                            if (!InMemCubeBuilder.this.isAllCuboidDone()) continue;
                            for (Thread t : InMemCubeBuilder.this.taskThreads) {
                                if (t == Thread.currentThread()) continue;
                                t.interrupt();
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable ex) {
                    if (InMemCubeBuilder.this.isAllCuboidDone()) break block9;
                    logger.error("task thread exception", ex);
                    ((InMemCubeBuilder)InMemCubeBuilder.this).taskThreadExceptions[this.id] = ex;
                }
            }
        }
    }

    static interface ICuboidCollector {
        public void collect(CuboidResult var1);
    }
}

