/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.cube.cuboid.algorithm.BenefitPolicy;
import org.apache.kylin.cube.cuboid.algorithm.CuboidBenefitModel;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableMap;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPUSCalculator
implements BenefitPolicy {
    private static Logger logger = LoggerFactory.getLogger(BPUSCalculator.class);
    protected final CuboidStats cuboidStats;
    protected final ImmutableMap<Long, Long> initCuboidAggCostMap;
    protected final Map<Long, Long> processCuboidAggCostMap;

    public BPUSCalculator(CuboidStats cuboidStats) {
        this.cuboidStats = cuboidStats;
        this.initCuboidAggCostMap = ImmutableMap.copyOf(this.initCuboidAggCostMap());
        this.processCuboidAggCostMap = Maps.newHashMap(this.initCuboidAggCostMap);
    }

    protected BPUSCalculator(CuboidStats cuboidStats, ImmutableMap<Long, Long> initCuboidAggCostMap) {
        this.cuboidStats = cuboidStats;
        this.initCuboidAggCostMap = initCuboidAggCostMap;
        this.processCuboidAggCostMap = Maps.newHashMap(initCuboidAggCostMap);
    }

    private Map<Long, Long> initCuboidAggCostMap() {
        HashMap<Long, Long> cuboidAggCostMap = Maps.newHashMap();
        for (Long cuboid : this.cuboidStats.getAllCuboidsForMandatory()) {
            if (this.getCuboidCost(cuboid) == null) continue;
            cuboidAggCostMap.put(cuboid, this.getCuboidCost(cuboid));
        }
        long baseCuboidCost = this.getCuboidCost(this.cuboidStats.getBaseCuboid());
        for (Long cuboid : this.cuboidStats.getAllCuboidsForSelection()) {
            long leastCost = baseCuboidCost;
            for (Map.Entry cuboidTargetEntry : cuboidAggCostMap.entrySet()) {
                if ((cuboid | (Long)cuboidTargetEntry.getKey()) != (Long)cuboidTargetEntry.getKey() || leastCost <= (Long)cuboidTargetEntry.getValue()) continue;
                leastCost = (Long)cuboidTargetEntry.getValue();
            }
            cuboidAggCostMap.put(cuboid, leastCost);
        }
        return cuboidAggCostMap;
    }

    @Override
    public CuboidBenefitModel.BenefitModel calculateBenefit(long cuboid, Set<Long> selected) {
        double totalCostSaving = 0.0;
        int benefitCount = 0;
        for (Long descendant : this.cuboidStats.getAllDescendants(cuboid)) {
            double costSaving;
            if (selected.contains(descendant) || !((costSaving = this.getCostSaving(descendant, cuboid)) > 0.0)) continue;
            totalCostSaving += costSaving;
            ++benefitCount;
        }
        double spaceCost = this.calculateSpaceCost(cuboid);
        double benefitPerUnitSpace = totalCostSaving / spaceCost;
        return new CuboidBenefitModel.BenefitModel(benefitPerUnitSpace, benefitCount);
    }

    @Override
    public CuboidBenefitModel.BenefitModel calculateBenefitTotal(Set<Long> cuboidsToAdd, Set<Long> selected) {
        HashSet<Long> selectedInner = Sets.newHashSet(selected);
        HashMap<Long, Long> cuboidAggCostMapCopy = Maps.newHashMap(this.processCuboidAggCostMap);
        for (Long cuboid : cuboidsToAdd) {
            selectedInner.add(cuboid);
            this.propagateAggregationCost(cuboid, selectedInner, cuboidAggCostMapCopy);
        }
        double totalCostSaving = 0.0;
        int benefitCount = 0;
        for (Map.Entry entry : cuboidAggCostMapCopy.entrySet()) {
            if ((Long)entry.getValue() >= this.processCuboidAggCostMap.get(entry.getKey())) continue;
            totalCostSaving += (double)(this.processCuboidAggCostMap.get(entry.getKey()) - (Long)entry.getValue());
            ++benefitCount;
        }
        double benefitPerUnitSpace = totalCostSaving;
        return new CuboidBenefitModel.BenefitModel(benefitPerUnitSpace, benefitCount);
    }

    protected double getCostSaving(long descendant, long cuboid) {
        long cuboidCost = this.getCuboidCost(cuboid);
        long descendantAggCost = this.getCuboidAggregationCost(descendant);
        return (double)descendantAggCost - (double)cuboidCost;
    }

    protected Long getCuboidCost(long cuboid) {
        return this.cuboidStats.getCuboidCount(cuboid);
    }

    private long getCuboidAggregationCost(long cuboid) {
        return this.processCuboidAggCostMap.get(cuboid);
    }

    @Override
    public boolean ifEfficient(CuboidBenefitModel best) {
        if (best.getBenefit() < this.getMinBenefitRatio()) {
            logger.info(String.format(Locale.ROOT, "The recommended cuboid %s doesn't meet minimum benifit ratio %f", best, this.getMinBenefitRatio()));
            return false;
        }
        return true;
    }

    public double getMinBenefitRatio() {
        return this.cuboidStats.getBpusMinBenefitRatio();
    }

    @Override
    public void propagateAggregationCost(long cuboid, Set<Long> selected) {
        this.propagateAggregationCost(cuboid, selected, this.processCuboidAggCostMap);
    }

    public void propagateAggregationCost(long cuboid, Set<Long> selected, Map<Long, Long> processCuboidAggCostMap) {
        long aggregationCost = this.getCuboidCost(cuboid);
        Set<Long> childrenCuboids = this.cuboidStats.getAllDescendants(cuboid);
        for (Long child : childrenCuboids) {
            if (selected.contains(child) || aggregationCost >= this.getCuboidAggregationCost(child)) continue;
            processCuboidAggCostMap.put(child, aggregationCost);
        }
    }

    public double calculateSpaceCost(long cuboid) {
        return this.cuboidStats.getCuboidCount(cuboid).longValue();
    }

    @Override
    public BenefitPolicy getInstance() {
        return new BPUSCalculator(this.cuboidStats, this.initCuboidAggCostMap);
    }
}

