/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;

public class ContentReader<T extends RootPersistentEntity> {
    private final Serializer<T> serializer;

    public ContentReader(Serializer<T> serializer) {
        this.serializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T readContent(RawResource res) throws IOException {
        if (res == null) {
            return null;
        }
        DataInputStream din = new DataInputStream(res.content());
        try {
            T r = this.serializer.deserialize(din);
            if (r != null) {
                ((RootPersistentEntity)r).setLastModified(res.lastModified());
            }
            T t = r;
            return t;
        }
        finally {
            IOUtils.closeQuietly(din);
            IOUtils.closeQuietly(res.content());
        }
    }
}

