/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cluster.parser;

import java.util.List;
import org.apache.kylin.cluster.AvailableResource;
import org.apache.kylin.cluster.ResourceInfo;
import org.apache.kylin.cluster.parser.SchedulerParser;
import org.apache.kylin.cluster.parser.SchedulerParser$class;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001\u001b\t92)\u00199bG&$\u0018pU2iK\u0012,H.\u001a:QCJ\u001cXM\u001d\u0006\u0003\u0007\u0011\ta\u0001]1sg\u0016\u0014(BA\u0003\u0007\u0003\u001d\u0019G.^:uKJT!a\u0002\u0005\u0002\u000b-LH.\u001b8\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!aD*dQ\u0016$W\u000f\\3s!\u0006\u00148/\u001a:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002CA\u000b\u0001\u0011\u0015i\u0002\u0001\"\u0011\u001f\u0003E\tg/Y5mC\ndWMU3t_V\u00148-\u001a\u000b\u0003?\r\u0002\"\u0001I\u0011\u000e\u0003\u0011I!A\t\u0003\u0003#\u00053\u0018-\u001b7bE2,'+Z:pkJ\u001cW\rC\u0003%9\u0001\u0007Q%A\u0005rk\u0016,XMT1nKB\u0011a%\u000b\b\u0003\u001f\u001dJ!\u0001\u000b\t\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003QAAQ!\f\u0001\u0005\n9\n\u0001d\u00197vgR,'/\u0011<bS2\f'\r\\3DCB\f7-\u001b;z)\ty#\u0007\u0005\u0002\u0010a%\u0011\u0011\u0007\u0005\u0002\u0007\t>,(\r\\3\t\u000bMb\u0003\u0019\u0001\u001b\u0002\t9|G-\u001a\t\u0003kyj\u0011A\u000e\u0006\u0003oa\n\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003si\nqA[1dWN|gN\u0003\u0002<y\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0002{\u0005\u00191m\\7\n\u0005}2$\u0001\u0003&t_:tu\u000eZ3\t\u000b\u0005\u0003A\u0011\u0002\"\u0002\u001bE,X-^3DCB\f7-\u001b;z)\t\u0019e\t\u0005\u0003\u0010\t>z\u0013BA#\u0011\u0005\u0019!V\u000f\u001d7fe!)1\u0007\u0011a\u0001i!)\u0001\n\u0001C\u0005\u0013\u0006\u00012-\u00197U_R\fGNU3t_V\u00148-\u001a\u000b\u0003\u00156\u0003\"\u0001I&\n\u00051#!\u0001\u0004*fg>,(oY3J]\u001a|\u0007\"B\u001aH\u0001\u0004!\u0004")
public class CapacitySchedulerParser
implements SchedulerParser {
    private JsonNode root;
    private final ObjectMapper mapper;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public JsonNode root() {
        return this.root;
    }

    @Override
    public void root_$eq(JsonNode x$1) {
        this.root = x$1;
    }

    private ObjectMapper mapper$lzycompute() {
        CapacitySchedulerParser capacitySchedulerParser = this;
        synchronized (capacitySchedulerParser) {
            if (!this.bitmap$0) {
                this.mapper = SchedulerParser$class.mapper(this);
                this.bitmap$0 = true;
            }
            return this.mapper;
        }
    }

    @Override
    public ObjectMapper mapper() {
        return this.bitmap$0 ? this.mapper : this.mapper$lzycompute();
    }

    @Override
    public void parse(String schedulerInfo2) {
        SchedulerParser$class.parse(this, schedulerInfo2);
    }

    @Override
    public String parseValue(JsonNode node) {
        return SchedulerParser$class.parseValue(this, node);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    @Override
    public AvailableResource availableResource(String queueName) {
        List<JsonNode> queues = this.root().findParents("queueName");
        Buffer nodes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(queues).asScala()).filter((Function1)new Serializable(this, queueName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CapacitySchedulerParser $outer;
            private final String queueName$1;

            public final boolean apply(JsonNode queue) {
                return this.$outer.parseValue(queue.get("queueName")).equals(this.queueName$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queueName$1 = queueName$1;
            }
        });
        Predef$.MODULE$.require(nodes.size() == 1);
        Tuple2<Object, Object> tuple2 = this.queueCapacity((JsonNode)nodes.head());
        if (tuple2 != null) {
            Tuple2.mcDD.sp sp2;
            double queueAvailable = tuple2._1$mcD$sp();
            double queueMax = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(queueAvailable, queueMax);
            double queueAvailable2 = sp3._1$mcD$sp();
            double queueMax2 = sp3._2$mcD$sp();
            ResourceInfo totalResource = this.calTotalResource((JsonNode)nodes.head());
            JsonNode clusterNode = this.root().findValue("schedulerInfo");
            double cluster = this.clusterAvailableCapacity(clusterNode);
            double min = Math.min(queueAvailable2, cluster);
            AvailableResource resource = new AvailableResource(totalResource.percentage(min), totalResource.percentage(queueMax2));
            this.logInfo((Function0<String>)new Serializable(this, resource){
                public static final long serialVersionUID = 0L;
                private final AvailableResource resource$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Capacity actual available resource: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.resource$1}));
                }
                {
                    this.resource$1 = resource$1;
                }
            });
            return resource;
        }
        throw new MatchError(tuple2);
    }

    private double clusterAvailableCapacity(JsonNode node) {
        double max = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("capacity")))).toDouble();
        double used = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("usedCapacity")))).toDouble();
        double capacity = (max - used) / (double)100;
        this.logInfo((Function0<String>)new Serializable(this, capacity){
            public static final long serialVersionUID = 0L;
            private final double capacity$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cluster available capacity: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.capacity$1)}));
            }
            {
                this.capacity$1 = capacity$1;
            }
        });
        return capacity;
    }

    private Tuple2<Object, Object> queueCapacity(JsonNode node) {
        double max = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("absoluteMaxCapacity")))).toDouble();
        double used = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("absoluteUsedCapacity")))).toDouble();
        double available = (max - used) / (double)100;
        this.logInfo((Function0<String>)new Serializable(this, available){
            public static final long serialVersionUID = 0L;
            private final double available$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Queue available capacity: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.available$1)}));
            }
            {
                this.available$1 = available$1;
            }
        });
        return new Tuple2.mcDD.sp(available, max / (double)100);
    }

    private ResourceInfo calTotalResource(JsonNode node) {
        ResourceInfo resourceInfo;
        int usedMemory = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("resourcesUsed").get("memory")))).toInt();
        if (usedMemory != 0) {
            double usedCapacity = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("absoluteUsedCapacity")))).toDouble() / (double)100;
            ResourceInfo resource = new ResourceInfo((int)Math.floor((double)usedMemory / usedCapacity), Integer.MAX_VALUE);
            this.logInfo((Function0<String>)new Serializable(this, resource){
                public static final long serialVersionUID = 0L;
                private final ResourceInfo resource$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Estimate total cluster resource is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.resource$2}));
                }
                {
                    this.resource$2 = resource$2;
                }
            });
            resourceInfo = resource;
        } else {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Current queue used memory is 0, seem available resource as infinite.";
                }
            });
            resourceInfo = new ResourceInfo(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return resourceInfo;
    }

    public CapacitySchedulerParser() {
        Logging.class.$init$((Logging)this);
        SchedulerParser$class.$init$(this);
    }
}

