/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cluster;

import io.netty.util.internal.ThrowableUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.utils.BuildUtils$;
import org.apache.kylin.job.exception.ShellException;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class SchedulerInfoCmdHelper$
implements Logging {
    public static final SchedulerInfoCmdHelper$ MODULE$;
    private final boolean useHttps;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SchedulerInfoCmdHelper$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private boolean useHttps() {
        return this.useHttps;
    }

    public String schedulerInfo() {
        Iterable cmds = (Iterable)this.getSocketAddress().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> address) {
                return SchedulerInfoCmdHelper$.MODULE$.genCmd((String)address._1(), address._2$mcI$sp());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Iterable results = (Iterable)cmds.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, String> apply(String cmd) {
                Tuple2 tuple2;
                try {
                    tuple2 = SchedulerInfoCmdHelper$.MODULE$.execute(cmd);
                }
                catch (Throwable throwable) {
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)ThrowableUtil.stackTraceToString((Throwable)throwable));
                }
                return tuple2;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Iterable tuples = (Iterable)results.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, String> result) {
                return result._1$mcI$sp() == 0 && JsonUtil.isJson((String)result._2());
            }
        });
        if (tuples.isEmpty()) {
            String errors = ((TraversableOnce)tuples.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<Object, String> x$1) {
                    return (String)x$1._2();
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
            this.logWarning((Function0<String>)new Serializable(cmds){
                public static final long serialVersionUID = 0L;
                private final Iterable cmds$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error occurred when get scheduler info from cmd ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cmds$1}));
                }
                {
                    this.cmds$1 = cmds$1;
                }
            });
            throw new RuntimeException(errors);
        }
        Predef$.MODULE$.require(tuples.size() == 1);
        return (String)((Tuple2)tuples.head())._2();
    }

    public Map<String, Object> getSocketAddress() {
        InetSocketAddress[] inetSocketAddressArray;
        YarnConfiguration conf = BuildUtils$.MODULE$.getCurrentYarnConfiguration();
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            Object[] haIds = HAUtil.getRMHAIds((Configuration)conf).toArray();
            Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps(haIds).nonEmpty(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Ha ids is empty, please check your yarn-site.xml.";
                }
            });
            inetSocketAddressArray = this.useHttps() ? (InetSocketAddress[])Predef$.MODULE$.refArrayOps(haIds).map((Function1)new Serializable(conf){
                public static final long serialVersionUID = 0L;
                private final YarnConfiguration conf$1;

                public final InetSocketAddress apply(Object id) {
                    return this.conf$1.getSocketAddr(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"yarn.resourcemanager.webapp.https.address", id})), "0.0.0.0:8090", 8044);
                }
                {
                    this.conf$1 = conf$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InetSocketAddress.class))) : (InetSocketAddress[])Predef$.MODULE$.refArrayOps(haIds).map((Function1)new Serializable(conf){
                public static final long serialVersionUID = 0L;
                private final YarnConfiguration conf$1;

                public final InetSocketAddress apply(Object id) {
                    return this.conf$1.getSocketAddr(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"yarn.resourcemanager.webapp.address", id})), "0.0.0.0:8088", 8042);
                }
                {
                    this.conf$1 = conf$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InetSocketAddress.class)));
        } else {
            inetSocketAddressArray = this.useHttps() ? (InetSocketAddress[])((Object[])new InetSocketAddress[]{conf.getSocketAddr("yarn.resourcemanager.webapp.https.address", "0.0.0.0:8090", 8044)}) : (InetSocketAddress[])((Object[])new InetSocketAddress[]{conf.getSocketAddr("yarn.resourcemanager.webapp.address", "0.0.0.0:8088", 8042)});
        }
        InetSocketAddress[] addresses = inetSocketAddressArray;
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])addresses).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(InetSocketAddress address) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)address.getHostName()), (Object)BoxesRunTime.boxToInteger((int)address.getPort()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
    }

    public String genCmd(String hostName, int port) {
        String uri = this.useHttps() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https://", ":", "/ws/v1/cluster/scheduler"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostName, BoxesRunTime.boxToInteger((int)port)})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://", ":", "/ws/v1/cluster/scheduler"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostName, BoxesRunTime.boxToInteger((int)port)}));
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"curl -k --negotiate -u : \"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri}));
    }

    /*
     * Loose catch block
     */
    public Tuple2<Object, String> execute(String command) {
        try {
            String[] cmd = new String[3];
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
            } else {
                cmd[0] = "/bin/bash";
                cmd[1] = "-c";
            }
            cmd[2] = command;
            ProcessBuilder builder = new ProcessBuilder(cmd);
            builder.environment().putAll(System.getenv());
            Process proc = builder.start();
            StringBuilder result = new StringBuilder();
            BufferedReader inReader = new BufferedReader(new InputStreamReader(proc.getInputStream(), Charset.defaultCharset()));
            ObjectRef line = ObjectRef.create((Object)inReader.readLine());
            while (true) {
                if ((String)line.elem == null) {
                    BufferedReader errorReader = new BufferedReader(new InputStreamReader(proc.getErrorStream(), Charset.defaultCharset()));
                    line.elem = errorReader.readLine();
                    while (true) {
                        if ((String)line.elem == null) {
                            this.logInfo((Function0<String>)new Serializable(command){
                                public static final long serialVersionUID = 0L;
                                private final String command$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Thread wait for executing command ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.command$1}));
                                }
                                {
                                    this.command$1 = command$1;
                                }
                            });
                            int exitCode = proc.waitFor();
                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)result.toString());
                        }
                        this.logInfo((Function0<String>)new Serializable(line){
                            public static final long serialVersionUID = 0L;
                            private final ObjectRef line$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stderr\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.line$1.elem}));
                            }
                            {
                                this.line$1 = line$1;
                            }
                        });
                        line.elem = errorReader.readLine();
                    }
                }
                result.append((String)line.elem).append('\n');
                this.logInfo((Function0<String>)new Serializable(line){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef line$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stdout\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.line$1.elem}));
                    }
                    {
                        this.line$1 = line$1;
                    }
                });
                line.elem = inReader.readLine();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw interruptedException;
            }
        }
        catch (Exception exception) {
            throw new ShellException(exception);
        }
    }

    private SchedulerInfoCmdHelper$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.useHttps = YarnConfiguration.useHttps((Configuration)BuildUtils$.MODULE$.getCurrentYarnConfiguration());
    }
}

