/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.spark.classloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import org.apache.catalina.loader.ParallelWebappClassLoader;
import org.apache.kylin.spark.classloader.ClassLoaderUtils;
import org.apache.kylin.spark.classloader.SparkClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatClassLoader
extends ParallelWebappClassLoader {
    private static final String[] PARENT_CL_PRECEDENT_CLASSES = new String[]{"com.sun.", "launcher.", "javax.", "org.ietf", "java", "org.omg", "org.w3c", "org.xml", "sunw.", "org.slf4j", "org.apache.commons.logging", "org.apache.log4j", "org.apache.catalina", "org.apache.tomcat"};
    private static final String[] THIS_CL_PRECEDENT_CLASSES = new String[]{"org.apache.kylin", "org.apache.calcite"};
    private static final String[] CODE_GEN_CLASS = new String[]{"org.apache.spark.sql.catalyst.expressions.Object", "Baz"};
    private static final Set<String> wontFindClasses = new HashSet<String>();
    private static Logger logger;
    private SparkClassLoader sparkClassLoader = new SparkClassLoader((ClassLoader)((Object)this));

    public TomcatClassLoader(ClassLoader parent) throws IOException {
        super(parent);
        ClassLoaderUtils.setSparkClassLoader(this.sparkClassLoader);
        ClassLoaderUtils.setOriginClassLoader((URLClassLoader)((Object)this));
        this.init();
    }

    public void init() {
        String[] jars;
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            throw new RuntimeException("");
        }
        for (String jar : jars = classPath.split(":")) {
            try {
                URL url = new File(jar).toURI().toURL();
                this.addURL(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.isWontFind(name)) {
            throw new ClassNotFoundException();
        }
        if (this.isCodeGen(name)) {
            throw new ClassNotFoundException();
        }
        if (name.startsWith("org.apache.kylin.spark.classloader")) {
            return this.parent.loadClass(name);
        }
        if (this.sparkClassLoader.classNeedPreempt(name)) {
            return this.sparkClassLoader.loadClass(name);
        }
        if (this.isParentCLPrecedent(name)) {
            logger.debug("Skipping exempt class " + name + " - delegating directly to parent");
            return this.parent.loadClass(name);
        }
        return super.loadClass(name, resolve);
    }

    public InputStream getResourceAsStream(String name) {
        if (this.sparkClassLoader.fileNeedPreempt(name)) {
            return this.sparkClassLoader.getResourceAsStream(name);
        }
        return super.getResourceAsStream(name);
    }

    private boolean isParentCLPrecedent(String name) {
        for (String exemptPrefix : PARENT_CL_PRECEDENT_CLASSES) {
            if (!name.startsWith(exemptPrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isWontFind(String name) {
        return wontFindClasses.contains(name);
    }

    private boolean isCodeGen(String name) {
        for (String exemptPrefix : CODE_GEN_CLASS) {
            if (!name.startsWith(exemptPrefix)) continue;
            return true;
        }
        return false;
    }

    static {
        wontFindClasses.add("Class");
        wontFindClasses.add("Object");
        wontFindClasses.add("org");
        wontFindClasses.add("java.lang.org");
        wontFindClasses.add("java.lang$org");
        wontFindClasses.add("java$lang$org");
        wontFindClasses.add("org.apache");
        wontFindClasses.add("org.apache.calcite");
        wontFindClasses.add("org.apache.calcite.runtime");
        wontFindClasses.add("org.apache.calcite.linq4j");
        wontFindClasses.add("Long");
        wontFindClasses.add("String");
        logger = LoggerFactory.getLogger(TomcatClassLoader.class);
    }
}

