/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.spark.classloader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkClassLoader
extends URLClassLoader {
    private static String[] SPARK_CL_PREEMPT_CLASSES;
    private static String[] SPARK_CL_PREEMPT_FILES;
    private static String[] THIS_CL_PRECEDENT_CLASSES;
    private static String[] PARENT_CL_PRECEDENT_CLASSES;
    private static final Set<String> classNotFoundCache;
    private static Logger logger;

    protected SparkClassLoader(ClassLoader parent) throws IOException {
        super(new URL[0], parent);
        this.init();
    }

    public void init() throws MalformedURLException {
        File[] jars;
        String sparkHome = System.getenv("SPARK_HOME");
        if (sparkHome == null && (sparkHome = System.getProperty("SPARK_HOME")) == null) {
            throw new RuntimeException("Spark home not found; set it explicitly or use the SPARK_HOME environment variable.");
        }
        File file = new File(sparkHome + "/jars");
        for (File jar : jars = file.listFiles()) {
            this.addURL(jar.toURI().toURL());
        }
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.needToUseGlobal(name)) {
            logger.debug("delegate " + name + " directly to parent");
            return super.loadClass(name, resolve);
        }
        return this.doLoadclass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> doLoadclass(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clasz = this.findLoadedClass(name);
            if (clasz != null) {
                logger.debug("Class " + name + " already loaded");
            } else {
                try {
                    logger.debug("Finding class: " + name);
                    clasz = super.findClass(name);
                    if (clasz == null) {
                        logger.debug("cannot find class" + name);
                    }
                }
                catch (ClassNotFoundException e) {
                    classNotFoundCache.add(name);
                    logger.debug("Class " + name + " not found - delegating to parent");
                    try {
                        clasz = this.getParent().loadClass(name);
                    }
                    catch (ClassNotFoundException e2) {
                        logger.debug("Class " + name + " not found in parent loader");
                        throw e2;
                    }
                }
            }
            return clasz;
        }
    }

    private boolean isThisCLPrecedent(String name) {
        for (String exemptPrefix : THIS_CL_PRECEDENT_CLASSES) {
            if (!name.startsWith(exemptPrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentCLPrecedent(String name) {
        for (String exemptPrefix : PARENT_CL_PRECEDENT_CLASSES) {
            if (!name.startsWith(exemptPrefix)) continue;
            return true;
        }
        return false;
    }

    private boolean needToUseGlobal(String name) {
        return !this.isThisCLPrecedent(name) && !this.classNeedPreempt(name) && this.isParentCLPrecedent(name);
    }

    boolean classNeedPreempt(String name) {
        if (classNotFoundCache.contains(name)) {
            return false;
        }
        for (String exemptPrefix : SPARK_CL_PREEMPT_CLASSES) {
            if (!name.startsWith(exemptPrefix)) continue;
            return true;
        }
        return false;
    }

    boolean fileNeedPreempt(String name) {
        for (String exemptPrefix : SPARK_CL_PREEMPT_FILES) {
            if (!name.contains(exemptPrefix)) continue;
            return true;
        }
        return false;
    }

    static {
        String sparkClassLoaderParentClPrecedentClasses;
        String sparkClassLoaderThisClPrecedentClasses;
        String sparkClassLoaderSparkClPreemptFiles;
        SPARK_CL_PREEMPT_CLASSES = new String[]{"org.apache.spark", "scala.", "org.spark_project", "com.esotericsoftware.kryo"};
        SPARK_CL_PREEMPT_FILES = new String[]{"spark-version-info.properties", "HiveClientImpl", "org/apache/spark"};
        THIS_CL_PRECEDENT_CLASSES = new String[]{"javax.ws.rs", "org.apache.hadoop.hive"};
        PARENT_CL_PRECEDENT_CLASSES = new String[]{"com.sun.", "launcher.", "java.", "javax.", "org.ietf", "org.omg", "org.w3c", "org.xml", "sunw.", "sun.", "org.apache.commons.logging", "org.apache.log4j", "org.slf4j", "org.apache.hadoop", "org.apache.kylin", "com.intellij", "org.apache.calcite"};
        classNotFoundCache = new HashSet<String>();
        logger = LoggerFactory.getLogger(SparkClassLoader.class);
        String sparkClassLoaderSparkClPreemptClasses = System.getenv("SPARKCLASSLOADER_SPARK_CL_PREEMPT_CLASSES");
        if (!StringUtils.isEmpty((String)sparkClassLoaderSparkClPreemptClasses)) {
            SPARK_CL_PREEMPT_CLASSES = StringUtils.split((String)sparkClassLoaderSparkClPreemptClasses, (String)",");
        }
        if (!StringUtils.isEmpty((String)(sparkClassLoaderSparkClPreemptFiles = System.getenv("SPARKCLASSLOADER_SPARK_CL_PREEMPT_FILES")))) {
            SPARK_CL_PREEMPT_FILES = StringUtils.split((String)sparkClassLoaderSparkClPreemptFiles, (String)",");
        }
        if (!StringUtils.isEmpty((String)(sparkClassLoaderThisClPrecedentClasses = System.getenv("SPARKCLASSLOADER_THIS_CL_PRECEDENT_CLASSES")))) {
            THIS_CL_PRECEDENT_CLASSES = StringUtils.split((String)sparkClassLoaderThisClPrecedentClasses, (String)",");
        }
        if (!StringUtils.isEmpty((String)(sparkClassLoaderParentClPrecedentClasses = System.getenv("SPARKCLASSLOADER_PARENT_CL_PRECEDENT_CLASSES")))) {
            PARENT_CL_PRECEDENT_CLASSES = StringUtils.split((String)sparkClassLoaderParentClPrecedentClasses, (String)",");
        }
        try {
            final Method registerParallel = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    registerParallel.setAccessible(true);
                    return null;
                }
            });
            Boolean result = (Boolean)registerParallel.invoke(null, new Object[0]);
            if (!result.booleanValue()) {
                logger.warn("registrationFailed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

