/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.impl;

import java.util.Collection;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.cfg.MapperConfig;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeDeserializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.impl.AsExistingPropertyTypeSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.impl.AsExternalTypeDeserializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.impl.AsExternalTypeSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.impl.AsWrapperTypeDeserializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.impl.AsWrapperTypeSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.impl.MinimalClassNameIdResolver;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.impl.TypeNameIdResolver;

public class StdTypeResolverBuilder
implements TypeResolverBuilder<StdTypeResolverBuilder> {
    protected JsonTypeInfo.Id _idType;
    protected JsonTypeInfo.As _includeAs;
    protected String _typeProperty;
    protected boolean _typeIdVisible = false;
    protected Class<?> _defaultImpl;
    protected TypeIdResolver _customIdResolver;

    public static StdTypeResolverBuilder noTypeInfoBuilder() {
        return new StdTypeResolverBuilder().init(JsonTypeInfo.Id.NONE, null);
    }

    @Override
    public StdTypeResolverBuilder init(JsonTypeInfo.Id idType, TypeIdResolver idRes) {
        if (idType == null) {
            throw new IllegalArgumentException("idType can not be null");
        }
        this._idType = idType;
        this._customIdResolver = idRes;
        this._typeProperty = idType.getDefaultPropertyName();
        return this;
    }

    @Override
    public TypeSerializer buildTypeSerializer(SerializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        if (this._idType == JsonTypeInfo.Id.NONE) {
            return null;
        }
        TypeIdResolver idRes = this.idResolver(config, baseType, subtypes, true, false);
        switch (this._includeAs) {
            case WRAPPER_ARRAY: {
                return new AsArrayTypeSerializer(idRes, null);
            }
            case PROPERTY: {
                return new AsPropertyTypeSerializer(idRes, null, this._typeProperty);
            }
            case WRAPPER_OBJECT: {
                return new AsWrapperTypeSerializer(idRes, null);
            }
            case EXTERNAL_PROPERTY: {
                return new AsExternalTypeSerializer(idRes, null, this._typeProperty);
            }
            case EXISTING_PROPERTY: {
                return new AsExistingPropertyTypeSerializer(idRes, null, this._typeProperty);
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type serializer for inclusion type: " + (Object)((Object)this._includeAs));
    }

    @Override
    public TypeDeserializer buildTypeDeserializer(DeserializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        if (this._idType == JsonTypeInfo.Id.NONE) {
            return null;
        }
        TypeIdResolver idRes = this.idResolver(config, baseType, subtypes, false, true);
        switch (this._includeAs) {
            case WRAPPER_ARRAY: {
                return new AsArrayTypeDeserializer(baseType, idRes, this._typeProperty, this._typeIdVisible, this._defaultImpl);
            }
            case PROPERTY: 
            case EXISTING_PROPERTY: {
                return new AsPropertyTypeDeserializer(baseType, idRes, this._typeProperty, this._typeIdVisible, this._defaultImpl, this._includeAs);
            }
            case WRAPPER_OBJECT: {
                return new AsWrapperTypeDeserializer(baseType, idRes, this._typeProperty, this._typeIdVisible, this._defaultImpl);
            }
            case EXTERNAL_PROPERTY: {
                return new AsExternalTypeDeserializer(baseType, idRes, this._typeProperty, this._typeIdVisible, this._defaultImpl);
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type serializer for inclusion type: " + (Object)((Object)this._includeAs));
    }

    @Override
    public StdTypeResolverBuilder inclusion(JsonTypeInfo.As includeAs) {
        if (includeAs == null) {
            throw new IllegalArgumentException("includeAs can not be null");
        }
        this._includeAs = includeAs;
        return this;
    }

    @Override
    public StdTypeResolverBuilder typeProperty(String typeIdPropName) {
        if (typeIdPropName == null || typeIdPropName.length() == 0) {
            typeIdPropName = this._idType.getDefaultPropertyName();
        }
        this._typeProperty = typeIdPropName;
        return this;
    }

    @Override
    public StdTypeResolverBuilder defaultImpl(Class<?> defaultImpl) {
        this._defaultImpl = defaultImpl;
        return this;
    }

    @Override
    public StdTypeResolverBuilder typeIdVisibility(boolean isVisible) {
        this._typeIdVisible = isVisible;
        return this;
    }

    @Override
    public Class<?> getDefaultImpl() {
        return this._defaultImpl;
    }

    public String getTypeProperty() {
        return this._typeProperty;
    }

    public boolean isTypeIdVisible() {
        return this._typeIdVisible;
    }

    protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        if (this._idType == null) {
            throw new IllegalStateException("Can not build, 'init()' not yet called");
        }
        switch (this._idType) {
            case CLASS: {
                return new ClassNameIdResolver(baseType, config.getTypeFactory());
            }
            case MINIMAL_CLASS: {
                return new MinimalClassNameIdResolver(baseType, config.getTypeFactory());
            }
            case NAME: {
                return TypeNameIdResolver.construct(config, baseType, subtypes, forSer, forDeser);
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type id resolver for idType: " + (Object)((Object)this._idType));
    }
}

