/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.adaptor;

public class AdaptorConfig {
    public final String url;
    public final String driver;
    public final String username;
    public final String password;
    public String datasourceId;
    public int poolMaxIdle = 8;
    public int poolMaxTotal = 8;
    public int poolMinIdle = 0;

    public AdaptorConfig(String url, String driver, String username, String password) {
        this.url = url;
        this.driver = driver;
        this.username = username;
        this.password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdaptorConfig that = (AdaptorConfig)o;
        if (this.poolMaxIdle != that.poolMaxIdle) {
            return false;
        }
        if (this.poolMaxTotal != that.poolMaxTotal) {
            return false;
        }
        if (this.poolMinIdle != that.poolMinIdle) {
            return false;
        }
        if (!this.url.equals(that.url)) {
            return false;
        }
        if (!this.driver.equals(that.driver)) {
            return false;
        }
        if (!this.username.equals(that.username)) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return this.datasourceId != null ? this.datasourceId.equals(that.datasourceId) : that.datasourceId == null;
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + this.driver.hashCode();
        result = 31 * result + this.username.hashCode();
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.datasourceId != null ? this.datasourceId.hashCode() : 0);
        result = 31 * result + this.poolMaxIdle;
        result = 31 * result + this.poolMaxTotal;
        result = 31 * result + this.poolMinIdle;
        return result;
    }
}

