/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.metadata.FunctionDesc;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.InMemoryTableScanExec;
import org.apache.spark.sql.hive.execution.HiveTableScanExec;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

public final class ResourceDetectUtils$
implements Logging {
    public static final ResourceDetectUtils$ MODULE$;
    private final Gson json;
    private final String cubingDetectItemFileSuffix;
    private final String samplingDetectItemFileSuffix;
    private final String countDistinctSuffix;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ResourceDetectUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private Gson json() {
        return this.json;
    }

    public Seq<Path> getPaths(SparkPlan plan) {
        ObjectRef paths = ObjectRef.create((Object)((Seq)Seq$.MODULE$.empty()));
        plan.foreach((Function1)new Serializable(paths){
            public static final long serialVersionUID = 0L;
            public final ObjectRef paths$1;

            public final void apply(SparkPlan x0$1) {
                SparkPlan sparkPlan = x0$1;
                if (sparkPlan instanceof FileSourceScanExec) {
                    FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)sparkPlan;
                    this.paths$1.elem = (Seq)((Seq)this.paths$1.elem).$plus$plus((GenTraversableOnce)fileSourceScanExec.relation().location().rootPaths(), Seq$.MODULE$.canBuildFrom());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (sparkPlan instanceof InMemoryTableScanExec) {
                    InMemoryTableScanExec inMemoryTableScanExec = (InMemoryTableScanExec)sparkPlan;
                    SparkPlan _plan = inMemoryTableScanExec.relation().cachedPlan();
                    this.paths$1.elem = (Seq)((Seq)this.paths$1.elem).$plus$plus(ResourceDetectUtils$.MODULE$.getPaths(_plan), Seq$.MODULE$.canBuildFrom());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (sparkPlan instanceof HiveTableScanExec) {
                    BoxedUnit boxedUnit;
                    HiveTableScanExec hiveTableScanExec = (HiveTableScanExec)sparkPlan;
                    if (hiveTableScanExec.relation().isPartitioned()) {
                        hiveTableScanExec.rawPartitions().foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.getPaths.1 $outer;

                            public final void apply(Partition partition) {
                                this.$outer.paths$1.elem = (Seq)((Seq)this.$outer.paths$1.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])partition.getPath()), Seq$.MODULE$.canBuildFrom());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.paths$1.elem = (Seq)((Seq)this.paths$1.elem).$colon$plus((Object)new Path(hiveTableScanExec.relation().tableMeta().location()), Seq$.MODULE$.canBuildFrom());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.paths$1 = paths$1;
            }
        });
        return (Seq)paths.elem;
    }

    public java.util.Map<String, java.util.Map<String, List<String>>> listSourcePath(Path shareDir) throws IOException {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        FileStatus[] fileStatuses = fs.listStatus(shareDir, new PathFilter(){

            public boolean accept(Path path) {
                return path.toString().endsWith(ResourceDetectUtils$.MODULE$.fileName());
            }
        });
        HashMap<String, java.util.Map<String, List<String>>> resourcePaths = Maps.newHashMap();
        Predef$.MODULE$.refArrayOps((Object[])fileStatuses).foreach((Function1)new Serializable(resourcePaths){
            public static final long serialVersionUID = 0L;
            private final HashMap resourcePaths$1;

            public final java.util.Map<String, List<String>> apply(FileStatus file) {
                String fileName = file.getPath().getName();
                String segmentId = fileName.substring(0, fileName.indexOf(ResourceDetectUtils$.MODULE$.fileName()) - 1);
                java.util.Map map = (java.util.Map)ResourceDetectUtils$.MODULE$.readResourcePathsAs(file.getPath());
                return this.resourcePaths$1.put(segmentId, map);
            }
            {
                this.resourcePaths$1 = resourcePaths$1;
            }
        });
        return resourcePaths;
    }

    public boolean findCountDistinctMeasure(Collection<LayoutEntity> layouts) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(layouts).asScala()).foreach((Function1)new Serializable(object){
                    public static final long serialVersionUID = 0L;
                    public final Object nonLocalReturnKey1$1;

                    public final void apply(LayoutEntity layoutEntity) {
                        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(layoutEntity.getOrderedMeasures().values()).asScala()).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.findCountDistinctMeasure.1 $outer;

                            public final void apply(FunctionDesc measure) {
                                if (measure.expression().equalsIgnoreCase("COUNT_DISTINCT")) {
                                    throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey1$1, true);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public long getResourceSize(Seq<Path> paths) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)paths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Path path) {
                FileSystem fs = path.getFileSystem(HadoopUtil.getCurrentConfiguration());
                return fs.exists(path) ? HadoopUtil.getContentSummary(fs, path).getLength() : 0L;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long getMaxResourceSize(Path shareDir) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listSourcePath(shareDir).values()).asScala()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(java.util.Map<String, List<String>> value) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(value.values()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(List<String> v) {
                        return ResourceDetectUtils$.MODULE$.getResourceSize((Seq<Path>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(v).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Path apply(String path) {
                                return new Path(path);
                            }
                        }, Buffer$.MODULE$.canBuildFrom())));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
    }

    public java.util.Map<String, Object> getSegmentSourceSize(Path shareDir) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.listSourcePath(shareDir)).asScala()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, java.util.Map<String, List<String>>> x$1) {
                return ((java.util.Map)x$1._2()).keySet().contains("-1");
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<String, java.util.Map<String, List<String>>> tp) {
                return new Tuple2(tp._1(), (Object)BoxesRunTime.boxToLong((long)ResourceDetectUtils$.MODULE$.getResourceSize((Seq<Path>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)((java.util.Map)tp._2()).get("-1")).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(String path) {
                        return new Path(path);
                    }
                }, Buffer$.MODULE$.canBuildFrom())))));
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    public void write(Path path, Object item) {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        FSDataOutputStream out = null;
        try {
            out = fs.create(path);
            String str = this.json().toJson(item);
            byte[] bytes = str.getBytes(Charset.defaultCharset());
            out.writeInt(bytes.length);
            out.write(bytes);
            return;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String selectMaxValueInFiles(FileStatus[] files) {
        return Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(FileStatus f) {
                return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((java.util.Map)ResourceDetectUtils$.MODULE$.readResourcePathsAs(f.getPath())).values()).asScala()).max((Ordering)Ordering.Double$.MODULE$));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).max((Ordering)Ordering.Double$.MODULE$).toString();
    }

    public java.util.Map<String, String> readDetectItems(Path path) {
        return (java.util.Map)this.readResourcePathsAs(path);
    }

    public <T> T readResourcePathsAs(Path path) {
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read resource paths form ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        FSDataInputStream in = null;
        try {
            in = fs.open(path);
            int i = in.readInt();
            byte[] bytes = new byte[i];
            in.readFully(bytes);
            return (T)this.json().fromJson(new String(bytes, Charset.defaultCharset()), new TypeToken<T>(){}.getType());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public String fileName() {
        return "resource_paths.json";
    }

    public String cubingDetectItemFileSuffix() {
        return this.cubingDetectItemFileSuffix;
    }

    public String samplingDetectItemFileSuffix() {
        return this.samplingDetectItemFileSuffix;
    }

    public String countDistinctSuffix() {
        return this.countDistinctSuffix;
    }

    private ResourceDetectUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.json = new Gson();
        this.cubingDetectItemFileSuffix = "cubing_detect_items.json";
        this.samplingDetectItemFileSuffix = "sampling_detect_items.json";
        this.countDistinctSuffix = "count_distinct.json";
    }
}

