/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.kylin.engine.spark.common.util.KylinDateTimeUtils$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.KylinAddMonths$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(start_date, num_months) - Returns the date that is `num_months` after `start_date`.", extended="\n    Examples:\n      > SELECT _FUNC_('2016-08-31', 1);\n       2016-09-30\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001>\u0011abS=mS:\fE\rZ'p]RD7O\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0003F\f\u001e!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%A\u0005ti\u0006\u0014H\u000fR1uKV\t1\u0005\u0005\u0002\u0012I%\u0011QE\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002C\u0014\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\u0015M$\u0018M\u001d;ECR,\u0007\u0005\u0003\u0005*\u0001\tU\r\u0011\"\u0001#\u0003%qW/\\'p]RD7\u000f\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003)qW/\\'p]RD7\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002\u0012\u0001!)\u0011\u0005\fa\u0001G!)\u0011\u0006\fa\u0001G!)1\u0007\u0001C!E\u0005!A.\u001a4u\u0011\u0015)\u0004\u0001\"\u0011#\u0003\u0015\u0011\u0018n\u001a5u\u0011\u00159\u0004\u0001\"\u00119\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002sA\u0019!HQ#\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u000f\u0003\u0019a$o\\8u}%\t!$\u0003\u0002B3\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005\r\u0019V-\u001d\u0006\u0003\u0003f\u0001\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0004\u0002\u000bQL\b/Z:\n\u0005);%\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015a\u0005\u0001\"\u0011N\u0003!!\u0017\r^1UsB,W#\u0001(\u0011\u0005\u0019{\u0015B\u0001)H\u00055!\u0016.\\3ti\u0006l\u0007\u000fV=qK\")!\u000b\u0001C!'\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019AkV-\u0011\u0005a)\u0016B\u0001,\u001a\u0005\r\te.\u001f\u0005\u00061F\u0003\r\u0001V\u0001\u0006gR\f'\u000f\u001e\u0005\u00065F\u0003\r\u0001V\u0001\u0007[>tG\u000f[:\t\u000bq\u0003A\u0011I/\u0002\u0013\u0011|w)\u001a8D_\u0012,Gc\u00010eSB\u0011qLY\u0007\u0002A*\u0011\u0011MA\u0001\bG>$WmZ3o\u0013\t\u0019\u0007M\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015)7\f1\u0001g\u0003\r\u0019G\u000f\u001f\t\u0003?\u001eL!\u0001\u001b1\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")!n\u0017a\u0001=\u0006\u0011QM\u001e\u0005\u0006Y\u0002!\t%\\\u0001\u000baJ,G\u000f^=OC6,W#\u00018\u0011\u0005=\u0014hB\u0001\rq\u0013\t\t\u0018$\u0001\u0004Qe\u0016$WMZ\u0005\u0003gR\u0014aa\u0015;sS:<'BA9\u001a\u0011\u001d1\b!!A\u0005\u0002]\fAaY8qsR\u0019q\u0006_=\t\u000f\u0005*\b\u0013!a\u0001G!9\u0011&\u001eI\u0001\u0002\u0004\u0019\u0003bB>\u0001#\u0003%\t\u0001`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005i(FA\u0012\u007fW\u0005y\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0003\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001b\t\u0019AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0001\"!\u0005\u0001#\u0003%\t\u0001`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\t)\u0002AA\u0001\n\u0003\n9\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00033\u0001B!a\u0007\u0002&5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0003mC:<'BAA\u0012\u0003\u0011Q\u0017M^1\n\u0007M\fi\u0002C\u0005\u0002*\u0001\t\t\u0011\"\u0001\u0002,\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0006\t\u00041\u0005=\u0012bAA\u00193\t\u0019\u0011J\u001c;\t\u0013\u0005U\u0002!!A\u0005\u0002\u0005]\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004)\u0006e\u0002BCA\u001e\u0003g\t\t\u00111\u0001\u0002.\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005}\u0002!!A\u0005B\u0005\u0005\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0003#BA#\u0003\u0017\"VBAA$\u0015\r\tI%G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA'\u0003\u000f\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003#\u0002\u0011\u0011!C\u0001\u0003'\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003+\nY\u0006E\u0002\u0019\u0003/J1!!\u0017\u001a\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u000f\u0002P\u0005\u0005\t\u0019\u0001+\t\u0013\u0005}\u0003!!A\u0005B\u0005\u0005\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002V\u0005\r\u0004\"CA\u001e\u0003;\n\t\u00111\u0001UQ-\u0001\u0011qMA7\u0003_\n\u0019(!\u001e\u0011\u0007E\tI'C\u0002\u0002l\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002r\u0005QvLR+O\u0007~C3\u000f^1si~#\u0017\r^3-A9,XnX7p]RD7/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011eCR,\u0007\u0005\u001e5bi\u0002J7\u000f\t1ok6|Vn\u001c8uQN\u0004\u0007%\u00194uKJ\u0004\u0003m\u001d;beR|F-\u0019;fA:\n\u0001\"\u001a=uK:$W\rZ\u0011\u0003\u0003o\n1J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nd'\f\u00199[M\nt\u0005\f\u00112SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00197[AJTf\r\u0019\u000bA\u0001:\u0011\"a\u001f\u0003\u0003\u0003E\t!! \u0002\u001d-KH.\u001b8BI\u0012luN\u001c;igB\u0019\u0011#a \u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u0003\u001bR!a \u0002\u0004v\u0001r!!\"\u0002\f\u000e\u001as&\u0004\u0002\u0002\b*\u0019\u0011\u0011R\r\u0002\u000fI,h\u000e^5nK&!\u0011QRAD\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b[\u0005}D\u0011AAI)\t\ti\b\u0003\u0006\u0002\u0016\u0006}\u0014\u0011!C#\u0003/\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033A!\"a'\u0002\u0000\u0005\u0005I\u0011QAO\u0003\u0015\t\u0007\u000f\u001d7z)\u0015y\u0013qTAQ\u0011\u0019\t\u0013\u0011\u0014a\u0001G!1\u0011&!'A\u0002\rB!\"!*\u0002\u0000\u0005\u0005I\u0011QAT\u0003\u001d)h.\u00199qYf$B!!+\u00026B)\u0001$a+\u00020&\u0019\u0011QV\r\u0003\r=\u0003H/[8o!\u0015A\u0012\u0011W\u0012$\u0013\r\t\u0019,\u0007\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005]\u00161UA\u0001\u0002\u0004y\u0013a\u0001=%a!Q\u00111XA@\u0003\u0003%I!!0\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u007f\u0003B!a\u0007\u0002B&!\u00111YA\u000f\u0005\u0019y%M[3di\u0002")
public class KylinAddMonths
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression startDate;
    private final Expression numMonths;

    public static Option<Tuple2<Expression, Expression>> unapply(KylinAddMonths kylinAddMonths) {
        return KylinAddMonths$.MODULE$.unapply(kylinAddMonths);
    }

    public static Function1<Tuple2<Expression, Expression>, KylinAddMonths> tupled() {
        return KylinAddMonths$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, KylinAddMonths>> curried() {
        return KylinAddMonths$.MODULE$.curried();
    }

    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.class.checkInputDataTypes((ExpectsInputTypes)this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression numMonths() {
        return this.numMonths;
    }

    public Expression left() {
        return this.startDate();
    }

    public Expression right() {
        return this.numMonths();
    }

    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, IntegerType$.MODULE$}));
    }

    public TimestampType dataType() {
        return TimestampType$.MODULE$;
    }

    public Object nullSafeEval(Object start, Object months) {
        long time2 = BoxesRunTime.unboxToLong((Object)start);
        int month = BoxesRunTime.unboxToInt((Object)months);
        return BoxesRunTime.boxToLong((long)KylinDateTimeUtils$.MODULE$.addMonths(time2, month));
    }

    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(KylinDateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function2)new Serializable(this, dtu){
            public static final long serialVersionUID = 0L;
            private final String dtu$1;

            public final String apply(String sd, String m) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".addMonths(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dtu$1, sd, m}));
            }
            {
                this.dtu$1 = dtu$1;
            }
        });
    }

    public String prettyName() {
        return "kylin_add_months";
    }

    public KylinAddMonths copy(Expression startDate, Expression numMonths) {
        return new KylinAddMonths(startDate, numMonths);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.numMonths();
    }

    public String productPrefix() {
        return "KylinAddMonths";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.numMonths();
                break;
            }
            case 0: {
                expression = this.startDate();
            }
        }
        return expression;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KylinAddMonths;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KylinAddMonths)) return false;
        boolean bl = true;
        if (!bl) return false;
        KylinAddMonths kylinAddMonths = (KylinAddMonths)((Object)x$1);
        Expression expression = this.startDate();
        Expression expression2 = kylinAddMonths.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.numMonths();
        Expression expression4 = kylinAddMonths.numMonths();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!kylinAddMonths.canEqual((Object)this)) return false;
        return true;
    }

    public KylinAddMonths(Expression startDate, Expression numMonths) {
        this.startDate = startDate;
        this.numMonths = numMonths;
        ExpectsInputTypes.class.$init$((ExpectsInputTypes)this);
    }
}

