/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.ColumnName;
import org.apache.spark.sql.FunctionEntity;
import org.apache.spark.sql.FunctionEntity$;
import org.apache.spark.sql.KylinDayOfWeek;
import org.apache.spark.sql.KylinSubtractMonths;
import org.apache.spark.sql.TRUNCATE;
import org.apache.spark.sql.catalyst.expressions.DictEncode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionUtils$;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.KylinAddMonths;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.SplitPart;
import org.apache.spark.sql.catalyst.expressions.Sum0;
import org.apache.spark.sql.catalyst.expressions.TimestampAdd;
import org.apache.spark.sql.catalyst.expressions.TimestampDiff;
import org.apache.spark.sql.catalyst.expressions.Truncate;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.udaf.ApproxCountDistinct;
import org.apache.spark.sql.udaf.ApproxCountDistinct$;
import org.apache.spark.sql.udaf.IntersectCount;
import org.apache.spark.sql.udaf.IntersectCount$;
import org.apache.spark.sql.udaf.PreciseCountDistinct;
import org.apache.spark.sql.udaf.PreciseCountDistinct$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class KylinFunctions$ {
    public static final KylinFunctions$ MODULE$;
    private final Seq<FunctionEntity> builtin;

    static {
        new KylinFunctions$();
    }

    private Column withAggregateFunction(AggregateFunction func, boolean isDistinct) {
        return Column$.MODULE$.apply((Expression)func.toAggregateExpression(isDistinct));
    }

    private boolean withAggregateFunction$default$2() {
        return false;
    }

    public Column kylin_add_months(Column startDate, Column numMonths) {
        return Column$.MODULE$.apply((Expression)new KylinAddMonths(startDate.expr(), numMonths.expr()));
    }

    public Column dict_encode(Column column, Column dictParams, Column bucketSize) {
        return Column$.MODULE$.apply((Expression)new DictEncode(column.expr(), dictParams.expr(), bucketSize.expr()));
    }

    public Column k_lit(Object literal) {
        Column column;
        Object object = literal;
        if (object instanceof Column) {
            Column column2;
            column = column2 = (Column)object;
        } else if (object instanceof Symbol) {
            Symbol symbol = (Symbol)object;
            column = new ColumnName(symbol.name());
        } else {
            column = Column$.MODULE$.apply((Expression)Literal$.MODULE$.apply(literal));
        }
        return column;
    }

    public Column k_like(Column left, Column right) {
        return Column$.MODULE$.apply((Expression)new Like(left.expr(), right.expr()));
    }

    public Column in(Expression value, Seq<Expression> list) {
        return Column$.MODULE$.apply((Expression)new In(value, list));
    }

    public Column kylin_day_of_week(Column date) {
        return Column$.MODULE$.apply((Expression)new KylinDayOfWeek(date.expr()));
    }

    public Column kylin_truncate(Column column, int scale) {
        return Column$.MODULE$.apply((Expression)new TRUNCATE(column.expr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)scale))));
    }

    public Column kylin_subtract_months(Column date0, Column date1) {
        return Column$.MODULE$.apply((Expression)new KylinSubtractMonths(date0.expr(), date1.expr()));
    }

    public Column precise_count_distinct(Column column) {
        return Column$.MODULE$.apply((Expression)new PreciseCountDistinct(column.expr(), PreciseCountDistinct$.MODULE$.apply$default$2(), PreciseCountDistinct$.MODULE$.apply$default$3()).toAggregateExpression());
    }

    public Column approx_count_distinct(Column column, int precision) {
        return Column$.MODULE$.apply((Expression)new ApproxCountDistinct(column.expr(), precision, ApproxCountDistinct$.MODULE$.apply$default$3(), ApproxCountDistinct$.MODULE$.apply$default$4()).toAggregateExpression());
    }

    public Column intersect_count(int upperBound, Seq<Column> columns) {
        Predef$.MODULE$.require(columns.size() == 3, (Function0)new Serializable(columns){
            public static final long serialVersionUID = 0L;
            private final Seq columns$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input columns size ", " don't equal to 3."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.columns$1.size())}));
            }
            {
                this.columns$1 = columns$1;
            }
        });
        Seq expressions = (Seq)columns.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Expression apply(Column x$1) {
                return x$1.expr();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return Column$.MODULE$.apply((Expression)new IntersectCount((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2), (DataType)LongType$.MODULE$, upperBound, IntersectCount$.MODULE$.apply$default$6(), IntersectCount$.MODULE$.apply$default$7()).toAggregateExpression());
    }

    public Column intersect_value(int upperBound, Seq<Column> columns) {
        Predef$.MODULE$.require(columns.size() == 3, (Function0)new Serializable(columns){
            public static final long serialVersionUID = 0L;
            private final Seq columns$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input columns size ", " don't equal to 3."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.columns$2.size())}));
            }
            {
                this.columns$2 = columns$2;
            }
        });
        Seq expressions = (Seq)columns.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Expression apply(Column x$2) {
                return x$2.expr();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return Column$.MODULE$.apply((Expression)new IntersectCount((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2), (DataType)StringType$.MODULE$, upperBound, IntersectCount$.MODULE$.apply$default$6(), IntersectCount$.MODULE$.apply$default$7()).toAggregateExpression());
    }

    public Column sum0(Column e) {
        return this.withAggregateFunction((AggregateFunction)new Sum0(e.expr()), this.withAggregateFunction$default$2());
    }

    public Seq<FunctionEntity> builtin() {
        return this.builtin;
    }

    private KylinFunctions$() {
        MODULE$ = this;
        this.builtin = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FunctionEntity[]{FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("TIMESTAMPADD", ClassTag$.MODULE$.apply(TimestampAdd.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("TIMESTAMPDIFF", ClassTag$.MODULE$.apply(TimestampDiff.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("TRUNCATE", ClassTag$.MODULE$.apply(Truncate.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("DICTENCODE", ClassTag$.MODULE$.apply(DictEncode.class))), FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("split_part", ClassTag$.MODULE$.apply(SplitPart.class)))}));
    }
}

