/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.memory.ExecutionMemoryPool;
import org.apache.spark.memory.MemoryGetter;
import org.apache.spark.memory.Reflector$;
import org.apache.spark.memory.SparkMemoryManagerHandle$;
import org.apache.spark.memory.StorageMemoryPool;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001-\u0011\u0001d\u00159be.lU-\\8ss6\u000bg.Y4fe\"\u000bg\u000e\u001a7f\u0015\t\u0019A!\u0001\u0004nK6|'/\u001f\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u00195+Wn\u001c:z\u000f\u0016$H/\u001a:\t\u0011]\u0001!Q1A\u0005\u0002a\tQb\u001c8IK\u0006\u00048\u000b^8sC\u001e,W#A\r\u0011\u0005MQ\u0012BA\u000e\u0003\u0005E\u0019Fo\u001c:bO\u0016lU-\\8ssB{w\u000e\u001c\u0005\t;\u0001\u0011\t\u0011)A\u00053\u0005qqN\u001c%fCB\u001cFo\u001c:bO\u0016\u0004\u0003\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\u0001\r\u0002\u001d=4g\rS3baN#xN]1hK\"A\u0011\u0005\u0001B\u0001B\u0003%\u0011$A\bpM\u001aDU-\u00199Ti>\u0014\u0018mZ3!\u0011!\u0019\u0003A!b\u0001\n\u0003!\u0013aD8o\u0011\u0016\f\u0007/\u0012=fGV$\u0018n\u001c8\u0016\u0003\u0015\u0002\"a\u0005\u0014\n\u0005\u001d\u0012!aE#yK\u000e,H/[8o\u001b\u0016lwN]=Q_>d\u0007\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002!=t\u0007*Z1q\u000bb,7-\u001e;j_:\u0004\u0003\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0002!=4g\rS3ba\u0016CXmY;uS>t\u0007\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002#=4g\rS3ba\u0016CXmY;uS>t\u0007\u0005\u0003\u00050\u0001\t\u0015\r\u0011\"\u00011\u0003\u0011awnY6\u0016\u0003E\u0002\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\t1\fgn\u001a\u0006\u0002m\u0005!!.\u0019<b\u0013\tA4G\u0001\u0004PE*,7\r\u001e\u0005\tu\u0001\u0011\t\u0011)A\u0005c\u0005)An\\2lA!)A\b\u0001C\u0001{\u00051A(\u001b8jiz\"bAP A\u0003\n\u001b\u0005CA\n\u0001\u0011\u001592\b1\u0001\u001a\u0011\u0015y2\b1\u0001\u001a\u0011\u0015\u00193\b1\u0001&\u0011\u0015Y3\b1\u0001&\u0011\u0015y3\b1\u00012\u0011\u001d)\u0005A1A\u0005\u0002\u0019\u000bQA\\1nKN,\u0012a\u0012\t\u0004\u0011B\u001bfBA%O\u001d\tQU*D\u0001L\u0015\ta%\"\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011qJD\u0001\ba\u0006\u001c7.Y4f\u0013\t\t&KA\u0002TKFT!a\u0014\b\u0011\u0005Q;fBA\u0007V\u0013\t1f\"\u0001\u0004Qe\u0016$WMZ\u0005\u00031f\u0013aa\u0015;sS:<'B\u0001,\u000f\u0011\u0019Y\u0006\u0001)A\u0005\u000f\u00061a.Y7fg\u0002BQ!\u0018\u0001\u0005By\u000baA^1mk\u0016\u001cHcA0cUB\u0011Q\u0002Y\u0005\u0003C:\u0011A!\u00168ji\")1\r\u0018a\u0001I\u0006!A-Z:u!\riQmZ\u0005\u0003M:\u0011Q!\u0011:sCf\u0004\"!\u00045\n\u0005%t!\u0001\u0002'p]\u001eDQa\u001b/A\u00021\faa\u001c4gg\u0016$\bCA\u0007n\u0013\tqgBA\u0002J]RDQ\u0001\u001d\u0001\u0005\u0002E\f\u0001#\\1y)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8\u0015\u0005\u001d\u0014\b\"B:p\u0001\u0004)\u0013aE3yK\u000e,H/[8o\u001b\u0016lwN]=Q_>dw!B;\u0003\u0011\u00031\u0018\u0001G*qCJ\\W*Z7pefl\u0015M\\1hKJD\u0015M\u001c3mKB\u00111c\u001e\u0004\u0006\u0003\tA\t\u0001_\n\u0003o2AQ\u0001P<\u0005\u0002i$\u0012A\u001e\u0005\u0006y^$\t!`\u0001\u0004O\u0016$H#\u0001@\u0011\u00075yh(C\u0002\u0002\u00029\u0011aa\u00149uS>t\u0007")
public class SparkMemoryManagerHandle
implements MemoryGetter {
    private final StorageMemoryPool onHeapStorage;
    private final StorageMemoryPool offHeapStorage;
    private final ExecutionMemoryPool onHeapExecution;
    private final ExecutionMemoryPool offHeapExecution;
    private final Object lock;
    private final Seq<String> names;

    public static Option<SparkMemoryManagerHandle> get() {
        return SparkMemoryManagerHandle$.MODULE$.get();
    }

    public StorageMemoryPool onHeapStorage() {
        return this.onHeapStorage;
    }

    public StorageMemoryPool offHeapStorage() {
        return this.offHeapStorage;
    }

    public ExecutionMemoryPool onHeapExecution() {
        return this.onHeapExecution;
    }

    public ExecutionMemoryPool offHeapExecution() {
        return this.offHeapExecution;
    }

    public Object lock() {
        return this.lock;
    }

    @Override
    public Seq<String> names() {
        return this.names;
    }

    @Override
    public void values(long[] dest, int offset) {
        dest[offset] = this.onHeapStorage().memoryUsed();
        dest[offset + 1] = this.onHeapExecution().memoryUsed();
        dest[offset + 2] = this.maxTaskExecution(this.onHeapExecution());
        dest[offset + 3] = this.offHeapStorage().memoryUsed();
        dest[offset + 4] = this.offHeapExecution().memoryUsed();
        dest[offset + 5] = this.maxTaskExecution(this.offHeapExecution());
    }

    public long maxTaskExecution(ExecutionMemoryPool executionMemoryPool) {
        Object object = this.lock();
        synchronized (object) {
            Map taskMem = (Map)Reflector$.MODULE$.ReflectorConversions(executionMemoryPool).reflectField("memoryForTask");
            Long l = taskMem.nonEmpty() ? taskMem.values().max((Ordering)Ordering.Long$.MODULE$) : BoxesRunTime.boxToLong((long)0L);
            return BoxesRunTime.unboxToLong((Object)l);
        }
    }

    public SparkMemoryManagerHandle(StorageMemoryPool onHeapStorage, StorageMemoryPool offHeapStorage, ExecutionMemoryPool onHeapExecution, ExecutionMemoryPool offHeapExecution, Object lock) {
        this.onHeapStorage = onHeapStorage;
        this.offHeapStorage = offHeapStorage;
        this.onHeapExecution = onHeapExecution;
        this.offHeapExecution = offHeapExecution;
        this.lock = lock;
        this.names = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"onHeap", "offHeap"}))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String t) {
                return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Storage", "Execution", "MaxTaskExecution"}))).map((Function1)new Serializable(this, t){
                    public static final long serialVersionUID = 0L;
                    private final String t$1;

                    public final String apply(String s) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.t$1, s}));
                    }
                    {
                        this.t$1 = t$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
    }
}

