/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import org.apache.spark.TaskSummary;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetrics;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class TaskSummary$ {
    public static final TaskSummary$ MODULE$;

    static {
        new TaskSummary$();
    }

    public TaskSummary apply(TaskData task) {
        long totalExecutionTime = BoxesRunTime.unboxToLong((Object)task.duration().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        Option metricsOpt = task.taskMetrics();
        long jvmGcTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(TaskMetrics x$5) {
                return x$5.jvmGcTime();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        double jvmGcTimeProportion = this.toProportion$1(jvmGcTime, totalExecutionTime);
        long serializationTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(TaskMetrics x$6) {
                return x$6.resultSerializationTime();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        double serializationTimeProportion = this.toProportion$1(serializationTime, totalExecutionTime);
        long deserializationTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(TaskMetrics x$7) {
                return x$7.executorDeserializeTime();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        double deserializationTimeProportion = this.toProportion$1(deserializationTime, totalExecutionTime);
        long shuffleReadTime = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(TaskMetrics x$8) {
                return x$8.shuffleReadMetrics().fetchWaitTime();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        double shuffleReadTimeProportion = this.toProportion$1(shuffleReadTime, totalExecutionTime);
        long shuffleWriteTime = (long)((double)BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(TaskMetrics x$9) {
                return x$9.shuffleWriteMetrics().writeTime();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })) / 1000000.0);
        double shuffleWriteTimeProportion = this.toProportion$1(shuffleWriteTime, totalExecutionTime);
        long inputBytes = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(TaskMetrics x$10) {
                return x$10.inputMetrics().bytesRead();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        long inputRecord = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(TaskMetrics x$11) {
                return x$11.inputMetrics().recordsRead();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        long outputBytes = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(TaskMetrics x$12) {
                return x$12.outputMetrics().bytesWritten();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        long outputRecord = BoxesRunTime.unboxToLong((Object)metricsOpt.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(TaskMetrics x$13) {
                return x$13.outputMetrics().recordsWritten();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        return new TaskSummary(task.taskId(), task.executorId(), totalExecutionTime, jvmGcTime, jvmGcTimeProportion, serializationTime, serializationTimeProportion, deserializationTime, deserializationTimeProportion, shuffleReadTime, shuffleReadTimeProportion, shuffleWriteTime, shuffleWriteTimeProportion, inputBytes, inputRecord, outputBytes, outputRecord);
    }

    public Seq<String> schema() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"taskId", "executorId", "totalExecutionTime", "jvmGcTime", "jvmGcTimeProportion", "serializationTime", "serializationTimeProportion", "deserializationTime", "deserializationTimeProportion", "shuffleReadTime", "shuffleReadTimeProportion", "shuffleWriteTime", "shuffleWriteTimeProportion", "taskInputBytes", "taskInputRecords", "taskOutputBytes", "taskOutputRecords"}));
    }

    public TaskSummary invalid() {
        return new TaskSummary(-1L, "invalid", -1L, -1L, -1.0, -1L, -1.0, -1L, -1.0, -1L, -1.0, -1L, -1.0, -1L, -1L, -1L, -1L);
    }

    private final double toProportion$1(long time2, long totalExecutionTime$1) {
        return new StringOps(Predef$.MODULE$.augmentString(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)((double)time2 / (double)totalExecutionTime$1 * (double)100))), "%.2f"))).toDouble();
    }

    private TaskSummary$() {
        MODULE$ = this;
    }
}

