/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.shaded.com.fasterxml.jackson.dataformat.xml.util;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public class StaxUtil {
    public static <T> T throwXmlAsIOException(XMLStreamException e) throws IOException {
        Throwable t = e;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new IOException(t);
    }

    public static String sanitizeXmlTypeName(String name) {
        StringBuilder sb;
        int changes = 0;
        if (name.endsWith("[]")) {
            do {
                name = name.substring(0, name.length() - 2);
                ++changes;
            } while (name.endsWith("[]"));
            sb = new StringBuilder(name);
            if (name.endsWith("s")) {
                sb.append("es");
            } else {
                sb.append('s');
            }
        } else {
            sb = new StringBuilder(name);
        }
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c > '\u007f' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == '-') continue;
            ++changes;
            if (c == '$') {
                sb.setCharAt(i, '.');
                continue;
            }
            sb.setCharAt(i, '_');
        }
        if (changes == 0) {
            return name;
        }
        return sb.toString();
    }
}

