/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.shaded.com.fasterxml.jackson.dataformat.xml;

import java.io.IOException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.PrettyPrinter;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.Version;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.dataformat.xml.PackageVersion;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.dataformat.xml.XmlFactory;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.dataformat.xml.ser.XmlSerializerProvider;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.dataformat.xml.util.XmlRootNameLookup;

public class XmlMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    protected static final JacksonXmlModule DEFAULT_XML_MODULE = new JacksonXmlModule();
    protected static final DefaultXmlPrettyPrinter DEFAULT_XML_PRETTY_PRINTER = new DefaultXmlPrettyPrinter();
    protected final JacksonXmlModule _xmlModule;

    public XmlMapper() {
        this(new XmlFactory());
    }

    public XmlMapper(XMLInputFactory inputF, XMLOutputFactory outF) {
        this(new XmlFactory(inputF, outF));
    }

    public XmlMapper(XMLInputFactory inputF) {
        this(new XmlFactory(inputF));
    }

    public XmlMapper(XmlFactory xmlFactory) {
        this(xmlFactory, DEFAULT_XML_MODULE);
    }

    public XmlMapper(JacksonXmlModule module) {
        this(new XmlFactory(), module);
    }

    public XmlMapper(XmlFactory xmlFactory, JacksonXmlModule module) {
        super(xmlFactory, new XmlSerializerProvider(new XmlRootNameLookup()), null);
        this._xmlModule = module;
        if (module != null) {
            this.registerModule(module);
        }
        this._serializationConfig = this._serializationConfig.withDefaultPrettyPrinter(DEFAULT_XML_PRETTY_PRINTER);
    }

    @Override
    public XmlMapper copy() {
        this._checkInvalidCopy(XmlMapper.class);
        return new XmlMapper((XmlFactory)this._jsonFactory.copy(), this._xmlModule);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    protected void setXMLTextElementName(String name) {
        ((XmlFactory)this._jsonFactory).setXMLTextElementName(name);
    }

    @Override
    @Deprecated
    public XmlFactory getJsonFactory() {
        return (XmlFactory)this._jsonFactory;
    }

    @Override
    public XmlFactory getFactory() {
        return (XmlFactory)this._jsonFactory;
    }

    public ObjectMapper configure(ToXmlGenerator.Feature f, boolean state) {
        ((XmlFactory)this._jsonFactory).configure(f, state);
        return this;
    }

    public ObjectMapper configure(FromXmlParser.Feature f, boolean state) {
        ((XmlFactory)this._jsonFactory).configure(f, state);
        return this;
    }

    public ObjectMapper enable(ToXmlGenerator.Feature f) {
        ((XmlFactory)this._jsonFactory).enable(f);
        return this;
    }

    public ObjectMapper enable(FromXmlParser.Feature f) {
        ((XmlFactory)this._jsonFactory).enable(f);
        return this;
    }

    public ObjectMapper disable(ToXmlGenerator.Feature f) {
        ((XmlFactory)this._jsonFactory).disable(f);
        return this;
    }

    public ObjectMapper disable(FromXmlParser.Feature f) {
        ((XmlFactory)this._jsonFactory).disable(f);
        return this;
    }

    public <T> T readValue(XMLStreamReader r, Class<T> valueType) throws IOException {
        return this.readValue(r, this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(XMLStreamReader r, TypeReference<T> valueTypeRef) throws IOException {
        return this.readValue(r, this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(XMLStreamReader r, JavaType valueType) throws IOException {
        FromXmlParser p = this.getFactory().createParser(r);
        return super.readValue((JsonParser)p, valueType);
    }

    public void writeValue(XMLStreamWriter w0, Object value) throws IOException {
        ToXmlGenerator g = this.getFactory().createGenerator(w0);
        super.writeValue(g, value);
    }

    @Override
    @Deprecated
    protected PrettyPrinter _defaultPrettyPrinter() {
        return new DefaultXmlPrettyPrinter();
    }
}

