/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DictionaryDesc;
import org.apache.kylin.engine.spark.metadata.cube.PathManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMigrationCLI
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(CubeMigrationCLI.class);
    protected List<Opt> operations;
    protected KylinConfig srcConfig;
    protected KylinConfig dstConfig;
    protected ResourceStore srcStore;
    protected ResourceStore dstStore;
    protected FileSystem hdfsFs;
    protected Configuration conf;
    protected boolean doAclCopy = false;
    protected boolean doOverwrite = false;
    protected boolean doMigrateSegment = true;
    protected String dstProject;
    protected String srcHdfsWorkDir;
    protected String dstHdfsWorkDir;
    private static final String ACL_PREFIX = "/acl/";
    private static final String GLOBAL_DICT_PREFIX = "/dict/global_dict/";

    public static void main(String[] args) throws IOException, InterruptedException {
        CubeMigrationCLI cli = new CubeMigrationCLI();
        if (args.length != 8 && args.length != 9) {
            cli.usage();
            System.exit(1);
        }
        if (args.length == 8) {
            cli.moveCube(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
        } else if (args.length == 9) {
            cli.moveCube(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
        }
    }

    protected void usage() {
        System.out.println("Usage: CubeMigrationCLI srcKylinConfigUri dstKylinConfigUri cubeName projectName copyAclOrNot purgeOrNot overwriteIfExists realExecute migrateSegmentOrNot");
        System.out.println("srcKylinConfigUri: The KylinConfig of the cube\u2019s source \ndstKylinConfigUri: The KylinConfig of the cube\u2019s new home \ncubeName: the name of cube to be migrated. \nprojectName: The target project in the target environment.(Make sure it exist) \ncopyAclOrNot: true or false: whether copy cube ACL to target environment. \npurgeOrNot: true or false: whether purge the cube from src server after the migration. \noverwriteIfExists: overwrite cube if it already exists in the target environment. \nrealExecute: if false, just print the operations to take, if true, do the real migration. \nmigrateSegmentOrNot:(optional) true or false: whether copy segment data to target environment. \n");
    }

    public void moveCube(String srcCfgUri, String dstCfgUri, String cubeName, String projectName, String copyAcl, String purgeAndDisable, String overwriteIfExists, String realExecute) throws IOException, InterruptedException {
        this.moveCube(KylinConfig.createInstanceFromUri(srcCfgUri), KylinConfig.createInstanceFromUri(dstCfgUri), cubeName, projectName, copyAcl, purgeAndDisable, overwriteIfExists, realExecute);
    }

    public void moveCube(KylinConfig srcCfg, KylinConfig dstCfg, String cubeName, String projectName, String copyAcl, String purgeAndDisable, String overwriteIfExists, String realExecute) throws IOException, InterruptedException {
        this.moveCube(srcCfg, dstCfg, cubeName, projectName, Boolean.parseBoolean(copyAcl), Boolean.parseBoolean(purgeAndDisable), Boolean.parseBoolean(overwriteIfExists), Boolean.parseBoolean(realExecute), true);
    }

    public void moveCube(String srcCfgUri, String dstCfgUri, String cubeName, String projectName, String copyAcl, String purgeAndDisable, String overwriteIfExists, String realExecute, String migrateSegment) throws IOException, InterruptedException {
        this.moveCube(KylinConfig.createInstanceFromUri(srcCfgUri), KylinConfig.createInstanceFromUri(dstCfgUri), cubeName, projectName, Boolean.parseBoolean(copyAcl), Boolean.parseBoolean(purgeAndDisable), Boolean.parseBoolean(overwriteIfExists), Boolean.parseBoolean(realExecute), Boolean.parseBoolean(migrateSegment));
    }

    public void moveCube(KylinConfig srcCfg, KylinConfig dstCfg, String cubeName, String projectName, boolean copyAcl, boolean purgeAndDisable, boolean overwriteIfExists, boolean realExecute, boolean migrateSegment) throws IOException, InterruptedException {
        this.doAclCopy = copyAcl;
        this.doOverwrite = overwriteIfExists;
        this.doMigrateSegment = migrateSegment;
        this.srcConfig = srcCfg;
        this.srcStore = ResourceStore.getStore(this.srcConfig);
        this.dstConfig = dstCfg;
        this.dstStore = ResourceStore.getStore(this.dstConfig);
        this.dstProject = projectName;
        this.conf = HadoopUtil.getCurrentConfiguration();
        CubeManager cubeManager = CubeManager.getInstance(this.srcConfig);
        CubeInstance cube = cubeManager.getCube(cubeName);
        this.srcHdfsWorkDir = this.srcConfig.getHdfsWorkingDirectory(cube.getProject());
        this.dstHdfsWorkDir = this.dstConfig.getHdfsWorkingDirectory(this.dstProject);
        logger.info("cube to be moved is : " + cubeName);
        if (migrateSegment) {
            this.checkCubeState(cube);
        }
        this.checkAndGetMetadataUrl();
        this.hdfsFs = HadoopUtil.getWorkingFileSystem();
        this.operations = new ArrayList<Opt>();
        this.copyFilesInMetaStore(cube);
        if (!migrateSegment) {
            this.clearSegments(cubeName);
        }
        this.addCubeAndModelIntoProject(cube, cubeName);
        if (migrateSegment && purgeAndDisable) {
            this.purgeAndDisable(cubeName);
        }
        if (realExecute) {
            this.doOpts();
            this.updateMeta(this.dstConfig, projectName, cubeName, cube.getModel());
        } else {
            this.showOpts();
        }
    }

    protected void checkCubeState(CubeInstance cube) {
        if (cube.getStatus() != RealizationStatusEnum.READY) {
            throw new IllegalStateException("Cannot migrate cube that is not in READY state.");
        }
        for (CubeSegment segment : cube.getSegments()) {
            if (segment.getStatus() == SegmentStatusEnum.READY) continue;
            throw new IllegalStateException("At least one segment is not in READY state");
        }
    }

    protected void checkAndGetMetadataUrl() {
        StorageURL srcMetadataUrl = this.srcConfig.getMetadataUrl();
        StorageURL dstMetadataUrl = this.dstConfig.getMetadataUrl();
        logger.info("src metadata url is " + srcMetadataUrl);
        logger.info("dst metadata url is " + dstMetadataUrl);
    }

    protected void clearSegments(String cubeName) throws IOException {
        this.operations.add(new Opt(OptType.CLEAR_SEGMENTS, new Object[]{cubeName}));
    }

    protected void copyFilesInMetaStore(CubeInstance cube) throws IOException {
        if (this.dstStore.exists(cube.getResourcePath()) && !this.doOverwrite) {
            throw new IllegalStateException("The cube named " + cube.getName() + " already exists on target metadata store. Use overwriteIfExists to overwrite it");
        }
        ArrayList<String> metaItems = new ArrayList<String>();
        ArrayList<String> srcParquetFiles = new ArrayList<String>();
        ArrayList<String> dstParquetFiles = new ArrayList<String>();
        HashSet<String> dictAndSnapshot = new HashSet<String>();
        this.listCubeRelatedResources(cube, metaItems, dictAndSnapshot, srcParquetFiles, dstParquetFiles);
        for (String item : metaItems) {
            this.operations.add(new Opt(OptType.COPY_FILE_IN_META, new Object[]{item}));
        }
        if (this.doMigrateSegment) {
            for (String item : dictAndSnapshot) {
                this.operations.add(new Opt(OptType.COPY_DICT_OR_SNAPSHOT, new Object[]{item, cube.getName()}));
            }
            for (int i = 0; i < srcParquetFiles.size(); ++i) {
                this.operations.add(new Opt(OptType.COPY_PARQUET_FILE, new Object[]{srcParquetFiles.get(i), dstParquetFiles.get(i)}));
            }
        }
    }

    protected void addCubeAndModelIntoProject(CubeInstance srcCube, String cubeName) throws IOException {
        String projectResPath = ProjectInstance.concatResourcePath(this.dstProject);
        if (!this.dstStore.exists(projectResPath)) {
            throw new IllegalStateException("The target project " + this.dstProject + " does not exist");
        }
        this.operations.add(new Opt(OptType.ADD_INTO_PROJECT, new Object[]{srcCube, cubeName, this.dstProject}));
    }

    private void purgeAndDisable(String cubeName) throws IOException {
        this.operations.add(new Opt(OptType.PURGE_AND_DISABLE, new Object[]{cubeName}));
    }

    private List<String> getCompatibleTablePath(Set<TableRef> tableRefs, String project, String rootPath) throws IOException {
        ArrayList<String> toResource = new ArrayList<String>();
        List<String> paths = this.srcStore.collectResourceRecursively(rootPath, ".json");
        HashMap<String, String> tableMap = new HashMap<String, String>();
        for (String string : paths) {
            for (TableRef tableRef : tableRefs) {
                String tableId = tableRef.getTableIdentity();
                if (!string.contains(tableId)) continue;
                String prj = TableDesc.parseResourcePath(string).getProject();
                if (prj == null && tableMap.get(tableId) == null) {
                    tableMap.put(tableRef.getTableIdentity(), string);
                }
                if (prj == null || !prj.contains(project)) continue;
                tableMap.put(tableRef.getTableIdentity(), string);
            }
        }
        for (Map.Entry entry : tableMap.entrySet()) {
            toResource.add((String)entry.getValue());
        }
        return toResource;
    }

    protected void listCubeRelatedResources(CubeInstance cube, List<String> metaResource, Set<String> dictAndSnapshot, List<String> srcParquetFiles, List<String> dstParquetFiles) throws IOException {
        CubeDesc cubeDesc = cube.getDescriptor();
        String prj = cubeDesc.getProject();
        metaResource.add(cube.getResourcePath());
        metaResource.add(cubeDesc.getResourcePath());
        metaResource.add(DataModelDesc.concatResourcePath(cubeDesc.getModelName()));
        Set<TableRef> tblRefs = cubeDesc.getModel().getAllTables();
        metaResource.addAll(this.getCompatibleTablePath(tblRefs, prj, "/table"));
        metaResource.addAll(this.getCompatibleTablePath(tblRefs, prj, "/table_exd"));
        if (this.doMigrateSegment) {
            for (DictionaryDesc dictionaryDesc : cubeDesc.getDictionaries()) {
                String[] columnInfo = dictionaryDesc.getColumnRef().getColumnWithTable().split("\\.");
                String globalDictPath = columnInfo.length == 3 ? cube.getProject() + GLOBAL_DICT_PREFIX + columnInfo[1] + File.separator + columnInfo[2] : cube.getProject() + GLOBAL_DICT_PREFIX + columnInfo[0] + File.separator + columnInfo[1];
                if (globalDictPath == null) continue;
                logger.info("Add " + globalDictPath + " to migrate dict list");
                dictAndSnapshot.add(globalDictPath);
            }
            for (CubeSegment segment : cube.getSegments()) {
                metaResource.add(segment.getStatisticsResourcePath());
                dictAndSnapshot.addAll(segment.getSnapshotPaths());
                srcParquetFiles.add(PathManager.getSegmentParquetStoragePath(this.srcHdfsWorkDir, cube.getName(), segment));
                dstParquetFiles.add(PathManager.getSegmentParquetStoragePath(this.dstHdfsWorkDir, cube.getName(), segment));
                logger.info("Add " + PathManager.getSegmentParquetStoragePath(cube, segment.getName(), segment.getStorageLocationIdentifier()) + " to migrate parquet file list");
            }
        }
        if (this.doAclCopy) {
            metaResource.add(ACL_PREFIX + cube.getUuid());
            metaResource.add(ACL_PREFIX + cube.getModel().getUuid());
        }
    }

    @Override
    protected Options getOptions() {
        Options options = new Options();
        return options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
    }

    protected void addOpt(OptType type, Object[] params) {
        this.operations.add(new Opt(type, params));
    }

    private void showOpts() {
        for (int i = 0; i < this.operations.size(); ++i) {
            this.showOpt(this.operations.get(i));
        }
    }

    private void showOpt(Opt opt) {
        logger.info("Operation: " + opt.toString());
    }

    protected void doOpts() throws IOException, InterruptedException {
        try {
            for (int index = 0; index < this.operations.size(); ++index) {
                logger.info("Operation index :" + index);
                this.doOpt(this.operations.get(index));
            }
        }
        catch (Exception e) {
            logger.error("error met", e);
            logger.info("Try undoing previous changes");
            for (int i = index; i >= 0; --i) {
                try {
                    this.undo(this.operations.get(i));
                    continue;
                }
                catch (Exception ee) {
                    logger.error("error met ", e);
                    logger.info("Continue undoing...");
                }
            }
            throw new RuntimeException("Cube moving failed");
        }
    }

    private void doOpt(Opt opt) throws IOException, InterruptedException {
        logger.info("Executing operation: " + opt.toString());
        switch (opt.type) {
            case COPY_FILE_IN_META: {
                DataModelDesc dataModelDesc;
                String item = (String)opt.params[0];
                RawResource res = this.srcStore.getResource(item);
                if (res == null) {
                    logger.info("Item: {} doesn't exist, ignore it.", (Object)item);
                    break;
                }
                if (item.startsWith("/model_desc") && (dataModelDesc = this.srcStore.getResource(item, DataModelManager.getInstance(this.srcConfig).getDataModelSerializer())) != null && dataModelDesc.getProjectName() != null && !dataModelDesc.getProjectName().equals(this.dstProject)) {
                    dataModelDesc.setProjectName(this.dstProject);
                    this.dstStore.putResource(item, dataModelDesc, res.lastModified(), DataModelManager.getInstance(this.srcConfig).getDataModelSerializer());
                    logger.info("Item " + item + " is copied.");
                    break;
                }
                this.dstStore.putResource(this.renameTableWithinProject(item), res.content(), res.lastModified());
                res.content().close();
                logger.info("Item " + item + " is copied");
                break;
            }
            case COPY_DICT_OR_SNAPSHOT: {
                String item = (String)opt.params[0];
                String itemPath = item.substring(item.substring(0, item.indexOf("/")).length() + 1);
                Path srcPath = new Path(this.srcHdfsWorkDir + itemPath);
                Path dstPath = new Path(this.dstHdfsWorkDir + itemPath);
                if (this.hdfsFs.exists(srcPath)) {
                    FileUtil.copy((FileSystem)this.hdfsFs, (Path)srcPath, (FileSystem)this.hdfsFs, (Path)dstPath, (boolean)false, (boolean)true, (Configuration)this.conf);
                    logger.info("Copy " + srcPath + " to " + dstPath);
                    break;
                }
                logger.info("Dict or snapshot " + srcPath + " is not exists, ignore it");
                break;
            }
            case COPY_PARQUET_FILE: {
                Path srcPath = new Path((String)opt.params[0]);
                Path dstPath = new Path((String)opt.params[1]);
                if (this.hdfsFs.exists(srcPath)) {
                    FileUtil.copy((FileSystem)this.hdfsFs, (Path)srcPath, (FileSystem)this.hdfsFs, (Path)dstPath, (boolean)false, (boolean)true, (Configuration)this.conf);
                    logger.info("Copy " + srcPath + " to " + dstPath);
                    break;
                }
                logger.info("Parquet file " + srcPath + " is not exists, ignore it");
                break;
            }
            case ADD_INTO_PROJECT: {
                CubeInstance srcCube = (CubeInstance)opt.params[0];
                String cubeName = (String)opt.params[1];
                String projectName = (String)opt.params[2];
                String modelName = srcCube.getDescriptor().getModelName();
                String projectResPath = ProjectInstance.concatResourcePath(projectName);
                JsonSerializer<ProjectInstance> projectSerializer = new JsonSerializer<ProjectInstance>(ProjectInstance.class);
                ProjectInstance project = this.dstStore.getResource(projectResPath, projectSerializer);
                for (TableRef tableRef : srcCube.getModel().getAllTables()) {
                    project.addTable(tableRef.getTableIdentity());
                }
                if (!project.getModels().contains(modelName)) {
                    project.addModel(modelName);
                }
                project.removeRealization(RealizationType.CUBE, cubeName);
                project.addRealizationEntry(RealizationType.CUBE, cubeName);
                this.dstStore.checkAndPutResource(projectResPath, project, projectSerializer);
                logger.info("Project instance for " + projectName + " is corrected");
                break;
            }
            case CLEAR_SEGMENTS: {
                String cubeName = (String)opt.params[0];
                String cubeInstancePath = CubeInstance.concatResourcePath(cubeName);
                JsonSerializer<CubeInstance> cubeInstanceSerializer = new JsonSerializer<CubeInstance>(CubeInstance.class);
                CubeInstance cubeInstance = this.dstStore.getResource(cubeInstancePath, cubeInstanceSerializer);
                cubeInstance.getSegments().clear();
                cubeInstance.clearCuboids();
                cubeInstance.setCreateTimeUTC(System.currentTimeMillis());
                cubeInstance.setStatus(RealizationStatusEnum.DISABLED);
                this.dstStore.checkAndPutResource(cubeInstancePath, cubeInstance, cubeInstanceSerializer);
                logger.info("Cleared segments for " + cubeName + ", since segments has not been copied");
                break;
            }
            case PURGE_AND_DISABLE: {
                String cubeName = (String)opt.params[0];
                String cubeResPath = CubeInstance.concatResourcePath(cubeName);
                JsonSerializer<CubeInstance> cubeSerializer = new JsonSerializer<CubeInstance>(CubeInstance.class);
                CubeInstance cube = this.srcStore.getResource(cubeResPath, cubeSerializer);
                cube.getSegments().clear();
                cube.setStatus(RealizationStatusEnum.DISABLED);
                this.srcStore.checkAndPutResource(cubeResPath, cube, cubeSerializer);
                logger.info("Cube " + cubeName + " is purged and disabled in " + this.srcConfig.getMetadataUrl());
                break;
            }
        }
    }

    private void undo(Opt opt) throws IOException, InterruptedException {
        logger.info("Undo operation: " + opt.toString());
        switch (opt.type) {
            case COPY_FILE_IN_META: {
                logger.info("Undo for COPY_FILE_IN_META is ignored");
                String item = (String)opt.params[0];
                if (!item.startsWith(ACL_PREFIX) || !this.doAclCopy) break;
                logger.info("Remove acl record");
                this.dstStore.deleteResource(item);
                break;
            }
            case COPY_DICT_OR_SNAPSHOT: {
                logger.info("Undo for COPY_DICT_OR_SNAPSHOT is ignored");
                break;
            }
            case ADD_INTO_PROJECT: {
                logger.info("Undo for ADD_INTO_PROJECT is ignored");
                break;
            }
            case PURGE_AND_DISABLE: {
                logger.info("Undo for PURGE_AND_DISABLE is not supported");
                break;
            }
            case COPY_PARQUET_FILE: {
                logger.info("Undo for COPY_PARQUET_FILE is ignored");
                break;
            }
        }
    }

    private String renameTableWithinProject(String srcItem) {
        if (this.dstProject != null && srcItem.startsWith("/table")) {
            String tableIdentity = TableDesc.parseResourcePath(srcItem).getTable();
            if (srcItem.contains("/table_exd")) {
                return TableExtDesc.concatResourcePath(tableIdentity, this.dstProject);
            }
            return "/table/" + tableIdentity + "--" + this.dstProject + ".json";
        }
        return srcItem;
    }

    private void updateMeta(KylinConfig config, String projectName, String cubeName, DataModelDesc model) {
        String[] nodes = config.getRestServers();
        HashMap<String, String> tableToProjects = new HashMap<String, String>();
        for (TableRef tableRef : model.getAllTables()) {
            tableToProjects.put(tableRef.getTableIdentity(), tableRef.getTableDesc().getProject());
        }
        for (String node : nodes) {
            RestClient restClient = new RestClient(node);
            try {
                logger.info("update meta cache for " + node);
                restClient.clearCacheForCubeMigration(cubeName, projectName, model.getName(), tableToProjects);
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
    }

    private class Opt {
        private OptType type;
        private Object[] params;

        private Opt(OptType type, Object[] params) {
            this.type = type;
            this.params = params;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.type).append(":");
            for (Object s : this.params) {
                sb.append(s).append(", ");
            }
            return sb.toString();
        }
    }

    protected static enum OptType {
        COPY_FILE_IN_META,
        COPY_DICT_OR_SNAPSHOT,
        COPY_PARQUET_FILE,
        ADD_INTO_PROJECT,
        PURGE_AND_DISABLE,
        CLEAR_SEGMENTS;

    }
}

