/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.gtrecord;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.FuzzyValueCombination;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.gridtable.CubeGridTable;
import org.apache.kylin.cube.gridtable.CuboidToGridTableMapping;
import org.apache.kylin.cube.gridtable.RecordComparators;
import org.apache.kylin.cube.gridtable.ScanRangePlannerBase;
import org.apache.kylin.cube.kv.CubeDimEncMap;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRange;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.GTScanRequestBuilder;
import org.apache.kylin.gridtable.GTUtil;
import org.apache.kylin.gridtable.IGTComparator;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.DynamicFunctionDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.storage.StorageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeScanRangePlanner
extends ScanRangePlannerBase {
    private static final Logger logger = LoggerFactory.getLogger(CubeScanRangePlanner.class);
    protected int maxScanRanges;
    protected int maxFuzzyKeysPerSplit;
    protected int maxFuzzyKeys;
    protected CubeSegment cubeSegment;
    protected CubeDesc cubeDesc;
    protected Cuboid cuboid;
    protected StorageContext context;

    public CubeScanRangePlanner(CubeSegment cubeSegment, Cuboid cuboid, TupleFilter filter2, Set<TblColRef> dimensions, Set<TblColRef> groupByDims, List<TblColRef> dynGroupsDims, List<TupleExpression> dynGroupExprs, Collection<FunctionDesc> metrics, List<DynamicFunctionDesc> dynFuncs, TupleFilter havingFilter, StorageContext context) {
        this.context = context;
        this.maxScanRanges = cubeSegment.getConfig().getQueryStorageVisitScanRangeMax();
        this.maxFuzzyKeysPerSplit = cubeSegment.getConfig().getQueryScanFuzzyKeyMax();
        this.maxFuzzyKeys = this.maxFuzzyKeysPerSplit * cubeSegment.getConfig().getQueryScanFuzzyKeySplitMax();
        this.cubeSegment = cubeSegment;
        this.cubeDesc = cubeSegment.getCubeDesc();
        this.cuboid = cuboid;
        CuboidToGridTableMapping mapping = context.getMapping();
        this.gtInfo = CubeGridTable.newGTInfo(cuboid, new CubeDimEncMap(cubeSegment), mapping);
        IGTComparator comp = this.gtInfo.getCodeSystem().getComparator();
        this.rangeStartComparator = RecordComparators.getRangeStartComparator(comp);
        this.rangeEndComparator = RecordComparators.getRangeEndComparator(comp);
        this.rangeStartEndComparator = RecordComparators.getRangeStartEndComparator(comp);
        HashSet<TblColRef> groupByPushDown = Sets.newHashSet(groupByDims);
        groupByPushDown.addAll(dynGroupsDims);
        this.gtFilter = GTUtil.convertFilterColumnsAndConstants(filter2, this.gtInfo, mapping.getDim2gt(), groupByPushDown);
        this.havingFilter = havingFilter;
        this.gtDimensions = mapping.makeGridTableColumns(dimensions);
        this.gtAggrGroups = mapping.makeGridTableColumns(this.replaceDerivedColumns(groupByPushDown, cubeSegment.getCubeDesc()));
        this.gtAggrMetrics = mapping.makeGridTableColumns(metrics);
        this.gtAggrFuncs = mapping.makeAggrFuncs(metrics);
        BitSet tmpGtDynCols = new BitSet();
        this.tupleExpressionMap = Maps.newHashMap();
        for (int i = 0; i < dynGroupsDims.size(); ++i) {
            int c = mapping.getIndexOf(dynGroupsDims.get(i));
            tmpGtDynCols.set(c);
            TupleExpression tupleExpr = GTUtil.convertFilterColumnsAndConstants(dynGroupExprs.get(i), this.gtInfo, mapping, groupByPushDown);
            this.tupleExpressionMap.put(c, tupleExpr);
        }
        HashSet<FunctionDesc> tmpRtAggrMetrics = Sets.newHashSet();
        for (DynamicFunctionDesc dynFunc : dynFuncs) {
            tmpRtAggrMetrics.addAll(dynFunc.getRuntimeFuncs());
            int c = mapping.getIndexOf(dynFunc);
            tmpGtDynCols.set(c);
            this.tupleExpressionMap.put(c, GTUtil.convertFilterColumnsAndConstants(dynFunc.getTupleExpression(), this.gtInfo, mapping, dynFunc.getRuntimeFuncMap(), groupByPushDown));
        }
        this.gtDynColumns = new ImmutableBitSet(tmpGtDynCols);
        this.gtRtAggrMetrics = mapping.makeGridTableColumns((Collection<? extends FunctionDesc>)tmpRtAggrMetrics);
        this.gtAggrGroups = mapping.makeGridTableColumns(this.replaceDerivedColumns(groupByPushDown, cubeSegment.getCubeDesc()));
        this.gtAggrMetrics = mapping.makeGridTableColumns(metrics);
        this.gtAggrFuncs = mapping.makeAggrFuncs(metrics);
    }

    public CubeScanRangePlanner(GTInfo info, TblColRef gtPartitionCol, TupleFilter gtFilter) {
        this.maxScanRanges = KylinConfig.getInstanceFromEnv().getQueryStorageVisitScanRangeMax();
        this.maxFuzzyKeysPerSplit = KylinConfig.getInstanceFromEnv().getQueryScanFuzzyKeyMax();
        this.maxFuzzyKeys = this.maxFuzzyKeysPerSplit * KylinConfig.getInstanceFromEnv().getQueryScanFuzzyKeySplitMax();
        this.gtInfo = info;
        IGTComparator comp = this.gtInfo.getCodeSystem().getComparator();
        this.rangeStartComparator = RecordComparators.getRangeStartComparator(comp);
        this.rangeEndComparator = RecordComparators.getRangeEndComparator(comp);
        this.rangeStartEndComparator = RecordComparators.getRangeStartEndComparator(comp);
        this.gtFilter = gtFilter;
    }

    @Override
    public GTScanRequest planScanRequest() {
        List<GTScanRange> scanRanges = this.planScanRanges();
        GTScanRequest scanRequest = scanRanges != null && !scanRanges.isEmpty() ? new GTScanRequestBuilder().setInfo(this.gtInfo).setRanges(scanRanges).setDimensions(this.gtDimensions).setAggrGroupBy(this.gtAggrGroups).setAggrMetrics(this.gtAggrMetrics).setAggrMetricsFuncs(this.gtAggrFuncs).setFilterPushDown(this.gtFilter).setRtAggrMetrics(this.gtRtAggrMetrics).setDynamicColumns(this.gtDynColumns).setExprsPushDown(this.tupleExpressionMap).setAllowStorageAggregation(this.context.isNeedStorageAggregation()).setAggCacheMemThreshold(this.cubeSegment.getConfig().getQueryCoprocessorMemGB()).setStoragePushDownLimit(this.context.getFinalPushDownLimit()).setStorageLimitLevel(this.context.getStorageLimitLevel()).setHavingFilterPushDown(this.havingFilter).createGTScanRequest() : null;
        return scanRequest;
    }

    public List<GTScanRange> planScanRanges() {
        TupleFilter flatFilter = this.flattenToOrAndFilter(this.gtFilter);
        List<Collection<ScanRangePlannerBase.ColumnRange>> orAndDimRanges = this.translateToOrAndDimRanges(flatFilter);
        ArrayList<GTScanRange> scanRanges = Lists.newArrayListWithCapacity(orAndDimRanges.size());
        for (Collection<ScanRangePlannerBase.ColumnRange> andDimRanges : orAndDimRanges) {
            GTScanRange scanRange = this.newScanRange(andDimRanges);
            if (scanRange == null) continue;
            scanRanges.add(scanRange);
        }
        List<GTScanRange> mergedRanges = this.mergeOverlapRanges(scanRanges);
        mergedRanges = this.splitFuzzyKeys(mergedRanges);
        mergedRanges = this.mergeTooManyRanges(mergedRanges, this.maxScanRanges);
        return mergedRanges;
    }

    private Set<TblColRef> replaceDerivedColumns(Set<TblColRef> input, CubeDesc cubeDesc) {
        HashSet<TblColRef> ret = Sets.newHashSet();
        for (TblColRef col : input) {
            if (cubeDesc.hasHostColumn(col)) {
                for (TblColRef host : cubeDesc.getHostInfo((TblColRef)col).columns) {
                    ret.add(host);
                }
                continue;
            }
            ret.add(col);
        }
        return ret;
    }

    protected GTScanRange newScanRange(Collection<ScanRangePlannerBase.ColumnRange> andDimRanges) {
        GTRecord pkStart = new GTRecord(this.gtInfo);
        GTRecord pkEnd = new GTRecord(this.gtInfo);
        HashMap<Integer, Set<ByteArray>> fuzzyValues = Maps.newHashMap();
        for (ScanRangePlannerBase.ColumnRange range : andDimRanges) {
            int col = range.column.getColumnDesc().getZeroBasedIndex();
            if (!this.gtInfo.getPrimaryKey().get(col)) continue;
            pkStart.set(col, range.begin);
            pkEnd.set(col, range.end);
            if (range.valueSet == null || range.valueSet.isEmpty()) continue;
            fuzzyValues.put(col, range.valueSet);
        }
        List<GTRecord> fuzzyKeys = this.buildFuzzyKeys(fuzzyValues);
        return new GTScanRange(pkStart, pkEnd, fuzzyKeys);
    }

    private List<GTRecord> buildFuzzyKeys(Map<Integer, Set<ByteArray>> fuzzyValueSet) {
        ArrayList<GTRecord> result = Lists.newArrayList();
        if (fuzzyValueSet.isEmpty()) {
            return result;
        }
        if (BackdoorToggles.getDisableFuzzyKey()) {
            logger.info("The execution of this query will not use fuzzy key");
            return result;
        }
        List<Map<Integer, ByteArray>> fuzzyValueCombinations = FuzzyValueCombination.calculate(fuzzyValueSet, this.maxFuzzyKeys);
        for (Map<Integer, ByteArray> fuzzyValue : fuzzyValueCombinations) {
            GTRecord fuzzy = new GTRecord(this.gtInfo);
            for (Map.Entry<Integer, ByteArray> entry : fuzzyValue.entrySet()) {
                fuzzy.set(entry.getKey(), entry.getValue());
            }
            result.add(fuzzy);
        }
        return result;
    }

    protected List<GTScanRange> mergeOverlapRanges(List<GTScanRange> ranges) {
        if (ranges.size() <= 1) {
            return ranges;
        }
        Collections.sort(ranges, new Comparator<GTScanRange>(){

            @Override
            public int compare(GTScanRange a, GTScanRange b) {
                return CubeScanRangePlanner.this.rangeStartComparator.compare(a.pkStart, b.pkStart);
            }
        });
        ArrayList<GTScanRange> mergedRanges = new ArrayList<GTScanRange>();
        int mergeBeginIndex = 0;
        GTRecord mergeEnd = ranges.get((int)0).pkEnd;
        for (int index = 1; index < ranges.size(); ++index) {
            GTScanRange range = ranges.get(index);
            if (this.rangeStartEndComparator.compare(range.pkStart, mergeEnd) <= 0) {
                mergeEnd = this.rangeEndComparator.max(mergeEnd, range.pkEnd);
                continue;
            }
            GTScanRange mergedRange = this.mergeKeyRange(ranges.subList(mergeBeginIndex, index));
            mergedRanges.add(mergedRange);
            mergeBeginIndex = index;
            mergeEnd = range.pkEnd;
        }
        GTScanRange mergedRange = this.mergeKeyRange(ranges.subList(mergeBeginIndex, ranges.size()));
        mergedRanges.add(mergedRange);
        return mergedRanges;
    }

    private GTScanRange mergeKeyRange(List<GTScanRange> ranges) {
        GTScanRange first = ranges.get(0);
        if (ranges.size() == 1) {
            return first;
        }
        GTRecord start = first.pkStart;
        GTRecord end = first.pkEnd;
        LinkedHashSet<GTRecord> newFuzzyKeys = Sets.newLinkedHashSet();
        boolean hasNonFuzzyRange = false;
        for (GTScanRange range : ranges) {
            hasNonFuzzyRange = hasNonFuzzyRange || range.fuzzyKeys.isEmpty();
            newFuzzyKeys.addAll(range.fuzzyKeys);
            end = this.rangeEndComparator.max(end, range.pkEnd);
        }
        if (hasNonFuzzyRange || newFuzzyKeys.size() > this.maxFuzzyKeys) {
            if (newFuzzyKeys.size() > this.maxFuzzyKeys) {
                logger.debug("too many FuzzyKeys,  clean it!");
            }
            newFuzzyKeys.clear();
        }
        return new GTScanRange(start, end, Lists.newArrayList(newFuzzyKeys));
    }

    protected List<GTScanRange> mergeTooManyRanges(List<GTScanRange> ranges, int maxRanges) {
        if (ranges.size() <= maxRanges) {
            return ranges;
        }
        List<GTScanRange> result = new ArrayList<GTScanRange>(1);
        GTScanRange mergedRange = this.mergeKeyRange(ranges);
        result.add(mergedRange);
        result = this.splitFuzzyKeys(result);
        return result;
    }

    private List<GTScanRange> splitFuzzyKeys(List<GTScanRange> mergedRanges) {
        ArrayList<GTScanRange> result = Lists.newArrayList();
        for (GTScanRange range : mergedRanges) {
            if (range.fuzzyKeys.size() > this.maxFuzzyKeysPerSplit && range.fuzzyKeys.size() <= this.maxFuzzyKeys) {
                List<GTRecord> fuzzyKeys = range.fuzzyKeys;
                Collections.sort(fuzzyKeys);
                int nSplit = (fuzzyKeys.size() - 1) / this.maxFuzzyKeysPerSplit + 1;
                int nFuzzyKeysPerSplit = fuzzyKeys.size() / nSplit;
                int startIndex = 0;
                for (int i = 1; i <= nSplit; ++i) {
                    int endIndex = i == nSplit ? fuzzyKeys.size() : i * nFuzzyKeysPerSplit;
                    List<GTRecord> subFuzzyKeys = fuzzyKeys.subList(startIndex, endIndex);
                    result.add(new GTScanRange(range.pkStart, range.pkEnd, subFuzzyKeys));
                    startIndex = endIndex;
                }
                logger.debug(String.format(Locale.ROOT, "large FuzzyKeys split size : %d", result.size()));
                continue;
            }
            result.add(range);
        }
        return result;
    }

    public int getMaxScanRanges() {
        return this.maxScanRanges;
    }

    public void setMaxScanRanges(int maxScanRanges) {
        this.maxScanRanges = maxScanRanges;
    }
}

