/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.cache;

import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Range;

public class TsConditionExtractor {
    public static Range<Long> extractTsCondition(TblColRef tsColRef, TupleFilter rootFilter) {
        return TsConditionExtractor.extractTsConditionInternal(rootFilter, tsColRef);
    }

    private static Range<Long> extractTsConditionInternal(TupleFilter filter2, TblColRef colRef) {
        if (filter2 == null) {
            return Range.all();
        }
        if (filter2 instanceof LogicalTupleFilter) {
            if (filter2.getOperator() == TupleFilter.FilterOperatorEnum.AND) {
                Range<Long> ret = Range.all();
                for (TupleFilter tupleFilter : filter2.getChildren()) {
                    Range<Long> childRange = TsConditionExtractor.extractTsConditionInternal(tupleFilter, colRef);
                    if (childRange != null) {
                        if (ret.isConnected(childRange) && !ret.intersection(childRange).isEmpty()) {
                            ret = ret.intersection(childRange);
                            continue;
                        }
                        return null;
                    }
                    return null;
                }
                return ret.isEmpty() ? null : ret;
            }
            return Range.all();
        }
        if (filter2 instanceof CompareTupleFilter) {
            CompareTupleFilter compareTupleFilter = (CompareTupleFilter)filter2;
            if (compareTupleFilter.getColumn() == null) {
                return Range.all();
            }
            if (compareTupleFilter.getColumn().equals(colRef)) {
                Object firstValue = compareTupleFilter.getFirstValue();
                switch (compareTupleFilter.getOperator()) {
                    case EQ: {
                        long l = DateFormat.stringToMillis((String)firstValue);
                        return Range.closed(l, l);
                    }
                    case LT: {
                        long l = DateFormat.stringToMillis((String)firstValue);
                        return Range.lessThan(l);
                    }
                    case LTE: {
                        long l = DateFormat.stringToMillis((String)firstValue);
                        return Range.atMost(l);
                    }
                    case GT: {
                        long l = DateFormat.stringToMillis((String)firstValue);
                        return Range.greaterThan(l);
                    }
                    case GTE: {
                        long l = DateFormat.stringToMillis((String)firstValue);
                        return Range.atLeast(l);
                    }
                    case NEQ: 
                    case IN: {
                        break;
                    }
                }
            }
        }
        return Range.all();
    }
}

