/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.threadlocal.InternalThreadLocal;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.ImplementationSwitch;
import org.apache.kylin.metadata.model.IStorageAware;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.storage.IStorage;
import org.apache.kylin.storage.IStorageQuery;

public class StorageFactory {
    private static InternalThreadLocal<ImplementationSwitch<IStorage>> storages = new InternalThreadLocal();
    private static IStorage configuredUseLocalStorage;

    public static IStorage storage(IStorageAware aware) {
        if (configuredUseLocalStorage != null) {
            return configuredUseLocalStorage;
        }
        ImplementationSwitch<IStorage> current = storages.get();
        if (storages.get() == null) {
            current = new ImplementationSwitch<IStorage>(KylinConfig.getInstanceFromEnv().getStorageEngines(), IStorage.class);
            storages.set(current);
        }
        return current.get(aware.getStorageType());
    }

    public static void clearCache() {
        storages.remove();
    }

    public static IStorageQuery createQuery(IRealization realization) {
        return StorageFactory.storage(realization).createQuery(realization);
    }

    public static <T> T createEngineAdapter(IStorageAware aware, Class<T> engineInterface) {
        return StorageFactory.storage(aware).adaptToBuildEngine(engineInterface);
    }

    static {
        String localStorageImpl = KylinConfig.getInstanceFromEnv().getLocalStorageImpl();
        if (localStorageImpl != null) {
            configuredUseLocalStorage = (IStorage)ClassUtil.newInstance(localStorageImpl);
        }
    }
}

