/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateFlatHiveTableStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(CreateFlatHiveTableStep.class);
    protected final PatternedLogger stepLogger = new PatternedLogger(logger);
    private static final Pattern HDFS_LOCATION = Pattern.compile("LOCATION '(.*)';");

    protected void createFlatHiveTable(KylinConfig config) throws IOException {
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder(this.getName());
        hiveCmdBuilder.overwriteHiveProps(config.getHiveConfigOverride());
        hiveCmdBuilder.addStatement(this.getInitStatement());
        hiveCmdBuilder.addStatement(this.getCreateTableStatement());
        String cmd = hiveCmdBuilder.toString();
        this.stepLogger.log("Create and distribute table, cmd: ");
        this.stepLogger.log(cmd);
        Pair<Integer, String> response = config.getCliCommandExecutor().execute(cmd, this.stepLogger, null);
        Map<String, String> info = this.stepLogger.getInfo();
        Matcher matcher = HDFS_LOCATION.matcher(cmd);
        if (matcher.find()) {
            String hiveFlatTableHdfsUrl = matcher.group(1);
            long size = this.getFileSize(hiveFlatTableHdfsUrl);
            info.put("hdfs_bytes_written", "" + size);
            logger.info("HDFS_Bytes_Writen: " + size);
        }
        this.getManager().addJobInfo(this.getId(), info);
        if (response.getFirst() != 0) {
            throw new RuntimeException("Failed to create flat hive table, error code " + response.getFirst());
        }
    }

    private long getFileSize(String hdfsUrl) throws IOException {
        Configuration configuration = new Configuration();
        Path path = new Path(hdfsUrl);
        FileSystem fs = path.getFileSystem(configuration);
        ContentSummary contentSummary = fs.getContentSummary(path);
        long length = contentSummary.getLength();
        return length;
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        this.stepLogger.setILogListener((infoKey, info) -> {
            if ("yarn_application_id".equals(infoKey) || "yarn_application_tracking_url".equals(infoKey)) {
                this.getManager().addJobInfo(this.getId(), info);
            }
        });
        KylinConfig config = this.getCubeSpecificConfig();
        try {
            this.createFlatHiveTable(config);
            return new ExecuteResult(ExecuteResult.State.SUCCEED, this.stepLogger.getBufferedLog());
        }
        catch (Exception e) {
            logger.error("job:" + this.getId() + " execute finished with exception", e);
            return new ExecuteResult(ExecuteResult.State.ERROR, this.stepLogger.getBufferedLog(), e);
        }
    }

    public void setInitStatement(String sql2) {
        this.setParam("HiveInit", sql2);
    }

    public String getInitStatement() {
        return this.getParam("HiveInit");
    }

    public void setCreateTableStatement(String sql2) {
        this.setParam("HiveRedistributeData", sql2);
    }

    public String getCreateTableStatement() {
        return this.getParam("HiveRedistributeData");
    }
}

