/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.conv;

import java.sql.SQLException;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.kylin.sdk.datasource.framework.conv.ConvMaster;
import org.apache.kylin.sdk.datasource.framework.conv.ConvSqlWriter;
import org.apache.kylin.sdk.datasource.framework.conv.SqlNodeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlConverter {
    private static final Logger logger = LoggerFactory.getLogger(SqlConverter.class);
    private final ConvSqlWriter sqlWriter;
    private final IConfigurer configurer;
    private final SqlNodeConverter sqlNodeConverter;

    public SqlConverter(IConfigurer configurer, ConvMaster convMaster) throws SQLException {
        this.sqlNodeConverter = new SqlNodeConverter(convMaster);
        this.configurer = configurer;
        this.sqlWriter = new ConvSqlWriter(configurer);
        this.sqlWriter.setQuoteAllIdentifiers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertSql(String orig) {
        String converted = orig.replaceAll("`", "\"");
        if (!this.configurer.skipHandleDefault()) {
            String escapedDefault = SqlDialect.CALCITE.quoteIdentifier(this.configurer.useUppercaseDefault() ? "DEFAULT" : "default");
            converted = converted.replaceAll("(?i)default\\.", escapedDefault + ".");
            converted = converted.replaceAll("\"(?i)default\"\\.", escapedDefault + ".");
        }
        if (!this.configurer.skipDefaultConvert()) {
            try {
                SqlNode sqlNode = SqlParser.create((String)converted).parseQuery();
                sqlNode = (SqlNode)sqlNode.accept((SqlVisitor)this.sqlNodeConverter);
                converted = this.sqlWriter.format(sqlNode);
            }
            catch (Throwable e) {
                logger.error("Failed to default convert sql, will use the input: {}", (Object)orig, (Object)e);
            }
            finally {
                this.sqlWriter.reset();
            }
        }
        converted = this.configurer.fixAfterDefaultConvert(converted);
        return converted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertColumn(String column, String originQuote) {
        String converted = column.replace(originQuote, "");
        try {
            SqlNode sqlNode = SqlParser.create((String)converted).parseExpression();
            sqlNode = (SqlNode)sqlNode.accept((SqlVisitor)this.sqlNodeConverter);
            converted = this.sqlWriter.format(sqlNode);
        }
        catch (Throwable e) {
            logger.error("Failed to default convert Column, will use the input: {}", (Object)column, (Object)e);
        }
        finally {
            this.sqlWriter.reset();
        }
        return converted;
    }

    public IConfigurer getConfigurer() {
        return this.configurer;
    }

    public static interface IConfigurer {
        public boolean skipDefaultConvert();

        public boolean skipHandleDefault();

        public boolean useUppercaseDefault();

        public String fixAfterDefaultConvert(String var1);

        public SqlDialect getSqlDialect();

        public boolean allowNoOffset();

        public boolean allowFetchNoRows();

        public boolean allowNoOrderByWithFetch();

        public String getPagingType();

        public boolean isCaseSensitive();

        public boolean enableCache();

        public boolean enableQuote();

        public String fixIdentifierCaseSensitve(String var1);

        public String getTransactionIsolationLevel();
    }
}

