/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.sdk.datasource.adaptor.AdaptorConfig;
import org.apache.kylin.sdk.datasource.adaptor.DefaultAdaptor;
import org.apache.kylin.sdk.datasource.adaptor.MysqlAdaptor;
import org.apache.kylin.sdk.datasource.adaptor.PostgresqlAdaptor;
import org.apache.kylin.sdk.datasource.framework.AdaptorFactory;
import org.apache.kylin.sdk.datasource.framework.JdbcConnector;

public class SourceConnectorFactory {
    public static JdbcConnector getJdbcConnector(KylinConfig config) {
        String jdbcUrl = config.getJdbcSourceConnectionUrl();
        String jdbcDriver = config.getJdbcSourceDriver();
        String jdbcUser = config.getJdbcSourceUser();
        String jdbcPass = config.getJdbcSourcePass();
        String adaptorClazz = config.getJdbcSourceAdaptor();
        AdaptorConfig jdbcConf = new AdaptorConfig(jdbcUrl, jdbcDriver, jdbcUser, jdbcPass);
        jdbcConf.poolMaxIdle = config.getPoolMaxIdle(null);
        jdbcConf.poolMinIdle = config.getPoolMinIdle(null);
        jdbcConf.poolMaxTotal = config.getPoolMaxTotal(null);
        jdbcConf.datasourceId = config.getJdbcSourceDialect();
        if (adaptorClazz == null) {
            adaptorClazz = SourceConnectorFactory.decideAdaptorClassName(jdbcConf.datasourceId);
        }
        try {
            return new JdbcConnector(AdaptorFactory.createJdbcAdaptor(adaptorClazz, jdbcConf));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get JdbcConnector from env.", e);
        }
    }

    private static String decideAdaptorClassName(String dataSourceId) {
        switch (dataSourceId) {
            case "mysql": {
                return MysqlAdaptor.class.getName();
            }
            case "postgresql": {
                return PostgresqlAdaptor.class.getName();
            }
        }
        return DefaultAdaptor.class.getName();
    }
}

