/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.adaptor;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.sql.rowset.CachedRowSet;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.kylin.sdk.datasource.adaptor.AdaptorConfig;
import org.apache.kylin.sdk.datasource.framework.FixedCachedRowSetImpl;
import org.apache.kylin.sdk.datasource.framework.conv.DefaultConfigurer;
import org.apache.kylin.sdk.datasource.framework.conv.SqlConverter;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDef;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDefProvider;
import org.apache.kylin.shaded.com.google.common.base.Joiner;
import org.apache.kylin.shaded.com.google.common.cache.Cache;
import org.apache.kylin.shaded.com.google.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcAdaptor
implements Closeable {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractJdbcAdaptor.class);
    protected final BasicDataSource dataSource;
    protected final AdaptorConfig config;
    protected final DataSourceDef dataSourceDef;
    protected SqlConverter.IConfigurer configurer;
    protected final Cache<String, List<String>> columnsCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(4096L).build();
    protected final Cache<String, List<String>> databasesCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(4096L).build();
    protected final Cache<String, List<String>> tablesCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(4096L).build();
    private static Joiner joiner = Joiner.on("_");

    protected AbstractJdbcAdaptor(AdaptorConfig config) throws ClassNotFoundException {
        this.config = config;
        this.dataSourceDef = DataSourceDefProvider.getInstance().getById(config.datasourceId);
        this.dataSource = new BasicDataSource();
        Class.forName(config.driver);
        this.dataSource.setDriverClassName(config.driver);
        this.dataSource.setUrl(config.url);
        this.dataSource.setUsername(config.username);
        this.dataSource.setPassword(config.password);
        this.dataSource.setMaxActive(config.poolMaxTotal);
        this.dataSource.setMaxIdle(config.poolMaxIdle);
        this.dataSource.setMinIdle(config.poolMinIdle);
        this.dataSource.setTestOnBorrow(true);
        this.dataSource.setValidationQuery(this.getSourceValidationSql());
        this.dataSource.setRemoveAbandoned(true);
        this.dataSource.setRemoveAbandonedTimeout(300);
        DataSourceDefProvider provider = DataSourceDefProvider.getInstance();
        DataSourceDef jdbcDs = provider.getById(this.getDataSourceId());
        this.configurer = new DefaultConfigurer(this, jdbcDs);
    }

    protected String getSourceValidationSql() {
        if (this.dataSourceDef.getValidationQuery() != null) {
            return this.dataSourceDef.getValidationQuery();
        }
        switch (this.config.driver) {
            case "org.hsqldb.jdbcDriver": {
                return "select 1 from INFORMATION_SCHEMA.SYSTEM_USERS";
            }
            case "oracle.jdbc.driver.OracleDriver": 
            case "oracle.jdbc.OracleDriver": {
                return "select 1 from dual";
            }
            case "com.ibm.db2.jcc.DB2Driver": {
                return "select 1 from sysibm.sysdummy1";
            }
            case "org.postgresql.Driver": {
                return "select version();";
            }
            case "org.apache.derby.jdbc.ClientDriver": {
                return "values 1";
            }
        }
        return "select 1";
    }

    protected CachedRowSet cacheResultSet(ResultSet resultSet) throws SQLException {
        FixedCachedRowSetImpl crs = new FixedCachedRowSetImpl();
        crs.populate(resultSet);
        return crs;
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    protected void close(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.dataSource.close();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String sql2) throws SQLException {
        Statement statement = null;
        Connection connection = this.getConnection();
        try {
            statement = connection.createStatement();
            statement.execute(sql2);
        }
        finally {
            this.close(statement);
            this.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String[] sqls) throws SQLException {
        Statement statement = null;
        Connection connection = this.getConnection();
        try {
            statement = connection.createStatement();
            for (String sql2 : sqls) {
                statement.execute(sql2);
            }
        }
        finally {
            this.close(statement);
            this.close(connection);
        }
    }

    public String getJdbcUrl() {
        return this.dataSource.getUrl();
    }

    public String getJdbcDriver() {
        return this.dataSource.getDriverClassName();
    }

    public String getJdbcUser() {
        return this.dataSource.getUsername();
    }

    public String getJdbcPassword() {
        return this.dataSource.getPassword();
    }

    public String getDataSourceId() {
        return this.config.datasourceId == null ? "default" : this.config.datasourceId;
    }

    public abstract int toKylinTypeId(String var1, int var2);

    public abstract String toKylinTypeName(int var1);

    public abstract String toSourceTypeName(String var1);

    public abstract String fixSql(String var1);

    public abstract String fixIdentifierCaseSensitve(String var1);

    public abstract List<String> listDatabases() throws SQLException;

    public List<String> listDatabasesWithCache() throws SQLException {
        return this.listDatabasesWithCache(false);
    }

    public List<String> listDatabasesWithCache(boolean init2) throws SQLException {
        if (this.configurer.enableCache()) {
            List<String> cachedDatabases;
            String cacheKey = joiner.join(this.config.datasourceId, this.config.url, "databases");
            if (init2 || (cachedDatabases = this.databasesCache.getIfPresent(cacheKey)) == null) {
                cachedDatabases = this.listDatabases();
                this.databasesCache.put(cacheKey, cachedDatabases);
            }
            return cachedDatabases;
        }
        return this.listDatabases();
    }

    public abstract List<String> listTables(String var1) throws SQLException;

    public List<String> listTablesWithCache(String database, boolean init2) throws SQLException {
        if (this.configurer.enableCache()) {
            List<String> cachedTables;
            String cacheKey = joiner.join(this.config.datasourceId, this.config.url, database, "tables");
            if (init2 || (cachedTables = this.tablesCache.getIfPresent(cacheKey)) == null) {
                cachedTables = this.listTables(database);
                this.tablesCache.put(cacheKey, cachedTables);
            }
            return cachedTables;
        }
        return this.listTables(database);
    }

    public List<String> listTablesWithCache(String database) throws SQLException {
        return this.listTablesWithCache(database, false);
    }

    public abstract CachedRowSet getTable(String var1, String var2) throws SQLException;

    public abstract CachedRowSet getTableColumns(String var1, String var2) throws SQLException;

    public abstract String[] buildSqlToCreateSchema(String var1);

    public abstract String[] buildSqlToLoadDataFromLocal(String var1, String var2);

    public abstract String[] buildSqlToCreateTable(String var1, Map<String, String> var2);

    public abstract String[] buildSqlToCreateView(String var1, String var2);

    public abstract List<String> listColumns(String var1, String var2) throws SQLException;

    public List<String> listColumnsWithCache(String database, String tableName) throws SQLException {
        return this.listColumnsWithCache(database, tableName, false);
    }

    public List<String> listColumnsWithCache(String database, String tableName, boolean init2) throws SQLException {
        if (this.configurer.enableCache()) {
            List<String> cachedColumns;
            String cacheKey = joiner.join(this.config.datasourceId, this.config.url, database, tableName, "columns");
            if (init2 || (cachedColumns = this.columnsCache.getIfPresent(cacheKey)) == null) {
                cachedColumns = this.listColumns(database, tableName);
                this.columnsCache.put(cacheKey, cachedColumns);
            }
            return cachedColumns;
        }
        return this.listColumns(database, tableName);
    }

    public boolean isCaseSensitive() {
        return this.configurer.isCaseSensitive();
    }
}

