/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLock;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeBuildTypeEnum;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.BatchOptimizeJobCheckpointBuilder;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.LookupSnapshotBuildJob;
import org.apache.kylin.engine.mr.common.CubeJobLockUtil;
import org.apache.kylin.engine.mr.common.JobInfoConverter;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.spark.job.NSparkCubingJob;
import org.apache.kylin.engine.spark.metadata.cube.source.SourceFactory;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.JobSearchResult;
import org.apache.kylin.job.Scheduler;
import org.apache.kylin.job.SchedulerFactory;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobTimeFilterEnum;
import org.apache.kylin.job.dao.ExecutableOutputPO;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.exception.JobException;
import org.apache.kylin.job.exception.SchedulerException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.CheckpointExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.lock.zookeeper.ZookeeperJobLock;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.msg.Message;
import org.apache.kylin.rest.msg.MsgPicker;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.shaded.com.google.common.base.Function;
import org.apache.kylin.shaded.com.google.common.base.Predicate;
import org.apache.kylin.shaded.com.google.common.base.Predicates;
import org.apache.kylin.shaded.com.google.common.collect.FluentIterable;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.source.ISource;
import org.apache.kylin.source.SourceManager;
import org.apache.kylin.source.SourcePartition;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@EnableAspectJAutoProxy(proxyTargetClass=true)
@Component(value="jobService")
public class JobService
extends BasicService
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(JobService.class);
    @Autowired
    private AclEvaluate aclEvaluate;

    public void afterPropertiesSet() throws Exception {
        String timeZone = this.getConfig().getTimeZone();
        TimeZone tzone = TimeZone.getTimeZone(timeZone);
        TimeZone.setDefault(tzone);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String clusterName = kylinConfig.getClusterName();
        logger.info("starting to initialize an instance in cluster {}", (Object)clusterName);
        final Scheduler scheduler = SchedulerFactory.scheduler(kylinConfig.getSchedulerType());
        scheduler.init(new JobEngineConfig(kylinConfig), new ZookeeperJobLock());
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    scheduler.shutdown();
                }
                catch (SchedulerException e) {
                    logger.error("error occurred to shutdown scheduler", e);
                }
            }
        }));
    }

    private Set<ExecutableState> convertStatusEnumToStates(List<JobStatusEnum> statusList) {
        AbstractSet states;
        if (statusList == null || statusList.isEmpty()) {
            states = EnumSet.allOf(ExecutableState.class);
        } else {
            states = Sets.newHashSet();
            for (JobStatusEnum status : statusList) {
                states.add((ExecutableState)this.parseToExecutableState(status));
            }
        }
        return states;
    }

    private ExecutableState parseToExecutableState(JobStatusEnum status) {
        Message msg = MsgPicker.getMsg();
        switch (status) {
            case DISCARDED: {
                return ExecutableState.DISCARDED;
            }
            case ERROR: {
                return ExecutableState.ERROR;
            }
            case FINISHED: {
                return ExecutableState.SUCCEED;
            }
            case NEW: {
                return ExecutableState.READY;
            }
            case PENDING: {
                return ExecutableState.READY;
            }
            case RUNNING: {
                return ExecutableState.RUNNING;
            }
            case STOPPED: {
                return ExecutableState.STOPPED;
            }
        }
        throw new BadRequestException(String.format(Locale.ROOT, msg.getILLEGAL_EXECUTABLE_STATE(), new Object[]{status}));
    }

    private long getTimeStartInMillis(Calendar calendar, JobTimeFilterEnum timeFilter) {
        Message msg = MsgPicker.getMsg();
        switch (timeFilter) {
            case LAST_ONE_DAY: {
                calendar.add(5, -1);
                return calendar.getTimeInMillis();
            }
            case LAST_ONE_WEEK: {
                calendar.add(4, -1);
                return calendar.getTimeInMillis();
            }
            case LAST_ONE_MONTH: {
                calendar.add(2, -1);
                return calendar.getTimeInMillis();
            }
            case LAST_ONE_YEAR: {
                calendar.add(1, -1);
                return calendar.getTimeInMillis();
            }
            case CURRENT_DAY: {
                calendar.add(5, 0);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                return calendar.getTimeInMillis();
            }
            case ALL: {
                return 0L;
            }
        }
        throw new BadRequestException(String.format(Locale.ROOT, msg.getILLEGAL_TIME_FILTER(), new Object[]{timeFilter}));
    }

    public JobInstance submitJob(CubeInstance cube, SegmentRange.TSRange tsRange, SegmentRange segRange, Map<Integer, Long> sourcePartitionOffsetStart, Map<Integer, Long> sourcePartitionOffsetEnd, CubeBuildTypeEnum buildType, boolean force, String submitter, Integer priorityOffset) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(cube);
        JobInstance jobInstance = this.submitJobInternal(cube, tsRange, segRange, sourcePartitionOffsetStart, sourcePartitionOffsetEnd, buildType, force, submitter, priorityOffset);
        return jobInstance;
    }

    public JobInstance submitJobInternal(CubeInstance cube, SegmentRange.TSRange tsRange, SegmentRange segRange, Map<Integer, Long> sourcePartitionOffsetStart, Map<Integer, Long> sourcePartitionOffsetEnd, CubeBuildTypeEnum buildType, boolean force, String submitter, Integer priorityOffset) throws IOException {
        DefaultChainedExecutable job;
        Message msg = MsgPicker.getMsg();
        if (cube.getStatus() == RealizationStatusEnum.DESCBROKEN) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getBUILD_BROKEN_CUBE(), cube.getName()));
        }
        this.checkCubeDescSignature(cube);
        this.checkAllowBuilding(cube);
        if (buildType == CubeBuildTypeEnum.BUILD || buildType == CubeBuildTypeEnum.REFRESH) {
            this.checkAllowParallelBuilding(cube);
        }
        CubeSegment newSeg = null;
        try {
            if (buildType == CubeBuildTypeEnum.BUILD) {
                SourcePartition src;
                if (cube.getSourceType() == 9) {
                    ISource source = SourceFactory.getCSVSource();
                    src = new SourcePartition(tsRange, segRange, sourcePartitionOffsetStart, sourcePartitionOffsetEnd);
                    src = source.enrichSourcePartitionBeforeBuild(cube, src);
                } else {
                    ISource source = SourceManager.getSource(cube);
                    src = new SourcePartition(tsRange, segRange, sourcePartitionOffsetStart, sourcePartitionOffsetEnd);
                }
                newSeg = this.getCubeManager().appendSegment(cube, src);
                job = EngineFactory.createBatchCubingJob(newSeg, submitter, priorityOffset);
            } else if (buildType == CubeBuildTypeEnum.MERGE) {
                newSeg = this.getCubeManager().mergeSegments(cube, tsRange, segRange, force);
                job = EngineFactory.createBatchMergeJob(newSeg, submitter);
            } else if (buildType == CubeBuildTypeEnum.REFRESH) {
                newSeg = this.getCubeManager().refreshSegment(cube, tsRange, segRange);
                job = EngineFactory.createBatchCubingJob(newSeg, submitter, priorityOffset);
            } else {
                throw new BadRequestException(String.format(Locale.ROOT, msg.getINVALID_BUILD_TYPE(), new Object[]{buildType}));
            }
            this.getExecutableManager().addJob(job);
        }
        catch (Exception e) {
            if (newSeg != null) {
                logger.error("Job submission might failed for NEW segment {}, will clean the NEW segment from cube", (Object)newSeg.getName());
                try {
                    this.getCubeManager().updateCubeDropSegments(cube, newSeg);
                }
                catch (Exception ee) {
                    logger.error("Clean New segment failed, ignoring it", e);
                }
            }
            throw e;
        }
        JobInstance jobInstance = this.getSingleJobInstance(job);
        return jobInstance;
    }

    public Pair<JobInstance, List<JobInstance>> submitOptimizeJob(CubeInstance cube, Set<Long> cuboidsRecommend, String submitter) throws IOException, JobException {
        Pair<JobInstance, List<JobInstance>> result = this.submitOptimizeJobInternal(cube, cuboidsRecommend, submitter);
        return result;
    }

    private Pair<JobInstance, List<JobInstance>> submitOptimizeJobInternal(CubeInstance cube, Set<Long> cuboidsRecommend, String submitter) throws IOException {
        Message msg = MsgPicker.getMsg();
        if (cube.getStatus() == RealizationStatusEnum.DESCBROKEN) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getBUILD_BROKEN_CUBE(), cube.getName()));
        }
        this.checkCubeDescSignature(cube);
        this.checkAllowOptimization(cube, cuboidsRecommend);
        Object[] optimizeSegments = null;
        try {
            optimizeSegments = this.getCubeManager().optimizeSegments(cube, cuboidsRecommend);
            LinkedList<JobInstance> optimizeJobInstances = Lists.newLinkedList();
            ArrayList<AbstractExecutable> optimizeJobList = Lists.newArrayListWithExpectedSize(optimizeSegments.length);
            for (Object optimizeSegment : optimizeSegments) {
                DefaultChainedExecutable optimizeJob = EngineFactory.createBatchOptimizeJob((CubeSegment)optimizeSegment, submitter);
                this.getExecutableManager().addJob(optimizeJob);
                optimizeJobList.add(optimizeJob);
                optimizeJobInstances.add(this.getSingleJobInstance(optimizeJob));
            }
            CheckpointExecutable checkpointJob = new BatchOptimizeJobCheckpointBuilder(cube, submitter).build();
            checkpointJob.addTaskListForCheck(optimizeJobList);
            this.getExecutableManager().addJob(checkpointJob);
            return new Pair<JobInstance, List<JobInstance>>(this.getCheckpointJobInstance(checkpointJob), optimizeJobInstances);
        }
        catch (Exception e) {
            if (optimizeSegments != null) {
                logger.error("Job submission might failed for NEW segments {}, will clean the NEW segments from cube", optimizeSegments);
                try {
                    this.getCubeManager().updateCubeDropSegments(cube, (CubeSegment[])optimizeSegments);
                }
                catch (Exception ee) {
                    logger.error("Clean New segments failed, ignoring it", e);
                }
            }
            throw e;
        }
    }

    public JobInstance submitRecoverSegmentOptimizeJob(CubeSegment segment, String submitter) throws IOException, JobException {
        CubeInstance cubeInstance = segment.getCubeInstance();
        this.checkCubeDescSignature(cubeInstance);
        String cubeName = cubeInstance.getName();
        List<JobInstance> jobInstanceList = this.searchJobsByCubeName(cubeName, null, Lists.newArrayList(JobStatusEnum.NEW, JobStatusEnum.PENDING, JobStatusEnum.ERROR), JobTimeFilterEnum.ALL, JobSearchMode.CHECKPOINT_ONLY);
        if (jobInstanceList.size() > 1) {
            throw new IllegalStateException("Exist more than one CheckpointExecutable for cube " + cubeName);
        }
        if (jobInstanceList.size() == 0) {
            throw new IllegalStateException("There's no CheckpointExecutable for cube " + cubeName);
        }
        CheckpointExecutable checkpointExecutable = (CheckpointExecutable)this.getExecutableManager().getJob(jobInstanceList.get(0).getId());
        AbstractExecutable toBeReplaced = null;
        for (AbstractExecutable taskForCheck : checkpointExecutable.getSubTasksForCheck()) {
            CubingJob subCubingJob;
            String segmentName;
            if (!(taskForCheck instanceof CubingJob) || (segmentName = CubingExecutableUtil.getSegmentName((subCubingJob = (CubingJob)taskForCheck).getParams())) == null || !segmentName.equals(segment.getName())) continue;
            String segmentID = CubingExecutableUtil.getSegmentId(subCubingJob.getParams());
            CubeSegment beingOptimizedSegment = cubeInstance.getSegmentById(segmentID);
            if (beingOptimizedSegment != null) {
                throw new IllegalStateException("Segment " + beingOptimizedSegment.getName() + "-" + beingOptimizedSegment.getUuid() + " still exists. Please delete it or discard the related optimize job first!!!");
            }
            toBeReplaced = taskForCheck;
            break;
        }
        if (toBeReplaced == null) {
            throw new IllegalStateException("There's no CubingJob for segment " + segment.getName() + " in CheckpointExecutable " + checkpointExecutable.getName());
        }
        CubeSegment optimizeSegment = this.getCubeManager().appendSegment(cubeInstance, segment.getTSRange());
        DefaultChainedExecutable optimizeJob = EngineFactory.createBatchOptimizeJob(optimizeSegment, submitter);
        this.getExecutableManager().addJob(optimizeJob);
        JobInstance optimizeJobInstance = this.getSingleJobInstance(optimizeJob);
        checkpointExecutable.getSubTasksForCheck().set(checkpointExecutable.getSubTasksForCheck().indexOf(toBeReplaced), optimizeJob);
        this.getExecutableManager().updateCheckpointJob(checkpointExecutable.getId(), checkpointExecutable.getSubTasksForCheck());
        return optimizeJobInstance;
    }

    private void checkCubeDescSignature(CubeInstance cube) {
        Message msg = MsgPicker.getMsg();
        if (!cube.getDescriptor().checkSignature()) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getINCONSISTENT_CUBE_DESC_SIGNATURE(), cube.getDescriptor()));
        }
    }

    private void checkAllowBuilding(CubeInstance cube) {
        Segments<CubeSegment> readyPendingSegments;
        if (cube.getConfig().isCubePlannerEnabled() && (readyPendingSegments = cube.getSegments(SegmentStatusEnum.READY_PENDING)).size() > 0) {
            throw new BadRequestException("The cube " + cube.getName() + " has READY_PENDING segments " + readyPendingSegments + ". It's not allowed for building");
        }
    }

    private void checkAllowParallelBuilding(CubeInstance cube) {
        Segments<CubeSegment> cubeSegments;
        if (cube.getConfig().isCubePlannerEnabled() && cube.getCuboids() == null && (cubeSegments = cube.getSegments()).size() > 0 && cubeSegments.getSegments(SegmentStatusEnum.READY).size() <= 0) {
            throw new BadRequestException("The cube " + cube.getName() + " has segments " + cubeSegments + ", but none of them is READY. It's not allowed for parallel building");
        }
    }

    private void checkAllowOptimization(CubeInstance cube, Set<Long> cuboidsRecommend) {
        Segments<CubeSegment> buildingSegments = cube.getBuildingSegments();
        if (buildingSegments.size() > 0) {
            throw new BadRequestException("The cube " + cube.getName() + " has building segments " + buildingSegments + ". It's not allowed for optimization");
        }
        long baseCuboid = cube.getCuboidScheduler().getBaseCuboidId();
        if (!cuboidsRecommend.contains(baseCuboid)) {
            throw new BadRequestException("The recommend cuboids should contain the base cuboid " + baseCuboid);
        }
        Set<Long> currentCuboidSet = cube.getCuboidScheduler().getAllCuboidIds();
        if (currentCuboidSet.equals(cuboidsRecommend)) {
            throw new BadRequestException("The recommend cuboids are the same as the current cuboids. It's no need to do optimization.");
        }
    }

    public void updateSparkJobInfo(String project, String taskId, String yarnAppUrl) {
        ExecutableManager executableManager = this.getExecutableManager();
        HashMap extraInfo = Maps.newHashMap();
        extraInfo.put("yarn_application_tracking_url", yarnAppUrl);
        executableManager.updateJobOutput(project, taskId, null, extraInfo, null, null);
    }

    public JobInstance getJobInstance(String uuid) {
        AbstractExecutable job = this.getExecutableManager().getJob(uuid);
        if (job instanceof CheckpointExecutable) {
            return this.getCheckpointJobInstance(job);
        }
        return this.getSingleJobInstance(job);
    }

    public Output getOutput(String id) {
        return this.getExecutableManager().getOutput(id);
    }

    public String getJobStepOutput(String jobId, String stepId) {
        ExecutableManager executableManager = this.getExecutableManager();
        return executableManager.getOutputFromHDFSByJobId(jobId, stepId).getVerboseMsg();
    }

    public String getAllJobStepOutput(String jobId, String stepId) {
        ExecutableManager executableManager = this.getExecutableManager();
        return executableManager.getOutputFromHDFSByJobId(jobId, stepId, Integer.MAX_VALUE).getVerboseMsg();
    }

    protected JobInstance getSingleJobInstance(AbstractExecutable job) {
        Message msg = MsgPicker.getMsg();
        if (job == null) {
            return null;
        }
        if (!(job instanceof CubingJob)) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getILLEGAL_JOB_TYPE(), job.getId()));
        }
        CubingJob cubeJob = (CubingJob)job;
        CubeInstance cube = CubeManager.getInstance(KylinConfig.getInstanceFromEnv()).getCube(CubingExecutableUtil.getCubeName(cubeJob.getParams()));
        Output output = cubeJob.getOutput();
        JobInstance result = new JobInstance();
        result.setName(job.getName());
        result.setProjectName(cubeJob.getProjectName());
        if (cube != null) {
            result.setRelatedCube(cube.getName());
            result.setDisplayCubeName(cube.getDisplayName());
        } else {
            String cubeName = CubingExecutableUtil.getCubeName(cubeJob.getParams());
            result.setRelatedCube(cubeName);
            result.setDisplayCubeName(cubeName);
        }
        result.setRelatedSegment(CubingExecutableUtil.getSegmentId(cubeJob.getParams()));
        result.setRelatedSegmentName(CubingExecutableUtil.getSegmentName(cubeJob.getParams()));
        result.setLastModified(cubeJob.getLastModified());
        result.setSubmitter(cubeJob.getSubmitter());
        result.setUuid(cubeJob.getId());
        result.setExecStartTime(cubeJob.getStartTime());
        result.setExecEndTime(cubeJob.getEndTime());
        result.setExecInterruptTime(cubeJob.getInterruptTime());
        result.setType(CubeBuildTypeEnum.BUILD);
        result.setStatus(JobInfoConverter.parseToJobStatus(job.getStatus()));
        result.setMrWaiting(cubeJob.getMapReduceWaitTime() / 1000L);
        result.setBuildInstance(AbstractExecutable.getBuildInstance(output));
        result.setDuration(cubeJob.getDuration() / 1000L);
        for (int i = 0; i < cubeJob.getTasks().size(); ++i) {
            AbstractExecutable task = cubeJob.getTasks().get(i);
            result.addStep(JobInfoConverter.parseToJobStep(task, i, this.getExecutableManager().getOutput(task.getId())));
        }
        return result;
    }

    protected JobInstance getLookupSnapshotBuildJobInstance(LookupSnapshotBuildJob job) {
        if (job == null) {
            return null;
        }
        Output output = job.getOutput();
        JobInstance result = new JobInstance();
        result.setName(job.getName());
        result.setProjectName(job.getProjectName());
        result.setRelatedCube(CubingExecutableUtil.getCubeName(job.getParams()));
        result.setRelatedSegment(CubingExecutableUtil.getSegmentId(job.getParams()));
        result.setRelatedSegmentName(CubingExecutableUtil.getSegmentName(job.getParams()));
        result.setLastModified(job.getLastModified());
        result.setSubmitter(job.getSubmitter());
        result.setUuid(job.getId());
        result.setExecStartTime(job.getStartTime());
        result.setExecEndTime(job.getEndTime());
        result.setExecInterruptTime(job.getInterruptTime());
        result.setType(CubeBuildTypeEnum.BUILD);
        result.setStatus(JobInfoConverter.parseToJobStatus(job.getStatus()));
        result.setBuildInstance(AbstractExecutable.getBuildInstance(output));
        result.setDuration(job.getDuration() / 1000L);
        for (int i = 0; i < job.getTasks().size(); ++i) {
            AbstractExecutable task = job.getTasks().get(i);
            result.addStep(JobInfoConverter.parseToJobStep(task, i, this.getExecutableManager().getOutput(task.getId())));
        }
        return result;
    }

    protected JobInstance getCheckpointJobInstance(AbstractExecutable job) {
        Message msg = MsgPicker.getMsg();
        if (job == null) {
            return null;
        }
        if (!(job instanceof CheckpointExecutable)) {
            throw new BadRequestException(String.format(Locale.ROOT, msg.getILLEGAL_JOB_TYPE(), job.getId()));
        }
        CheckpointExecutable checkpointExecutable = (CheckpointExecutable)job;
        Output output = checkpointExecutable.getOutput();
        JobInstance result = new JobInstance();
        result.setName(job.getName());
        result.setProjectName(checkpointExecutable.getProjectName());
        result.setRelatedCube(CubingExecutableUtil.getCubeName(job.getParams()));
        result.setDisplayCubeName(CubingExecutableUtil.getCubeName(job.getParams()));
        result.setLastModified(job.getLastModified());
        result.setSubmitter(job.getSubmitter());
        result.setUuid(job.getId());
        result.setExecStartTime(job.getStartTime());
        result.setExecEndTime(job.getEndTime());
        result.setExecInterruptTime(job.getInterruptTime());
        result.setType(CubeBuildTypeEnum.CHECKPOINT);
        result.setStatus(JobInfoConverter.parseToJobStatus(job.getStatus()));
        result.setBuildInstance(AbstractExecutable.getBuildInstance(output));
        result.setDuration(job.getDuration() / 1000L);
        for (int i = 0; i < checkpointExecutable.getTasks().size(); ++i) {
            AbstractExecutable task = checkpointExecutable.getTasks().get(i);
            result.addStep(JobInfoConverter.parseToJobStep(task, i, this.getExecutableManager().getOutput(task.getId())));
        }
        return result;
    }

    public void resumeJob(JobInstance job) {
        this.aclEvaluate.checkProjectOperationPermission(job);
        this.getExecutableManager().resumeJob(job.getId());
    }

    public void rollbackJob(JobInstance job, String stepId) {
        this.aclEvaluate.checkProjectOperationPermission(job);
        this.getExecutableManager().rollbackJob(job.getId(), stepId);
    }

    public void cancelJob(JobInstance job) throws IOException {
        this.aclEvaluate.checkProjectOperationPermission(job);
        if (null == job.getRelatedCube() || null == this.getCubeManager().getCube(job.getRelatedCube()) || null == job.getRelatedSegment()) {
            this.getExecutableManager().discardJob(job.getId());
        }
        logger.info("Cancel job [" + job.getId() + "] trigger by " + SecurityContextHolder.getContext().getAuthentication().getName());
        if (job.getStatus() == JobStatusEnum.FINISHED) {
            throw new IllegalStateException("The job " + job.getId() + " has already been finished and cannot be discarded.");
        }
        AbstractExecutable executable = this.getExecutableManager().getJob(job.getId());
        if (job.getStatus() != JobStatusEnum.DISCARDED) {
            if (executable instanceof CubingJob) {
                if (executable instanceof NSparkCubingJob) {
                    ((NSparkCubingJob)executable).cleanupAfterJobDiscard();
                }
                this.cancelCubingJobInner((CubingJob)executable);
                if (executable.getStatus().isFinalState()) {
                    try {
                        DistributedLock lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().lockForCurrentThread();
                        if (lock.isLocked(CubeJobLockUtil.getLockPath(executable.getCubeName(), job.getId()))) {
                            lock.purgeLocks(CubeJobLockUtil.getLockPath(executable.getCubeName(), null));
                            logger.info("{} unlock cube job dict lock path({}) success", (Object)job.getId(), (Object)CubeJobLockUtil.getLockPath(executable.getCubeName(), null));
                            if (lock.isLocked(CubeJobLockUtil.getEphemeralLockPath(executable.getCubeName()))) {
                                lock.purgeLocks(CubeJobLockUtil.getEphemeralLockPath(executable.getCubeName()));
                                logger.info("{} unlock cube job ephemeral lock path({}) success", (Object)job.getId(), (Object)CubeJobLockUtil.getEphemeralLockPath(executable.getCubeName()));
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("get some error when release cube {} job {} job id {} ", executable.getCubeName(), job.getName(), job.getId());
                    }
                }
            } else if (executable instanceof CheckpointExecutable) {
                this.cancelCheckpointJobInner((CheckpointExecutable)executable);
            } else {
                this.getExecutableManager().discardJob(executable.getId());
            }
        }
    }

    private void cancelCubingJobInner(CubingJob cubingJob) throws IOException {
        CubeInstance cubeInstance = this.getCubeManager().getCube(CubingExecutableUtil.getCubeName(cubingJob.getParams()));
        String segmentIds = CubingExecutableUtil.getSegmentId(cubingJob.getParams());
        if (!StringUtils.isEmpty(segmentIds)) {
            for (String segmentId : StringUtils.split(segmentIds)) {
                CubeSegment segment = cubeInstance.getSegmentById(segmentId);
                if (segment == null || segment.getStatus() != SegmentStatusEnum.NEW && (Long)segment.getTSRange().end.v != 0L) continue;
                this.getCubeManager().updateCubeDropSegments(cubeInstance, segment);
            }
        }
        this.getExecutableManager().discardJob(cubingJob.getId());
    }

    private void cancelCheckpointJobInner(CheckpointExecutable checkpointExecutable) throws IOException {
        LinkedList<String> segmentIdList = Lists.newLinkedList();
        LinkedList<String> jobIdList = Lists.newLinkedList();
        jobIdList.add(checkpointExecutable.getId());
        this.setRelatedIdList(checkpointExecutable, segmentIdList, jobIdList);
        CubeInstance cubeInstance = this.getCubeManager().getCube(CubingExecutableUtil.getCubeName(checkpointExecutable.getParams()));
        if (!segmentIdList.isEmpty()) {
            LinkedList<CubeSegment> toRemoveSegments = Lists.newLinkedList();
            for (String segmentId : segmentIdList) {
                CubeSegment segment = cubeInstance.getSegmentById(segmentId);
                if (segment == null || segment.getStatus() == SegmentStatusEnum.READY) continue;
                toRemoveSegments.add(segment);
            }
            this.getCubeManager().dropOptmizingSegments(cubeInstance, toRemoveSegments.toArray(new CubeSegment[0]));
        }
        for (String jobId : jobIdList) {
            this.getExecutableManager().discardJob(jobId);
        }
    }

    private void setRelatedIdList(CheckpointExecutable checkpointExecutable, List<String> segmentIdList, List<String> jobIdList) {
        for (AbstractExecutable taskForCheck : checkpointExecutable.getSubTasksForCheck()) {
            jobIdList.add(taskForCheck.getId());
            if (taskForCheck instanceof CubingJob) {
                segmentIdList.addAll(Lists.newArrayList(StringUtils.split(CubingExecutableUtil.getSegmentId(taskForCheck.getParams()))));
                continue;
            }
            if (!(taskForCheck instanceof CheckpointExecutable)) continue;
            this.setRelatedIdList((CheckpointExecutable)taskForCheck, segmentIdList, jobIdList);
        }
    }

    public void pauseJob(JobInstance job) {
        this.aclEvaluate.checkProjectOperationPermission(job);
        logger.info("Pause job [" + job.getId() + "] trigger by " + SecurityContextHolder.getContext().getAuthentication().getName());
        if (job.getStatus().isComplete()) {
            throw new IllegalStateException("The job " + job.getId() + " has already been finished and cannot be stopped.");
        }
        this.getExecutableManager().pauseJob(job.getId());
    }

    public void dropJob(JobInstance job) {
        this.aclEvaluate.checkProjectOperationPermission(job);
        if (job.getRelatedCube() != null && this.getCubeManager().getCube(job.getRelatedCube()) != null && job.getStatus() != JobStatusEnum.FINISHED && job.getStatus() != JobStatusEnum.DISCARDED) {
            throw new BadRequestException("Only FINISHED and DISCARDED job can be deleted. Please wait for the job finishing or discard the job!!!");
        }
        this.getExecutableManager().deleteJob(job.getId());
        logger.info("Delete job [" + job.getId() + "] trigger by + " + SecurityContextHolder.getContext().getAuthentication().getName());
    }

    public List<JobInstance> searchJobs(String cubeNameSubstring, String projectName, List<JobStatusEnum> statusList, Integer limitValue, Integer offsetValue, JobTimeFilterEnum timeFilter, JobSearchMode jobSearchMode) {
        Integer limit = null == limitValue ? 30 : limitValue;
        Integer offset = null == offsetValue ? 0 : offsetValue;
        List<JobInstance> jobs = this.searchJobsByCubeName(cubeNameSubstring, projectName, statusList, timeFilter, jobSearchMode);
        Collections.sort(jobs);
        if (jobs.size() <= offset) {
            return Collections.emptyList();
        }
        if (jobs.size() - offset < limit) {
            return jobs.subList(offset, jobs.size());
        }
        return jobs.subList(offset, offset + limit);
    }

    public List<JobInstance> searchJobsByCubeName(String cubeNameSubstring, String projectName, List<JobStatusEnum> statusList, JobTimeFilterEnum timeFilter, JobSearchMode jobSearchMode) {
        return this.innerSearchJobs(cubeNameSubstring, null, projectName, statusList, timeFilter, jobSearchMode);
    }

    public List<JobInstance> innerSearchJobs(String cubeName, String jobName, String projectName, List<JobStatusEnum> statusList, JobTimeFilterEnum timeFilter, JobSearchMode jobSearchMode) {
        ArrayList<JobInstance> result = Lists.newArrayList();
        switch (jobSearchMode) {
            case ALL: {
                result.addAll(this.innerSearchCubingJobs(cubeName, jobName, projectName, statusList, timeFilter));
                result.addAll(this.innerSearchCheckpointJobs(cubeName, jobName, projectName, statusList, timeFilter));
                break;
            }
            case CHECKPOINT_ONLY: {
                result.addAll(this.innerSearchCheckpointJobs(cubeName, jobName, projectName, statusList, timeFilter));
                break;
            }
            default: {
                result.addAll(this.innerSearchCubingJobs(cubeName, jobName, projectName, statusList, timeFilter));
            }
        }
        return result;
    }

    public List<JobInstance> innerSearchCubingJobs(String cubeName, String jobName, String projectName, List<JobStatusEnum> statusList, JobTimeFilterEnum timeFilter) {
        if (null == projectName) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.checkProjectOperationPermission(projectName);
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.ROOT);
        calendar.setTime(new Date());
        long timeStartInMillis = this.getTimeStartInMillis(calendar, timeFilter);
        long timeEndInMillis = Long.MAX_VALUE;
        Set<ExecutableState> states = this.convertStatusEnumToStates(statusList);
        final Map<String, Output> allOutputs = this.getExecutableManager().getAllOutputs(timeStartInMillis, timeEndInMillis);
        return Lists.newArrayList(FluentIterable.from(this.innerSearchCubingJobs(cubeName, jobName, states, timeStartInMillis, timeEndInMillis, allOutputs, false, projectName)).transform(new Function<CubingJob, JobInstance>(){

            @Override
            public JobInstance apply(CubingJob cubingJob) {
                return JobInfoConverter.parseToJobInstanceQuietly(cubingJob, (Map<String, Output>)allOutputs);
            }
        }).filter(new Predicate<JobInstance>(){

            @Override
            public boolean apply(@Nullable JobInstance input) {
                return input != null;
            }
        }));
    }

    public List<CubingJob> innerSearchCubingJobs(final String cubeName, final String jobName, final Set<ExecutableState> statusList, long timeStartInMillis, long timeEndInMillis, final Map<String, Output> allOutputs, final boolean nameExactMatch, final String projectName) {
        ArrayList<CubingJob> results = Lists.newArrayList(FluentIterable.from(this.getExecutableManager().getAllExecutables(timeStartInMillis, timeEndInMillis)).filter(new Predicate<AbstractExecutable>(){

            @Override
            public boolean apply(AbstractExecutable executable) {
                if (executable instanceof CubingJob) {
                    if (StringUtils.isEmpty(cubeName)) {
                        return true;
                    }
                    String executableCubeName = CubingExecutableUtil.getCubeName(executable.getParams());
                    if (executableCubeName == null) {
                        return true;
                    }
                    if (nameExactMatch) {
                        return executableCubeName.equalsIgnoreCase(cubeName);
                    }
                    return executableCubeName.toLowerCase(Locale.ROOT).contains(cubeName.toLowerCase(Locale.ROOT));
                }
                return false;
            }
        }).transform(new Function<AbstractExecutable, CubingJob>(){

            @Override
            public CubingJob apply(AbstractExecutable executable) {
                return (CubingJob)executable;
            }
        }).filter(Predicates.and(new Predicate<CubingJob>(){

            @Override
            public boolean apply(CubingJob executable) {
                if (null == projectName || null == JobService.this.getProjectManager().getProject(projectName)) {
                    return true;
                }
                return projectName.equalsIgnoreCase(executable.getProjectName());
            }
        }, new Predicate<CubingJob>(){

            @Override
            public boolean apply(CubingJob executable) {
                Output output = (Output)allOutputs.get(executable.getId());
                if (output == null) {
                    return false;
                }
                ExecutableState state = output.getState();
                boolean ret = statusList.contains((Object)state);
                return ret;
            }
        }, new Predicate<CubingJob>(){

            @Override
            public boolean apply(@Nullable CubingJob cubeJob) {
                if (cubeJob == null) {
                    return false;
                }
                if (StringUtils.isEmpty(jobName)) {
                    return true;
                }
                if (nameExactMatch) {
                    return cubeJob.getName().equalsIgnoreCase(jobName);
                }
                return cubeJob.getName().toLowerCase(Locale.ROOT).contains(jobName.toLowerCase(Locale.ROOT));
            }
        })));
        return results;
    }

    public List<JobInstance> innerSearchCheckpointJobs(String cubeName, String jobName, String projectName, List<JobStatusEnum> statusList, JobTimeFilterEnum timeFilter) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.ROOT);
        calendar.setTime(new Date());
        long timeStartInMillis = this.getTimeStartInMillis(calendar, timeFilter);
        long timeEndInMillis = Long.MAX_VALUE;
        Set<ExecutableState> states = this.convertStatusEnumToStates(statusList);
        final Map<String, Output> allOutputs = this.getExecutableManager().getAllOutputs(timeStartInMillis, timeEndInMillis);
        return Lists.newArrayList(FluentIterable.from(this.innerSearchCheckpointJobs(cubeName, jobName, states, timeStartInMillis, timeEndInMillis, allOutputs, false, projectName)).transform(new Function<CheckpointExecutable, JobInstance>(){

            @Override
            public JobInstance apply(CheckpointExecutable checkpointExecutable) {
                return JobInfoConverter.parseToJobInstanceQuietly(checkpointExecutable, (Map<String, Output>)allOutputs);
            }
        }));
    }

    public List<CheckpointExecutable> innerSearchCheckpointJobs(final String cubeName, final String jobName, final Set<ExecutableState> statusList, long timeStartInMillis, long timeEndInMillis, final Map<String, Output> allOutputs, final boolean nameExactMatch, final String projectName) {
        ArrayList<CheckpointExecutable> results = Lists.newArrayList(FluentIterable.from(this.getExecutableManager().getAllExecutables(timeStartInMillis, timeEndInMillis)).filter(new Predicate<AbstractExecutable>(){

            @Override
            public boolean apply(AbstractExecutable executable) {
                if (executable instanceof CheckpointExecutable) {
                    if (StringUtils.isEmpty(cubeName)) {
                        return true;
                    }
                    String executableCubeName = CubingExecutableUtil.getCubeName(executable.getParams());
                    if (executableCubeName == null) {
                        return true;
                    }
                    if (nameExactMatch) {
                        return executableCubeName.equalsIgnoreCase(cubeName);
                    }
                    return executableCubeName.toLowerCase(Locale.ROOT).contains(cubeName.toLowerCase(Locale.ROOT));
                }
                return false;
            }
        }).transform(new Function<AbstractExecutable, CheckpointExecutable>(){

            @Override
            public CheckpointExecutable apply(AbstractExecutable executable) {
                return (CheckpointExecutable)executable;
            }
        }).filter(Predicates.and(new Predicate<CheckpointExecutable>(){

            @Override
            public boolean apply(CheckpointExecutable executable) {
                if (null == projectName || null == JobService.this.getProjectManager().getProject(projectName)) {
                    return true;
                }
                return projectName.equalsIgnoreCase(executable.getProjectName());
            }
        }, new Predicate<CheckpointExecutable>(){

            @Override
            public boolean apply(CheckpointExecutable executable) {
                Output output = (Output)allOutputs.get(executable.getId());
                if (output == null) {
                    return false;
                }
                ExecutableState state = output.getState();
                boolean ret = statusList.contains((Object)state);
                return ret;
            }
        }, new Predicate<CheckpointExecutable>(){

            @Override
            public boolean apply(@Nullable CheckpointExecutable checkpointExecutable) {
                if (checkpointExecutable == null) {
                    return false;
                }
                if (StringUtils.isEmpty(jobName)) {
                    return true;
                }
                if (nameExactMatch) {
                    return checkpointExecutable.getName().equalsIgnoreCase(jobName);
                }
                return checkpointExecutable.getName().toLowerCase(Locale.ROOT).contains(jobName.toLowerCase(Locale.ROOT));
            }
        })));
        return results;
    }

    public List<JobInstance> searchJobsV2(String cubeNameSubstring, String projectName, List<JobStatusEnum> statusList, Integer limitValue, Integer offsetValue, JobTimeFilterEnum timeFilter, JobSearchMode jobSearchMode) {
        Integer limit = null == limitValue ? 30 : limitValue;
        Integer offset = null == offsetValue ? 0 : offsetValue;
        List<JobSearchResult> jobSearchResultList = this.searchJobsByCubeNameV2(cubeNameSubstring, projectName, statusList, timeFilter, jobSearchMode);
        Collections.sort(jobSearchResultList);
        if (jobSearchResultList.size() <= offset) {
            return Collections.emptyList();
        }
        List<JobSearchResult> subJobSearchResultList = jobSearchResultList.size() - offset < limit ? jobSearchResultList.subList(offset, jobSearchResultList.size()) : jobSearchResultList.subList(offset, offset + limit);
        ArrayList<JobInstance> jobInstanceList = new ArrayList<JobInstance>();
        for (JobSearchResult result : subJobSearchResultList) {
            JobInstance jobInstance = this.getJobInstance(result.getId());
            jobInstanceList.add(jobInstance);
        }
        return jobInstanceList;
    }

    public Map<JobStatusEnum, Integer> searchJobsOverview(String cubeNameSubstring, String projectName, List<JobStatusEnum> statusList, JobTimeFilterEnum timeFilter, JobSearchMode jobSearchMode) {
        List<JobSearchResult> jobSearchResultList = this.searchJobsByCubeNameV2(cubeNameSubstring, projectName, statusList, timeFilter, jobSearchMode);
        HashMap<JobStatusEnum, Integer> jobOverview = new HashMap<JobStatusEnum, Integer>();
        if (statusList == null || statusList.isEmpty()) {
            for (JobStatusEnum status : JobStatusEnum.values()) {
                jobOverview.put(status, 0);
            }
        } else {
            for (JobStatusEnum status : statusList) {
                jobOverview.put(status, 0);
            }
        }
        for (JobSearchResult result : jobSearchResultList) {
            jobOverview.put(result.getJobStatus(), (Integer)jobOverview.get((Object)result.getJobStatus()) + 1);
        }
        return jobOverview;
    }

    public List<JobSearchResult> searchJobsByCubeNameV2(String cubeNameSubstring, String projectName, List<JobStatusEnum> statusList, JobTimeFilterEnum timeFilter, JobSearchMode jobSearchMode) {
        ArrayList<JobSearchResult> result = Lists.newArrayList();
        switch (jobSearchMode) {
            case ALL: {
                result.addAll(this.innerSearchCubingJobsV2(cubeNameSubstring, null, projectName, statusList, timeFilter));
                result.addAll(this.innerSearchCheckpointJobsV2(cubeNameSubstring, null, projectName, statusList, timeFilter));
                break;
            }
            case CHECKPOINT_ONLY: {
                result.addAll(this.innerSearchCheckpointJobsV2(cubeNameSubstring, null, projectName, statusList, timeFilter));
                break;
            }
            default: {
                result.addAll(this.innerSearchCubingJobsV2(cubeNameSubstring, null, projectName, statusList, timeFilter));
            }
        }
        return result;
    }

    public List<JobSearchResult> innerSearchCubingJobsV2(String cubeName, String jobName, String projectName, List<JobStatusEnum> statusList, JobTimeFilterEnum timeFilter) {
        if (null == projectName) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.checkProjectOperationPermission(projectName);
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.ROOT);
        calendar.setTime(new Date());
        long timeStartInMillis = this.getTimeStartInMillis(calendar, timeFilter);
        long timeEndInMillis = Long.MAX_VALUE;
        Set<ExecutableState> states = this.convertStatusEnumToStates(statusList);
        final Map<String, ExecutableOutputPO> allOutputDigests = this.getExecutableManager().getAllOutputDigests(timeStartInMillis, timeEndInMillis);
        return Lists.newArrayList(FluentIterable.from(this.innerSearchCubingJobsV2(cubeName, jobName, states, timeStartInMillis, timeEndInMillis, allOutputDigests, false, projectName)).transform(new Function<CubingJob, JobSearchResult>(){

            @Override
            public JobSearchResult apply(CubingJob cubingJob) {
                return JobInfoConverter.parseToJobSearchResult(cubingJob, allOutputDigests);
            }
        }).filter(new Predicate<JobSearchResult>(){

            @Override
            public boolean apply(@Nullable JobSearchResult input) {
                return input != null;
            }
        }));
    }

    public List<JobSearchResult> innerSearchCheckpointJobsV2(String cubeName, String jobName, String projectName, List<JobStatusEnum> statusList, JobTimeFilterEnum timeFilter) {
        if (null == projectName) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.checkProjectOperationPermission(projectName);
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.ROOT);
        calendar.setTime(new Date());
        long timeStartInMillis = this.getTimeStartInMillis(calendar, timeFilter);
        long timeEndInMillis = Long.MAX_VALUE;
        Set<ExecutableState> states = this.convertStatusEnumToStates(statusList);
        final Map<String, ExecutableOutputPO> allOutputDigests = this.getExecutableManager().getAllOutputDigests(timeStartInMillis, timeEndInMillis);
        return Lists.newArrayList(FluentIterable.from(this.innerSearchCheckpointJobsV2(cubeName, jobName, states, timeStartInMillis, timeEndInMillis, allOutputDigests, false, projectName)).transform(new Function<CheckpointExecutable, JobSearchResult>(){

            @Override
            public JobSearchResult apply(CheckpointExecutable checkpointExecutable) {
                return JobInfoConverter.parseToJobSearchResult(checkpointExecutable, allOutputDigests);
            }
        }).filter(new Predicate<JobSearchResult>(){

            @Override
            public boolean apply(@Nullable JobSearchResult input) {
                return input != null;
            }
        }));
    }

    public List<CubingJob> innerSearchCubingJobsV2(final String cubeName, final String jobName, final Set<ExecutableState> statusList, long timeStartInMillis, long timeEndInMillis, final Map<String, ExecutableOutputPO> allExecutableOutputPO, final boolean nameExactMatch, final String projectName) {
        ArrayList<CubingJob> results = Lists.newArrayList(FluentIterable.from(this.getExecutableManager().getAllExecutableDigests(timeStartInMillis, timeEndInMillis)).filter(new Predicate<AbstractExecutable>(){

            @Override
            public boolean apply(AbstractExecutable executable) {
                if (executable instanceof CubingJob) {
                    if (StringUtils.isEmpty(cubeName)) {
                        return true;
                    }
                    String executableCubeName = CubingExecutableUtil.getCubeName(executable.getParams());
                    if (executableCubeName == null) {
                        return true;
                    }
                    if (nameExactMatch) {
                        return executableCubeName.equalsIgnoreCase(cubeName);
                    }
                    return executableCubeName.toLowerCase(Locale.ROOT).contains(cubeName.toLowerCase(Locale.ROOT));
                }
                return false;
            }
        }).transform(new Function<AbstractExecutable, CubingJob>(){

            @Override
            public CubingJob apply(AbstractExecutable executable) {
                return (CubingJob)executable;
            }
        }).filter(Predicates.and(new Predicate<CubingJob>(){

            @Override
            public boolean apply(CubingJob executable) {
                if (null == projectName || null == JobService.this.getProjectManager().getProject(projectName)) {
                    return true;
                }
                return projectName.equalsIgnoreCase(executable.getProjectName());
            }
        }, new Predicate<CubingJob>(){

            @Override
            public boolean apply(CubingJob executable) {
                ExecutableOutputPO executableOutputPO = (ExecutableOutputPO)allExecutableOutputPO.get(executable.getId());
                ExecutableState state = ExecutableState.valueOf(executableOutputPO.getStatus());
                return statusList.contains((Object)state);
            }
        }, new Predicate<CubingJob>(){

            @Override
            public boolean apply(@Nullable CubingJob cubeJob) {
                if (cubeJob == null) {
                    return false;
                }
                if (StringUtils.isEmpty(jobName)) {
                    return true;
                }
                if (nameExactMatch) {
                    return cubeJob.getName().equalsIgnoreCase(jobName);
                }
                return cubeJob.getName().toLowerCase(Locale.ROOT).contains(jobName.toLowerCase(Locale.ROOT));
            }
        })));
        return results;
    }

    public List<CheckpointExecutable> innerSearchCheckpointJobsV2(final String cubeName, final String jobName, final Set<ExecutableState> statusList, long timeStartInMillis, long timeEndInMillis, final Map<String, ExecutableOutputPO> allExecutableOutputPO, final boolean nameExactMatch, final String projectName) {
        ArrayList<CheckpointExecutable> results = Lists.newArrayList(FluentIterable.from(this.getExecutableManager().getAllExecutableDigests(timeStartInMillis, timeEndInMillis)).filter(new Predicate<AbstractExecutable>(){

            @Override
            public boolean apply(AbstractExecutable executable) {
                if (executable instanceof CheckpointExecutable) {
                    if (StringUtils.isEmpty(cubeName)) {
                        return true;
                    }
                    String executableCubeName = CubingExecutableUtil.getCubeName(executable.getParams());
                    if (executableCubeName == null) {
                        return true;
                    }
                    if (nameExactMatch) {
                        return executableCubeName.equalsIgnoreCase(cubeName);
                    }
                    return executableCubeName.toLowerCase(Locale.ROOT).contains(cubeName.toLowerCase(Locale.ROOT));
                }
                return false;
            }
        }).transform(new Function<AbstractExecutable, CheckpointExecutable>(){

            @Override
            public CheckpointExecutable apply(AbstractExecutable executable) {
                return (CheckpointExecutable)executable;
            }
        }).filter(Predicates.and(new Predicate<CheckpointExecutable>(){

            @Override
            public boolean apply(CheckpointExecutable executable) {
                if (null == projectName || null == JobService.this.getProjectManager().getProject(projectName)) {
                    return true;
                }
                return projectName.equalsIgnoreCase(executable.getProjectName());
            }
        }, new Predicate<CheckpointExecutable>(){

            @Override
            public boolean apply(CheckpointExecutable executable) {
                ExecutableOutputPO executableOutputPO = (ExecutableOutputPO)allExecutableOutputPO.get(executable.getId());
                ExecutableState state = ExecutableState.valueOf(executableOutputPO.getStatus());
                return statusList.contains((Object)state);
            }
        }, new Predicate<CheckpointExecutable>(){

            @Override
            public boolean apply(@Nullable CheckpointExecutable checkpointExecutable) {
                if (checkpointExecutable == null) {
                    return false;
                }
                if (StringUtils.isEmpty(jobName)) {
                    return true;
                }
                if (nameExactMatch) {
                    return checkpointExecutable.getName().equalsIgnoreCase(jobName);
                }
                return checkpointExecutable.getName().toLowerCase(Locale.ROOT).contains(jobName.toLowerCase(Locale.ROOT));
            }
        })));
        return results;
    }

    public List<CubingJob> listJobsByRealizationName(String realizationName, String projectName, Set<ExecutableState> statusList) {
        return this.innerSearchCubingJobs(realizationName, null, statusList, 0L, Long.MAX_VALUE, this.getExecutableManager().getAllOutputs(), true, projectName);
    }

    public List<CubingJob> listJobsByRealizationName(String realizationName, String projectName) {
        return this.listJobsByRealizationName(realizationName, projectName, EnumSet.allOf(ExecutableState.class));
    }

    public static enum JobSearchMode {
        CUBING_ONLY,
        CHECKPOINT_ONLY,
        ALL;

    }
}

