/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.metrics.MetricsManager;
import org.apache.kylin.metrics.lib.impl.TimePropertyEnum;
import org.apache.kylin.metrics.property.JobPropertyEnum;
import org.apache.kylin.metrics.property.QuerySparkExecutionEnum;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.request.PrepareSqlRequest;
import org.apache.kylin.rest.response.MetricsResponse;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.CubeService;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="dashboardService")
public class DashboardService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(DashboardService.class);
    @Autowired
    private CubeService cubeService;

    public MetricsResponse getCubeMetrics(String projectName, String cubeName) {
        MetricsResponse cubeMetrics = new MetricsResponse();
        Float totalCubeSize = Float.valueOf(0.0f);
        long totalRecoadSize = 0L;
        List<CubeInstance> cubeInstances = this.cubeService.listAllCubes(cubeName, projectName, null, true);
        Integer totalCube = cubeInstances.size();
        if (projectName == null) {
            totalCube = totalCube + this.getHybridManager().listHybridInstances().size();
        } else {
            ProjectInstance project = this.getProjectManager().getProject(projectName);
            totalCube = totalCube + project.getRealizationCount(RealizationType.HYBRID);
        }
        Float minCubeExpansion = Float.valueOf(Float.POSITIVE_INFINITY);
        Float maxCubeExpansion = Float.valueOf(Float.NEGATIVE_INFINITY);
        cubeMetrics.increase("totalCube", Float.valueOf(totalCube.floatValue()));
        for (CubeInstance cubeInstance : cubeInstances) {
            if (cubeInstance.getInputRecordSizeBytes() <= 0L) continue;
            totalCubeSize = Float.valueOf(totalCubeSize.floatValue() + (float)cubeInstance.getSizeKB());
            totalRecoadSize += cubeInstance.getInputRecordSizeBytes();
            Float cubeExpansion = Float.valueOf(new Float(cubeInstance.getSizeKB()).floatValue() * 1024.0f / (float)cubeInstance.getInputRecordSizeBytes());
            if (cubeExpansion.floatValue() > maxCubeExpansion.floatValue()) {
                maxCubeExpansion = cubeExpansion;
            }
            if (!(cubeExpansion.floatValue() < minCubeExpansion.floatValue())) continue;
            minCubeExpansion = cubeExpansion;
        }
        Float avgCubeExpansion = Float.valueOf(0.0f);
        if (totalRecoadSize != 0L) {
            avgCubeExpansion = Float.valueOf(totalCubeSize.floatValue() * 1024.0f / (float)totalRecoadSize);
        }
        cubeMetrics.increase("avgCubeExpansion", avgCubeExpansion);
        cubeMetrics.increase("maxCubeExpansion", Float.valueOf(maxCubeExpansion.floatValue() == Float.NEGATIVE_INFINITY ? 0.0f : maxCubeExpansion.floatValue()));
        cubeMetrics.increase("minCubeExpansion", Float.valueOf(minCubeExpansion.floatValue() == Float.POSITIVE_INFINITY ? 0.0f : minCubeExpansion.floatValue()));
        return cubeMetrics;
    }

    private List<CubeInstance> getCubeByHybrid(HybridInstance hybridInstance) {
        ArrayList<CubeInstance> cubeInstances = Lists.newArrayList();
        List<RealizationEntry> realizationEntries = hybridInstance.getRealizationEntries();
        for (RealizationEntry realizationEntry : realizationEntries) {
            String reName = realizationEntry.getRealization();
            if (RealizationType.CUBE == realizationEntry.getType()) {
                CubeInstance cubeInstance = this.getCubeManager().getCube(reName);
                cubeInstances.add(cubeInstance);
                continue;
            }
            if (RealizationType.HYBRID != realizationEntry.getType()) continue;
            HybridInstance innerHybridInstance = this.getHybridManager().getHybridInstance(reName);
            cubeInstances.addAll(this.getCubeByHybrid(innerHybridInstance));
        }
        return cubeInstances;
    }

    public PrepareSqlRequest getQueryMetricsSQLRequest(String startTime, String endTime, String projectName, String cubeName) {
        String[] metrics = new String[]{QueryMetricEnum.QUERY_COUNT.toSQL(), QueryMetricEnum.AVG_QUERY_LATENCY.toSQL(), QueryMetricEnum.MAX_QUERY_LATENCY.toSQL(), QueryMetricEnum.MIN_QUERY_LATENCY.toSQL()};
        Map<String, String> filterMap = this.getBaseFilterMap(CategoryEnum.QUERY, projectName, startTime, endTime);
        filterMap.putAll(this.getCubeFilterMap(CategoryEnum.QUERY, cubeName));
        this.getMetricsManager();
        return this.createPrepareSqlRequest(null, metrics, MetricsManager.getSystemTableFromSubject(this.getConfig().getKylinMetricsSubjectQueryExecution()), filterMap);
    }

    public PrepareSqlRequest getJobMetricsSQLRequest(String startTime, String endTime, String projectName, String cubeName) {
        String[] metrics = new String[]{JobMetricEnum.JOB_COUNT.toSQL(), JobMetricEnum.AVG_JOB_BUILD_TIME.toSQL(), JobMetricEnum.MAX_JOB_BUILD_TIME.toSQL(), JobMetricEnum.MIN_JOB_BUILD_TIME.toSQL()};
        Map<String, String> filterMap = this.getBaseFilterMap(CategoryEnum.JOB, projectName, startTime, endTime);
        filterMap.putAll(this.getCubeFilterMap(CategoryEnum.JOB, cubeName));
        this.getMetricsManager();
        return this.createPrepareSqlRequest(null, metrics, MetricsManager.getSystemTableFromSubject(this.getConfig().getKylinMetricsSubjectJob()), filterMap);
    }

    public PrepareSqlRequest getChartSQLRequest(String startTime, String endTime, String projectName, String cubeName, String dimension, String metric, String category) {
        try {
            CategoryEnum categoryEnum = CategoryEnum.valueOf(category);
            String table = "";
            String[] dimensionSQL = null;
            String[] metricSQL = null;
            if (categoryEnum == CategoryEnum.QUERY) {
                dimensionSQL = new String[]{QueryDimensionEnum.valueOf(dimension).toSQL()};
                metricSQL = new String[]{QueryMetricEnum.valueOf(metric).toSQL()};
                this.getMetricsManager();
                table = MetricsManager.getSystemTableFromSubject(this.getConfig().getKylinMetricsSubjectQueryExecution());
            } else if (categoryEnum == CategoryEnum.JOB) {
                dimensionSQL = new String[]{JobDimensionEnum.valueOf(dimension).toSQL()};
                metricSQL = new String[]{JobMetricEnum.valueOf(metric).toSQL()};
                this.getMetricsManager();
                table = MetricsManager.getSystemTableFromSubject(this.getConfig().getKylinMetricsSubjectJob());
            }
            Map<String, String> filterMap = this.getBaseFilterMap(categoryEnum, projectName, startTime, endTime);
            filterMap.putAll(this.getCubeFilterMap(categoryEnum, cubeName));
            return this.createPrepareSqlRequest(dimensionSQL, metricSQL, table, filterMap);
        }
        catch (IllegalArgumentException e) {
            String message = "Generate dashboard chart sql failed. Please double check the input parameter: dimension, metric or category.";
            logger.error(message, e);
            throw new BadRequestException(message + " Caused by: " + e.getMessage(), null, e.getCause());
        }
    }

    public MetricsResponse transformChartData(SQLResponse sqlResponse) {
        if (!sqlResponse.getIsException()) {
            MetricsResponse metrics = new MetricsResponse();
            List<List<String>> results = sqlResponse.getResults();
            for (List<String> result : results) {
                String dimension = result.get(0);
                if (dimension == null || dimension.isEmpty()) continue;
                String metric = result.get(1);
                metrics.increase(dimension, this.getMetricValue(metric));
            }
            return metrics;
        }
        return null;
    }

    public Float getMetricValue(String value) {
        if (value == null || value.isEmpty()) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(value);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(#project, 'ADMINISTRATION')")
    public void checkAuthorization(ProjectInstance project) throws AccessDeniedException {
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void checkAuthorization() throws AccessDeniedException {
    }

    private Map<String, String> getBaseFilterMap(CategoryEnum category, String projectName, String startTime, String endTime) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        String project = "";
        project = category == CategoryEnum.QUERY ? QueryDimensionEnum.PROJECT.toSQL() : JobDimensionEnum.PROJECT.toSQL();
        filterMap.put(TimePropertyEnum.DAY_DATE.toString() + " >= ?", startTime);
        filterMap.put(TimePropertyEnum.DAY_DATE.toString() + " <= ?", endTime);
        if (!Strings.isNullOrEmpty(projectName)) {
            filterMap.put(project + " = ?", projectName.toUpperCase(Locale.ROOT));
        } else {
            filterMap.put(project + " <> ?", "KYLIN_SYSTEM");
        }
        return filterMap;
    }

    private Map<String, String> getCubeFilterMap(CategoryEnum category, String cubeName) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        if (category == CategoryEnum.QUERY) {
            filterMap.put(QuerySparkExecutionEnum.EXCEPTION.toString() + " = ?", "NULL");
            if (!Strings.isNullOrEmpty(cubeName)) {
                filterMap.put((Object)((Object)QuerySparkExecutionEnum.REALIZATION) + " = ?", cubeName);
            }
        } else if (category == CategoryEnum.JOB && !Strings.isNullOrEmpty(cubeName)) {
            HybridInstance hybridInstance = this.getHybridManager().getHybridInstance(cubeName);
            if (null != hybridInstance) {
                StringBuffer cubeNames = new StringBuffer();
                for (CubeInstance cube : this.getCubeByHybrid(hybridInstance)) {
                    cubeNames.append(",'" + cube.getName() + "'");
                }
                filterMap.put(JobPropertyEnum.CUBE.toString() + " IN (?)", cubeNames.substring(1));
            } else {
                filterMap.put(JobPropertyEnum.CUBE.toString() + " = ?", cubeName);
            }
        }
        return filterMap;
    }

    private PrepareSqlRequest createPrepareSqlRequest(String[] dimensions, String[] metrics, String category, Map<String, String> filterMap) {
        PrepareSqlRequest sqlRequest = new PrepareSqlRequest();
        sqlRequest.setProject("KYLIN_SYSTEM");
        StringBuffer baseSQL = new StringBuffer("select ");
        StringBuffer groupBy = new StringBuffer("");
        if (dimensions != null && dimensions.length > 0) {
            groupBy.append(" group by ");
            StringBuffer dimensionSQL = new StringBuffer("");
            for (String dimension : dimensions) {
                dimensionSQL.append(",");
                dimensionSQL.append(dimension);
            }
            baseSQL.append(dimensionSQL.substring(1));
            groupBy.append(dimensionSQL.substring(1));
        }
        if (metrics != null && metrics.length > 0) {
            StringBuffer metricSQL = new StringBuffer("");
            for (String metric : metrics) {
                metricSQL.append(",");
                metricSQL.append(metric);
            }
            if (groupBy.length() > 0) {
                baseSQL.append(metricSQL);
            } else {
                baseSQL.append(metricSQL.substring(1));
            }
        }
        baseSQL.append(" from ");
        baseSQL.append(category);
        if (filterMap != null && filterMap.size() > 0) {
            PrepareSqlRequest.StateParam[] params = new PrepareSqlRequest.StateParam[filterMap.size()];
            int i = 0;
            StringBuffer filterSQL = new StringBuffer(" where ");
            Iterator<String> it = filterMap.keySet().iterator();
            String filter2 = it.next();
            filterSQL.append(filter2);
            params[i] = new PrepareSqlRequest.StateParam();
            params[i].setClassName("java.lang.String");
            params[i++].setValue(filterMap.get(filter2));
            while (it.hasNext()) {
                filter2 = it.next();
                filterSQL.append(" and ");
                filterSQL.append(filter2);
                params[i] = new PrepareSqlRequest.StateParam();
                params[i].setClassName("java.lang.String");
                params[i++].setValue(filterMap.get(filter2));
            }
            baseSQL.append(filterSQL.toString());
            sqlRequest.setParams(params);
        }
        baseSQL.append(groupBy);
        sqlRequest.setSql(baseSQL.toString());
        return sqlRequest;
    }

    private static enum JobMetricEnum {
        JOB_COUNT("count(*)"),
        AVG_JOB_BUILD_TIME("avg(" + JobPropertyEnum.PER_BYTES_TIME_COST.toString() + ")"),
        MAX_JOB_BUILD_TIME("max(" + JobPropertyEnum.PER_BYTES_TIME_COST.toString() + ")"),
        MIN_JOB_BUILD_TIME("min(" + JobPropertyEnum.PER_BYTES_TIME_COST.toString() + ")");

        private final String sql;

        private JobMetricEnum(String sql2) {
            this.sql = sql2;
        }

        public String toSQL() {
            return this.sql;
        }
    }

    private static enum QueryMetricEnum {
        QUERY_COUNT("count(*)"),
        AVG_QUERY_LATENCY("avg(" + QuerySparkExecutionEnum.TIME_COST.toString() + ")"),
        MAX_QUERY_LATENCY("max(" + QuerySparkExecutionEnum.TIME_COST.toString() + ")"),
        MIN_QUERY_LATENCY("min(" + QuerySparkExecutionEnum.TIME_COST.toString() + ")");

        private final String sql;

        private QueryMetricEnum(String sql2) {
            this.sql = sql2;
        }

        public String toSQL() {
            return this.sql;
        }
    }

    private static enum JobDimensionEnum {
        PROJECT(JobPropertyEnum.PROJECT.toString()),
        CUBE(JobPropertyEnum.CUBE.toString()),
        DAY(TimePropertyEnum.DAY_DATE.toString()),
        WEEK(TimePropertyEnum.WEEK_BEGIN_DATE.toString()),
        MONTH(TimePropertyEnum.MONTH.toString());

        private final String sql;

        private JobDimensionEnum(String sql2) {
            this.sql = sql2;
        }

        public String toSQL() {
            return this.sql;
        }
    }

    private static enum QueryDimensionEnum {
        PROJECT(QuerySparkExecutionEnum.PROJECT.toString()),
        CUBE(QuerySparkExecutionEnum.REALIZATION.toString()),
        DAY(TimePropertyEnum.DAY_DATE.toString()),
        WEEK(TimePropertyEnum.WEEK_BEGIN_DATE.toString()),
        MONTH(TimePropertyEnum.MONTH.toString());

        private final String sql;

        private QueryDimensionEnum(String sql2) {
            this.sql = sql2;
        }

        public String toSQL() {
            return this.sql;
        }
    }

    private static enum CategoryEnum {
        QUERY,
        JOB;

    }
}

