/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import java.io.Serializable;
import java.util.List;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLResponse
implements Serializable {
    protected static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SQLResponse.class);
    protected List<SelectedColumnMeta> columnMetas;
    protected List<List<String>> results;
    protected String cube;
    protected String cuboidIds;
    protected String realizationTypes;
    protected int affectedRowCount;
    protected boolean isException;
    protected String exceptionMessage;
    protected Throwable throwable;
    protected long duration;
    protected boolean isPartial = false;
    protected long totalScanCount;
    protected long totalScanBytes;
    protected long totalScanFiles;
    protected long metadataTime;
    protected long totalSparkScanTime;
    protected boolean hitExceptionCache = false;
    protected boolean storageCacheUsed = false;
    protected boolean queryPushDown = false;
    protected String querySparkPool;
    protected byte[] queryStatistics;
    protected String traceUrl = null;
    protected String signature;
    protected long lazyQueryStartTime = -1L;

    public SQLResponse() {
    }

    public SQLResponse(List<SelectedColumnMeta> columnMetas, List<List<String>> results, int affectedRowCount, boolean isException, String exceptionMessage) {
        this.columnMetas = columnMetas;
        this.results = results;
        this.affectedRowCount = affectedRowCount;
        this.isException = isException;
        this.exceptionMessage = exceptionMessage;
    }

    public SQLResponse(List<SelectedColumnMeta> columnMetas, List<List<String>> results, String cube, int affectedRowCount, boolean isException, String exceptionMessage, boolean isPartial, boolean isPushDown) {
        this.columnMetas = columnMetas;
        this.results = results;
        this.cube = cube;
        this.affectedRowCount = affectedRowCount;
        this.isException = isException;
        this.exceptionMessage = exceptionMessage;
        this.isPartial = isPartial;
        this.queryPushDown = isPushDown;
    }

    public List<SelectedColumnMeta> getColumnMetas() {
        return this.columnMetas;
    }

    public List<List<String>> getResults() {
        return this.results;
    }

    public void setResults(List<List<String>> results) {
        this.results = results;
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public String getCuboidIds() {
        return this.cuboidIds;
    }

    public void setCuboidIds(String cuboidIds) {
        this.cuboidIds = cuboidIds;
    }

    public int getAffectedRowCount() {
        return this.affectedRowCount;
    }

    public boolean getIsException() {
        return this.isException;
    }

    public void setIsException(boolean v) {
        this.isException = v;
    }

    public String getSparkPool() {
        return this.querySparkPool;
    }

    public void setSparkPool(String sparkPool) {
        this.querySparkPool = sparkPool;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String msg) {
        this.exceptionMessage = msg;
    }

    @JsonIgnore
    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public boolean isPushDown() {
        return this.queryPushDown;
    }

    public long getTotalScanCount() {
        return this.totalScanCount;
    }

    public void setTotalScanCount(long totalScanCount) {
        this.totalScanCount = totalScanCount;
    }

    public long getTotalScanBytes() {
        return this.totalScanBytes;
    }

    public void setTotalScanBytes(long totalScanBytes) {
        this.totalScanBytes = totalScanBytes;
    }

    public long getTotalScanFiles() {
        return this.totalScanFiles;
    }

    public void setTotalScanFiles(long totalScanFiles) {
        this.totalScanFiles = totalScanFiles;
    }

    public long getMetadataTime() {
        return this.metadataTime;
    }

    public void setMetadataTime(long metadataTime) {
        this.metadataTime = metadataTime;
    }

    public long getTotalSparkScanTime() {
        return this.totalSparkScanTime;
    }

    public void setTotalSparkScanTime(long totalSparkScanTime) {
        this.totalSparkScanTime = totalSparkScanTime;
    }

    public boolean isHitExceptionCache() {
        return this.hitExceptionCache;
    }

    public void setHitExceptionCache(boolean hitExceptionCache) {
        this.hitExceptionCache = hitExceptionCache;
    }

    public boolean isStorageCacheUsed() {
        return this.storageCacheUsed;
    }

    public void setStorageCacheUsed(boolean storageCacheUsed) {
        this.storageCacheUsed = storageCacheUsed;
    }

    public String getTraceUrl() {
        return this.traceUrl;
    }

    public void setTraceUrl(String traceUrl) {
        this.traceUrl = traceUrl;
    }

    @JsonIgnore
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    @JsonIgnore
    public boolean isRunning() {
        return this.lazyQueryStartTime >= 0L;
    }

    @JsonIgnore
    public long getLazyQueryStartTime() {
        return this.lazyQueryStartTime;
    }

    public void setLazyQueryStartTime(long lazyQueryStartTime) {
        this.lazyQueryStartTime = lazyQueryStartTime;
    }

    public String getRealizationTypes() {
        return this.realizationTypes;
    }

    public void setRealizationTypes(String realizationTypes) {
        this.realizationTypes = realizationTypes;
    }

    @JsonIgnore
    public List<QueryContext.CubeSegmentStatisticsResult> getCubeSegmentStatisticsList() {
        try {
            return this.queryStatistics == null ? Lists.newArrayList() : (List)SerializationUtils.deserialize(this.queryStatistics);
        }
        catch (Exception e) {
            logger.warn("Error while deserialize queryStatistics due to " + e);
            return Lists.newArrayList();
        }
    }

    public void setCubeSegmentStatisticsList(List<QueryContext.CubeSegmentStatisticsResult> cubeSegmentStatisticsList) {
        try {
            this.queryStatistics = cubeSegmentStatisticsList == null ? null : SerializationUtils.serialize((Serializable)((Object)cubeSegmentStatisticsList));
        }
        catch (Exception e) {
            logger.warn("Error while serialize queryStatistics due to " + e);
            this.queryStatistics = null;
        }
    }
}

