/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.TempStatementManager;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;

public class TempStatementUtil {
    private static final String WITH = "WITH";
    private static final String DROP = "DROP";
    private static final String CREATE = "CREATE";

    public static Pair<Boolean, String> handleTempStatement(String sql2, KylinConfig config) {
        if (!config.isConvertCreateTableToWith()) {
            return new Pair<Boolean, String>(false, sql2);
        }
        if (TempStatementUtil.isDropTable(sql2)) {
            return new Pair<Boolean, String>(true, sql2);
        }
        if (TempStatementUtil.isCreateTable(sql2)) {
            try {
                TempStatementUtil.translateCreateToWith(sql2, config);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return new Pair<Boolean, String>(true, sql2);
        }
        sql2 = TempStatementUtil.appendWith(sql2, config);
        return new Pair<Boolean, String>(false, sql2);
    }

    private static void translateCreateToWith(String sql2, KylinConfig config) throws IOException {
        Pair<String, String> translated = TempStatementUtil.translateCreateToWithInternal(sql2);
        String identifier = translated.getFirst();
        String sql1 = translated.getSecond();
        TempStatementManager manager = TempStatementManager.getInstance(config);
        if (manager.getTempStatement(identifier) == null || !manager.getTempStatement(identifier).equals(sql1)) {
            manager.updateTempStatement(identifier, sql1);
        }
    }

    static Pair<String, String> translateCreateToWithInternal(String sql2) {
        String sql1 = sql2.trim();
        if (sql1.endsWith(";")) {
            sql1 = sql1.substring(0, sql1.length() - 1);
        }
        if (sql1.matches("(?i)^CREATE\\s+TABLE\\p{all}*")) {
            sql1 = sql1.replaceAll("(?i)CREATE\\s+TABLE", WITH);
        } else if (sql1.matches("(?i)^CREATE\\s+TEMPORARY\\s+TABLE\\p{all}*")) {
            sql1 = sql1.replaceAll("(?i)CREATE\\s+TEMPORARY\\s+TABLE", WITH);
        } else {
            throw new RuntimeException("Sql " + sql2 + " is not create table sql");
        }
        Object identifier = null;
        Object[] splits = sql1.split("((?<=\\s)|(?=\\s))");
        Pattern spacePattern = Pattern.compile("\\s");
        ParserState state = ParserState.WAITING_WITH;
        block6: for (int i = 0; i < splits.length && state != ParserState.IGNORE; ++i) {
            if (spacePattern.matcher((CharSequence)splits[i]).matches()) continue;
            switch (state) {
                case WAITING_WITH: {
                    if (!((String)splits[i]).equals(WITH)) {
                        throw new RuntimeException("the translated sql should start with \"WITH\", sql is " + sql1);
                    }
                    state = ParserState.WAITING_IDENTIFIER;
                    continue block6;
                }
                case WAITING_IDENTIFIER: {
                    identifier = splits[i];
                    state = ParserState.WAITING_AS;
                    continue block6;
                }
                case WAITING_AS: {
                    if (!((String)splits[i]).equalsIgnoreCase("AS")) {
                        throw new RuntimeException("the translated sql should contains \"AS\", sql is " + sql1);
                    }
                    state = ParserState.WAITING_LEFT_PAREN;
                    continue block6;
                }
                case WAITING_LEFT_PAREN: {
                    if (!((String)splits[i]).startsWith("(")) {
                        splits[i] = "(" + (String)splits[i];
                        splits[splits.length - 1] = (String)splits[splits.length - 1] + ")";
                    }
                    state = ParserState.IGNORE;
                    continue block6;
                }
            }
        }
        sql1 = StringUtils.join(splits, "", 1, splits.length);
        return new Pair<Object, String>(identifier, sql1);
    }

    private static boolean isCreateTable(String sql2) {
        return sql2.trim().toUpperCase(Locale.ROOT).startsWith(CREATE);
    }

    private static boolean isDropTable(String sql2) {
        return sql2.trim().toUpperCase(Locale.ROOT).startsWith(DROP);
    }

    private static boolean isWith(String sql2) {
        return sql2.trim().toUpperCase(Locale.ROOT).startsWith(WITH);
    }

    private static String appendWith(String sql2, KylinConfig config) {
        if (!config.isConvertCreateTableToWith() || TempStatementUtil.isWith(sql2)) {
            return sql2;
        }
        String[] splits = sql2.split("\\W+");
        StringBuilder builder = new StringBuilder();
        HashSet<String> appended = new HashSet<String>();
        TempStatementManager manager = TempStatementManager.getInstance(config);
        for (String s : splits) {
            if (manager.getTempStatement(s) == null || appended.contains(s)) continue;
            appended.add(s);
            if (appended.size() == 1) {
                builder.append(WITH);
            } else {
                builder.append(",");
            }
            builder.append(manager.getTempStatement(s)).append(" ");
        }
        return builder.append(sql2).toString();
    }

    private static enum ParserState {
        WAITING_WITH,
        WAITING_IDENTIFIER,
        WAITING_AS,
        WAITING_LEFT_PAREN,
        IGNORE;

    }
}

