/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.common.exceptions.KylinTimeoutException;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.metadata.realization.RoutingIndicatorException;
import org.apache.kylin.query.adhoc.PushDownRunnerJdbcImpl;
import org.apache.kylin.query.security.AccessDeniedException;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.kylin.source.adhocquery.IPushDownRunner;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.exception.ExceptionUtils;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushDownExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PushDownExecutor.class);
    private KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();

    public Pair<List<List<String>>, List<SelectedColumnMeta>> pushDownQuery(String project, String sql2, String defaultSchema, SQLException sqlException, boolean isSelect, boolean isPrepare) throws Exception {
        List<String> ids;
        if (!this.kylinConfig.isPushDownEnabled()) {
            return null;
        }
        if (isSelect) {
            logger.info("Query failed to utilize pre-calculation, routing to other engines", sqlException);
            if (!PushDownExecutor.isExpectedCause(sqlException)) {
                logger.info("quit doPushDownQuery because prior exception thrown is unexpected");
                return null;
            }
        } else {
            Preconditions.checkState((sqlException == null ? 1 : 0) != 0);
            logger.info("Kylin cannot support non-select queries, routing to other engines");
        }
        if ((ids = this.kylinConfig.getPushDownRunnerIds()).isEmpty() && StringUtils.isNotEmpty(this.kylinConfig.getPushDownRunnerClassName())) {
            IPushDownRunner runner = (IPushDownRunner)ClassUtil.newInstance(this.kylinConfig.getPushDownRunnerClassName());
            runner.init(this.kylinConfig);
            return this.queryBySingleRunner(runner, project, sql2, defaultSchema, sqlException, isSelect, isPrepare);
        }
        return this.queryByMultiJdbcRunners(ids, project, sql2, defaultSchema, sqlException, isSelect, isPrepare);
    }

    private static boolean isExpectedCause(SQLException sqlException) {
        Preconditions.checkArgument((sqlException != null ? 1 : 0) != 0);
        Throwable rootCause = ExceptionUtils.getRootCause(sqlException);
        boolean isPushDownUpdateEnabled = KylinConfig.getInstanceFromEnv().isPushDownUpdateEnabled();
        if (isPushDownUpdateEnabled) {
            return rootCause instanceof NoRealizationFoundException || rootCause instanceof RoutingIndicatorException || rootCause instanceof SqlValidatorException;
        }
        if (rootCause instanceof KylinTimeoutException) {
            return false;
        }
        if (rootCause instanceof AccessDeniedException) {
            return false;
        }
        if (rootCause instanceof RoutingIndicatorException) {
            return true;
        }
        if (rootCause instanceof CompileException) {
            return true;
        }
        if (QueryContextFacade.current().isWithoutSyntaxError()) {
            logger.warn("route to push down for met error when running current query", sqlException);
            return true;
        }
        return false;
    }

    private Pair<List<List<String>>, List<SelectedColumnMeta>> queryBySingleRunner(IPushDownRunner runner, String project, String sql2, String defaultSchema, SQLException sqlException, boolean isSelect, boolean isPrepare) throws Exception {
        logger.debug("Query Pushdown runner {}", (Object)runner);
        if (defaultSchema != null && !defaultSchema.equals("DEFAULT")) {
            String completed = sql2;
            try {
                completed = PushDownUtil.schemaCompletion(sql2, defaultSchema);
            }
            catch (SqlParseException e) {
                logger.debug("fail to do schema completion on the pushdown sql, ignore it.", (Object)e.getMessage());
            }
            if (!sql2.equals(completed)) {
                logger.info("the query is converted to {} after schema completion", (Object)completed);
                sql2 = completed;
            }
        }
        sql2 = runner.convertSql(this.kylinConfig, sql2, project, defaultSchema, isPrepare);
        ArrayList returnRows = Lists.newArrayList();
        ArrayList returnColumnMeta = Lists.newArrayList();
        if (isSelect) {
            runner.executeQuery(sql2, returnRows, returnColumnMeta);
        }
        if (!isSelect && !isPrepare && this.kylinConfig.isPushDownUpdateEnabled()) {
            runner.executeUpdate(sql2);
        }
        return Pair.newPair(returnRows, returnColumnMeta);
    }

    private Pair<List<List<String>>, List<SelectedColumnMeta>> queryByMultiJdbcRunners(List<String> ids, String project, String sql2, String defaultSchema, SQLException sqlException, boolean isSelect, boolean isPrepare) throws Exception {
        for (int i = 0; i < ids.size(); ++i) {
            String id = ids.get(i);
            PushDownRunnerJdbcImpl runner = new PushDownRunnerJdbcImpl();
            runner.initById(this.kylinConfig, id);
            try {
                Pair<List<List<String>>, List<SelectedColumnMeta>> ret = this.queryBySingleRunner(runner, project, sql2, defaultSchema, sqlException, isSelect, isPrepare);
                if (null == ret) continue;
                return ret;
            }
            catch (Exception e) {
                logger.error("Execute pushdown query/update by jdbc runner " + id + " failed: " + ExceptionUtils.getStackTrace(e));
            }
        }
        throw new RuntimeException("Execute pushdown query/update by multi jdbc runners failed");
    }
}

