/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.runtime;

import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.query.DeriveTableColumnInfo;
import org.apache.kylin.shaded.com.google.common.cache.Cache;
import org.apache.kylin.shaded.com.google.common.cache.CacheBuilder;
import org.apache.kylin.shaded.com.google.common.cache.RemovalListener;
import org.apache.kylin.shaded.com.google.common.cache.RemovalNotification;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderContext$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.utils.SparkTypeUtil$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;

public final class SparderLookupManager$
implements Logging {
    public static final SparderLookupManager$ MODULE$;
    private final int DEFAULT_MAXSIZE;
    private final int DEFAULT_EXPIRE_TIME;
    private final TimeUnit DEFAULT_TIME_UNIT;
    private final Cache<String, Dataset<Row>> sourceCache;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparderLookupManager$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public int DEFAULT_MAXSIZE() {
        return this.DEFAULT_MAXSIZE;
    }

    public int DEFAULT_EXPIRE_TIME() {
        return this.DEFAULT_EXPIRE_TIME;
    }

    public TimeUnit DEFAULT_TIME_UNIT() {
        return this.DEFAULT_TIME_UNIT;
    }

    public Cache<String, Dataset<Row>> sourceCache() {
        return this.sourceCache;
    }

    public Dataset<Row> create(String name, String sourcePath, KylinConfig kylinConfig) {
        String[] names = name.split("@");
        String projectName = names[0];
        String tableName = names[1];
        TableMetadataManager metaMgr = TableMetadataManager.getInstance(kylinConfig);
        TableDesc tableDesc = metaMgr.getTableDesc(tableName, projectName);
        ColumnDesc[] columns = tableDesc.getColumns();
        String dfTableName = Integer.toHexString(System.identityHashCode(name));
        StructType schema = StructType$.MODULE$.apply((Seq)package$.MODULE$.Range().apply(0, Predef$.MODULE$.refArrayOps((Object[])columns).size()).map((Function1)new Serializable(columns, dfTableName){
            public static final long serialVersionUID = 0L;
            private final ColumnDesc[] columns$1;
            private final String dfTableName$1;

            public final StructField apply(int index) {
                return new StructField(new DeriveTableColumnInfo(this.dfTableName$1, index, this.columns$1[index].getName()).toString(), SparkTypeUtil$.MODULE$.toSparkType(this.columns$1[index].getType(), SparkTypeUtil$.MODULE$.toSparkType$default$2()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
            {
                this.columns$1 = columns$1;
                this.dfTableName$1 = dfTableName$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()));
        String rsourcePath = new StringBuilder().append((Object)kylinConfig.getReadHdfsWorkingDirectory()).append((Object)sourcePath).toString();
        return SparderContext$.MODULE$.getSparkSession().read().schema(StructType$.MODULE$.apply(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tableDesc.getColumns()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(ColumnDesc column) {
                return new StructField(column.getName(), SparkTypeUtil$.MODULE$.toSparkType(column.getType(), SparkTypeUtil$.MODULE$.toSparkType$default$2()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))).toSeq())).parquet(rsourcePath).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])schema.fieldNames()));
    }

    public Dataset<Row> getOrCreate(String name, String sourcePath, KylinConfig kylinConfig) {
        Dataset<Row> value = this.sourceCache().getIfPresent(sourcePath);
        return value == null ? this.create(name, sourcePath, kylinConfig) : value;
    }

    private SparderLookupManager$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.DEFAULT_MAXSIZE = 100;
        this.DEFAULT_EXPIRE_TIME = 1;
        this.DEFAULT_TIME_UNIT = TimeUnit.HOURS;
        this.sourceCache = CacheBuilder.newBuilder().maximumSize(this.DEFAULT_MAXSIZE()).expireAfterWrite(this.DEFAULT_EXPIRE_TIME(), this.DEFAULT_TIME_UNIT()).removalListener(new RemovalListener<String, Dataset<Row>>(){

            public void onRemoval(RemovalNotification<String, Dataset<Row>> notification) {
                SparderLookupManager$.MODULE$.logInfo((Function0<String>)new Serializable(this, notification){
                    public static final long serialVersionUID = 0L;
                    private final RemovalNotification notification$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Remove lookup table from spark : ").append(this.notification$1.getKey()).toString();
                    }
                    {
                        this.notification$1 = notification$1;
                    }
                });
                ((Dataset)notification.getValue()).unpersist();
            }
        }).build();
    }
}

