/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinsTree;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.QueryRouter;
import org.apache.kylin.query.routing.RealizationCheck;
import org.apache.kylin.query.routing.rules.RemoveBlackoutRealizationsRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealizationChooser {
    private static final Logger logger = LoggerFactory.getLogger(RealizationChooser.class);

    public static void selectRealization(List<OLAPContext> contexts) {
        for (OLAPContext ctx : contexts) {
            ctx.realizationCheck = new RealizationCheck();
            RealizationChooser.attemptSelectRealization(ctx);
            Preconditions.checkNotNull((Object)ctx.realization);
        }
    }

    private static void attemptSelectRealization(OLAPContext context) {
        Map<String, String> aliasMap;
        DataModelDesc model;
        Map<DataModelDesc, Set<IRealization>> modelMap = RealizationChooser.makeOrderedModelMap(context);
        if (modelMap.size() == 0) {
            throw new NoRealizationFoundException("No model found for " + RealizationChooser.toErrorMsg(context));
        }
        if (BackdoorToggles.getCheckAllModels()) {
            for (Map.Entry<DataModelDesc, Set<IRealization>> entry : modelMap.entrySet()) {
                model = entry.getKey();
                aliasMap = RealizationChooser.matches(model, context);
                if (aliasMap == null) continue;
                context.fixModel(model, aliasMap);
                QueryRouter.selectRealization(context, entry.getValue());
                context.unfixModel();
            }
        }
        for (Map.Entry<DataModelDesc, Set<IRealization>> entry : modelMap.entrySet()) {
            model = entry.getKey();
            aliasMap = RealizationChooser.matches(model, context);
            if (aliasMap == null) continue;
            context.fixModel(model, aliasMap);
            IRealization realization = QueryRouter.selectRealization(context, entry.getValue());
            if (realization == null) {
                logger.info("Give up on model {} because no suitable realization is found", (Object)model);
                context.unfixModel();
                continue;
            }
            context.realization = realization;
            return;
        }
        throw new NoRealizationFoundException("No realization found for " + RealizationChooser.toErrorMsg(context));
    }

    private static String toErrorMsg(OLAPContext ctx) {
        StringBuilder buf = new StringBuilder("OLAPContext");
        RealizationCheck checkResult = ctx.realizationCheck;
        for (RealizationCheck.IncapableReason incapableReason : checkResult.getCubeIncapableReasons().values()) {
            buf.append(", ").append(incapableReason);
        }
        for (List list : checkResult.getModelIncapableReasons().values()) {
            for (RealizationCheck.IncapableReason reason : list) {
                buf.append(", ").append(reason);
            }
        }
        buf.append(", ").append(ctx.firstTableScan);
        for (JoinDesc joinDesc : ctx.joins) {
            buf.append(", ").append(joinDesc);
        }
        return buf.toString();
    }

    private static Map<String, String> matches(DataModelDesc model, OLAPContext ctx) {
        HashMap result = Maps.newHashMap();
        TableRef firstTable = ctx.firstTableScan.getTableRef();
        Object matchUp = null;
        if (ctx.joins.isEmpty() && model.isLookupTable(firstTable.getTableIdentity())) {
            String modelAlias = model.findFirstTable(firstTable.getTableIdentity()).getAlias();
            matchUp = ImmutableMap.of((Object)firstTable.getAlias(), (Object)modelAlias);
        } else {
            if (ctx.joins.size() != ctx.allTableScans.size() - 1) {
                ctx.realizationCheck.addModelIncapableReason(model, RealizationCheck.IncapableReason.create(RealizationCheck.IncapableType.MODEL_BAD_JOIN_SEQUENCE));
                throw new IllegalStateException("Please adjust the sequence of join tables. " + RealizationChooser.toErrorMsg(ctx));
            }
            if (ctx.joinsTree == null) {
                ctx.joinsTree = new JoinsTree(firstTable, ctx.joins);
            }
            matchUp = ctx.joinsTree.matches(model.getJoinsTree(), result);
        }
        if (matchUp == null) {
            ctx.realizationCheck.addModelIncapableReason(model, RealizationCheck.IncapableReason.create(RealizationCheck.IncapableType.MODEL_UNMATCHED_JOIN));
            return null;
        }
        result.putAll(matchUp);
        ctx.realizationCheck.addCapableModel(model, result);
        return result;
    }

    private static Map<DataModelDesc, Set<IRealization>> makeOrderedModelMap(OLAPContext context) {
        OLAPContext first = context;
        KylinConfig kylinConfig = first.olapSchema.getConfig();
        String projectName = first.olapSchema.getProjectName();
        String factTableName = first.firstTableScan.getOlapTable().getTableName();
        Set<IRealization> realizations = ProjectManager.getInstance(kylinConfig).getRealizationsByTable(projectName, factTableName);
        HashMap models = Maps.newHashMap();
        final HashMap costs = Maps.newHashMap();
        for (IRealization real : realizations) {
            if (!real.isReady()) {
                context.realizationCheck.addIncapableCube(real, RealizationCheck.IncapableReason.create(RealizationCheck.IncapableType.CUBE_NOT_READY));
                continue;
            }
            if (!RealizationChooser.containsAll(real.getAllColumnDescs(), first.allColumns)) {
                context.realizationCheck.addIncapableCube(real, RealizationCheck.IncapableReason.notContainAllColumn(RealizationChooser.notContain(real.getAllColumnDescs(), first.allColumns)));
                continue;
            }
            if (!RemoveBlackoutRealizationsRule.accept(real)) {
                context.realizationCheck.addIncapableCube(real, RealizationCheck.IncapableReason.create(RealizationCheck.IncapableType.CUBE_BLACK_OUT_REALIZATION));
                continue;
            }
            RealizationCost cost = new RealizationCost(real);
            DataModelDesc m = real.getModel();
            Set set = (Set)models.get(m);
            if (set == null) {
                set = Sets.newHashSet();
                set.add(real);
                models.put(m, set);
                costs.put(m, cost);
                continue;
            }
            set.add(real);
            RealizationCost curCost = (RealizationCost)costs.get(m);
            if (cost.compareTo(curCost) >= 0) continue;
            costs.put(m, cost);
        }
        TreeMap result = Maps.newTreeMap((Comparator)new Comparator<DataModelDesc>(){

            @Override
            public int compare(DataModelDesc o1, DataModelDesc o2) {
                RealizationCost c2;
                RealizationCost c1 = (RealizationCost)costs.get(o1);
                int comp = c1.compareTo(c2 = (RealizationCost)costs.get(o2));
                if (comp == 0) {
                    comp = o1.getName().compareTo(o2.getName());
                }
                return comp;
            }
        });
        result.putAll(models);
        return result;
    }

    private static boolean containsAll(Set<ColumnDesc> allColumnDescs, Set<TblColRef> allColumns) {
        for (TblColRef col : allColumns) {
            if (allColumnDescs.contains(col.getColumnDesc())) continue;
            return false;
        }
        return true;
    }

    private static List<TblColRef> notContain(Set<ColumnDesc> allColumnDescs, Set<TblColRef> allColumns) {
        ArrayList notContainCols = Lists.newArrayList();
        for (TblColRef col : allColumns) {
            if (allColumnDescs.contains(col.getColumnDesc())) continue;
            notContainCols.add(col);
        }
        return notContainCols;
    }

    private static class RealizationCost
    implements Comparable<RealizationCost> {
        public final int priority;
        public final int cost;

        public RealizationCost(IRealization real) {
            this.priority = Candidate.PRIORITIES.get((Object)real.getType());
            this.cost = real.getCost();
        }

        @Override
        public int compareTo(RealizationCost o) {
            int comp = this.priority - o.priority;
            if (comp != 0) {
                return comp;
            }
            return this.cost - o.cost;
        }
    }
}

